/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.format.toml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceLocation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;

public class TomlSourceWalker
implements SourceWalker {
    private static final Pattern SECTION_PATTERN = Pattern.compile("^\\s*\\[([^\\[\\]]+)]\\s*$");
    private static final Pattern ARRAY_OF_TABLES_PATTERN = Pattern.compile("^\\s*\\[\\[([^\\[\\]]+)]]\\s*$");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^\\s*([^=]+?)\\s*=\\s*(.*)$");
    private final Map<ConfigPath, SourceLocation> pathToLocation = new LinkedHashMap<ConfigPath, SourceLocation>();

    public TomlSourceWalker(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        this.parse(content);
    }

    public static TomlSourceWalker of(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        return new TomlSourceWalker(content);
    }

    @Override
    public SourceLocation findPath(@NonNull ConfigPath path) {
        int index;
        int[] range;
        Objects.requireNonNull(path, "path is marked non-null but is null");
        SourceLocation location = this.pathToLocation.get(path);
        if (location != null) {
            return location;
        }
        ConfigPath searchPath = path;
        ConfigPath.PathNode lastNode = null;
        while (location == null && !searchPath.isEmpty()) {
            lastNode = searchPath.getLastNode();
            searchPath = searchPath.parent();
            location = this.pathToLocation.get(searchPath);
        }
        if (location == null || lastNode == null) {
            return null;
        }
        String value = location.getValue();
        if (value == null) {
            return location;
        }
        if (lastNode instanceof ConfigPath.IndexNode && (range = TomlSourceWalker.findArrayElement(value, index = ((ConfigPath.IndexNode)lastNode).getIndex())) != null) {
            return SourceLocation.builder().lineNumber(location.getLineNumber()).rawLine(location.getRawLine()).keyColumn(location.getKeyColumn()).key(location.getKey()).valueColumn(location.getValueColumn() + range[0]).value(value.substring(range[0], range[0] + range[1])).build();
        }
        return location;
    }

    private static int[] findArrayElement(String value, int index) {
        if (!value.startsWith("[") || !value.endsWith("]")) {
            return null;
        }
        int currentIndex = 0;
        int depth = 0;
        int start = -1;
        boolean inString = false;
        char stringChar = '\u0000';
        for (int i = 1; i < value.length() - 1; ++i) {
            char c = value.charAt(i);
            if (!(inString || c != '\"' && c != '\'')) {
                inString = true;
                stringChar = c;
                if (start >= 0 || currentIndex != index) continue;
                start = i;
                continue;
            }
            if (inString && c == stringChar && value.charAt(i - 1) != '\\') {
                inString = false;
                if (currentIndex != index) continue;
                return new int[]{start, i - start + 1};
            }
            if (inString) continue;
            if (c == '[' || c == '{') {
                if (depth == 0 && start < 0 && currentIndex == index) {
                    start = i;
                }
                ++depth;
                continue;
            }
            if (c == ']' || c == '}') {
                if (--depth != 0 || currentIndex != index) continue;
                return new int[]{start, i - start + 1};
            }
            if (c == ',' && depth == 0) {
                if (currentIndex == index && start >= 0) {
                    int end;
                    for (end = i; end > start && Character.isWhitespace(value.charAt(end - 1)); --end) {
                    }
                    return new int[]{start, end - start};
                }
                ++currentIndex;
                start = -1;
                continue;
            }
            if (Character.isWhitespace(c) || start >= 0 || currentIndex != index) continue;
            start = i;
        }
        if (currentIndex == index && start >= 0) {
            int end;
            for (end = value.length() - 1; end > start && Character.isWhitespace(value.charAt(end - 1)); --end) {
            }
            return new int[]{start, end - start};
        }
        return null;
    }

    private void parse(String content) {
        String[] lines = content.split("\n", -1);
        ConfigPath currentSection = ConfigPath.root();
        LinkedHashMap<String, Integer> arrayTableIndices = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < lines.length; ++i) {
            int valueColumn;
            String rawLine = lines[i];
            int lineNumber = i + 1;
            String trimmed = rawLine.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
            Matcher arrayTableMatcher = ARRAY_OF_TABLES_PATTERN.matcher(trimmed);
            if (arrayTableMatcher.matches()) {
                String sectionName = arrayTableMatcher.group(1).trim();
                int index = arrayTableIndices.getOrDefault(sectionName, -1) + 1;
                arrayTableIndices.put(sectionName, index);
                currentSection = TomlSourceWalker.parseDottedPath(sectionName).index(index);
                continue;
            }
            Matcher sectionMatcher = SECTION_PATTERN.matcher(trimmed);
            if (sectionMatcher.matches()) {
                String sectionName = sectionMatcher.group(1).trim();
                currentSection = TomlSourceWalker.parseDottedPath(sectionName);
                continue;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(rawLine);
            if (!keyValueMatcher.matches()) continue;
            String key = keyValueMatcher.group(1).trim();
            String value = keyValueMatcher.group(2).trim();
            if (key.startsWith("\"") && key.endsWith("\"") || key.startsWith("'") && key.endsWith("'")) {
                key = key.substring(1, key.length() - 1);
            }
            ConfigPath fullPath = TomlSourceWalker.appendDottedPath(currentSection, key);
            int keyColumn = rawLine.indexOf(key);
            int equalsPos = TomlSourceWalker.findEqualsIndex(rawLine);
            for (valueColumn = equalsPos + 1; valueColumn < rawLine.length() && Character.isWhitespace(rawLine.charAt(valueColumn)); ++valueColumn) {
            }
            if (value.isEmpty()) {
                valueColumn = -1;
                value = null;
            }
            SourceLocation location = SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(keyColumn).key(key).valueColumn(valueColumn).value(value).build();
            this.pathToLocation.put(fullPath, location);
        }
    }

    private static int findEqualsIndex(String line) {
        boolean inString = false;
        char stringChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inString) {
                if (c != stringChar || i != 0 && line.charAt(i - 1) == '\\') continue;
                inString = false;
                continue;
            }
            if (c == '\"' || c == '\'') {
                inString = true;
                stringChar = c;
                continue;
            }
            if (c != '=') continue;
            return i;
        }
        return -1;
    }

    private static ConfigPath parseDottedPath(String dottedPath) {
        if (dottedPath == null || dottedPath.isEmpty()) {
            return ConfigPath.root();
        }
        String[] parts = dottedPath.split("\\.");
        ConfigPath path = ConfigPath.root();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            path = path.property(part);
        }
        return path;
    }

    private static ConfigPath appendDottedPath(ConfigPath base, String dottedKey) {
        String[] parts = dottedKey.split("\\.");
        ConfigPath path = base;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            path = path.property(part);
        }
        return path;
    }
}

