/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.format.ini;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceLocation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;

public class IniSourceWalker
implements SourceWalker {
    private static final Pattern SECTION_PATTERN = Pattern.compile("^\\s*\\[(.+)]\\s*$");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^\\s*([^=;#]+?)\\s*=\\s*(.*)$");
    private final Map<ConfigPath, SourceLocation> pathToLocation = new LinkedHashMap<ConfigPath, SourceLocation>();

    public IniSourceWalker(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        this.parse(content);
    }

    public static IniSourceWalker of(@NonNull String content) {
        Objects.requireNonNull(content, "content is marked non-null but is null");
        return new IniSourceWalker(content);
    }

    @Override
    public SourceLocation findPath(@NonNull ConfigPath path) {
        int index;
        int[] range;
        Objects.requireNonNull(path, "path is marked non-null but is null");
        SourceLocation location = this.pathToLocation.get(path);
        if (location != null) {
            return location;
        }
        ConfigPath searchPath = path;
        ConfigPath.PathNode lastNode = null;
        while (location == null && !searchPath.isEmpty()) {
            lastNode = searchPath.getLastNode();
            searchPath = searchPath.parent();
            location = this.pathToLocation.get(searchPath);
        }
        if (location == null || lastNode == null) {
            return null;
        }
        String value = location.getValue();
        if (value == null) {
            return location;
        }
        if (lastNode instanceof ConfigPath.IndexNode && (range = IniSourceWalker.findCommaSeparatedElement(value, index = ((ConfigPath.IndexNode)lastNode).getIndex())) != null) {
            return SourceLocation.builder().lineNumber(location.getLineNumber()).rawLine(location.getRawLine()).keyColumn(location.getKeyColumn()).key(location.getKey()).valueColumn(location.getValueColumn() + range[0]).value(value.substring(range[0], range[0] + range[1])).build();
        }
        return location;
    }

    private static int[] findCommaSeparatedElement(String value, int index) {
        int currentIndex = 0;
        int start = 0;
        for (int i = 0; i <= value.length(); ++i) {
            if (i != value.length() && value.charAt(i) != ',') continue;
            if (currentIndex == index) {
                return new int[]{start, i - start};
            }
            ++currentIndex;
            start = i + 1;
        }
        return null;
    }

    private void parse(String content) {
        String[] lines = content.split("\n", -1);
        ConfigPath currentSection = ConfigPath.root();
        for (int i = 0; i < lines.length; ++i) {
            int valueColumn;
            String rawLine = lines[i];
            int lineNumber = i + 1;
            String trimmed = rawLine.trim();
            if (trimmed.isEmpty() || trimmed.startsWith(";") || trimmed.startsWith("#")) continue;
            Matcher sectionMatcher = SECTION_PATTERN.matcher(trimmed);
            if (sectionMatcher.matches()) {
                String sectionName = sectionMatcher.group(1).trim();
                currentSection = IniSourceWalker.parseDottedPath(sectionName);
                continue;
            }
            Matcher keyValueMatcher = KEY_VALUE_PATTERN.matcher(rawLine);
            if (!keyValueMatcher.matches()) continue;
            String key = keyValueMatcher.group(1).trim();
            String value = keyValueMatcher.group(2);
            ConfigPath fullPath = IniSourceWalker.appendDottedPath(currentSection, key);
            int keyColumn = rawLine.indexOf(key);
            int equalsPos = rawLine.indexOf(61, keyColumn);
            for (valueColumn = equalsPos + 1; valueColumn < rawLine.length() && Character.isWhitespace(rawLine.charAt(valueColumn)); ++valueColumn) {
            }
            if (value.trim().isEmpty()) {
                valueColumn = -1;
                value = null;
            }
            SourceLocation location = SourceLocation.builder().lineNumber(lineNumber).rawLine(rawLine).keyColumn(keyColumn).key(key).valueColumn(valueColumn).value(value).build();
            this.pathToLocation.put(fullPath, location);
        }
    }

    private static ConfigPath parseDottedPath(String dottedPath) {
        if (dottedPath == null || dottedPath.isEmpty()) {
            return ConfigPath.root();
        }
        String[] parts = dottedPath.split("\\.");
        ConfigPath path = ConfigPath.root();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            path = path.property(part);
        }
        return path;
    }

    private static ConfigPath appendDottedPath(ConfigPath base, String dottedKey) {
        String[] parts = dottedKey.split("\\.");
        ConfigPath path = base;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            path = path.property(part);
        }
        return path;
    }
}

