/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceLocation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;

public final class SourceErrorMarker {
    private static final int MAX_MULTILINE_DISPLAY = 5;
    @NonNull
    private final SourceWalker walker;
    @NonNull
    private final ConfigPath path;
    private final String sourceFile;
    private final String hint;
    private final int valueOffset;
    private final int valueLength;
    private final String rawContent;
    private final int contextLinesBefore;
    private final int contextLinesAfter;
    private final boolean includeCommentsAbove;
    private final Predicate<String> commentChecker;

    public String format() {
        SourceLocation location = this.walker.findPath(this.path);
        if (location == null) {
            return "";
        }
        return this.formatLocation(location);
    }

    private String formatLocation(SourceLocation location) {
        String contextLine;
        int i;
        int underlineLength;
        int underlineStart;
        int commentCount;
        if (location.isMultiline() && this.rawContent != null) {
            return this.formatMultilineLocation(location);
        }
        StringBuilder sb = new StringBuilder();
        int lineNum = location.getLineNumber();
        String rawLine = location.getRawLine();
        String[] allLines = null;
        if (this.rawContent != null) {
            allLines = this.rawContent.split("\n", -1);
        }
        int ctxBefore = this.contextLinesBefore;
        if (this.includeCommentsAbove && allLines != null && this.commentChecker != null && (commentCount = SourceErrorMarker.countConsecutiveCommentsAbove(allLines, lineNum - 1, this.commentChecker)) > ctxBefore) {
            ctxBefore = commentCount;
        }
        if (location.getValueColumn() >= 0 && location.getValue() != null) {
            underlineStart = location.getValueColumn();
            String value = location.getValue();
            int quoteOffset = 0;
            int quoteTrim = 0;
            if (value.length() >= 2) {
                char first = value.charAt(0);
                char last = value.charAt(value.length() - 1);
                if (first == '\"' && last == '\"' || first == '\'' && last == '\'') {
                    quoteOffset = 1;
                    quoteTrim = 2;
                }
            }
            if (this.valueOffset >= 0) {
                int adjustedOffset = this.valueOffset + quoteOffset;
                if (adjustedOffset < value.length()) {
                    underlineStart += adjustedOffset;
                    int maxLength = value.length() - adjustedOffset - (quoteTrim > 0 ? 1 : 0);
                    underlineLength = Math.min(Math.max(1, this.valueLength), maxLength);
                } else {
                    underlineLength = Math.max(1, value.length() - quoteTrim);
                }
            } else {
                underlineStart += quoteOffset;
                underlineLength = Math.max(1, value.length() - quoteTrim);
            }
        } else if (location.getKeyColumn() >= 0 && location.getKey() != null) {
            underlineStart = location.getKeyColumn();
            underlineLength = location.getKey().length();
        } else {
            underlineStart = 0;
            underlineLength = Math.max(1, rawLine.trim().length());
        }
        int firstLine = Math.max(1, lineNum - ctxBefore);
        int lastLine = allLines != null ? Math.min(allLines.length, lineNum + this.contextLinesAfter) : lineNum;
        int lineNumWidth = String.valueOf(lastLine).length();
        String padding = SourceErrorMarker.repeat(' ', lineNumWidth);
        sb.append(" --> ");
        if (this.sourceFile != null && !this.sourceFile.isEmpty()) {
            sb.append(this.sourceFile).append(":");
        }
        sb.append(lineNum).append(":").append(underlineStart + 1);
        sb.append("\n");
        sb.append(padding).append(" |\n");
        if (allLines != null) {
            for (i = firstLine; i < lineNum; ++i) {
                contextLine = i - 1 < allLines.length ? allLines[i - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i), lineNumWidth)).append(" | ").append(contextLine).append("\n");
            }
        }
        sb.append(SourceErrorMarker.padLeft(String.valueOf(lineNum), lineNumWidth)).append(" | ").append(rawLine).append("\n");
        sb.append(padding).append(" | ");
        sb.append(SourceErrorMarker.repeat(' ', underlineStart));
        sb.append(SourceErrorMarker.repeat('^', Math.max(1, underlineLength)));
        if (this.hint != null && !this.hint.isEmpty()) {
            sb.append(" ").append(this.hint);
        }
        if (allLines != null) {
            for (i = lineNum + 1; i <= lastLine; ++i) {
                contextLine = i - 1 < allLines.length ? allLines[i - 1] : "";
                sb.append("\n").append(SourceErrorMarker.padLeft(String.valueOf(i), lineNumWidth)).append(" | ").append(contextLine);
            }
        }
        return sb.toString();
    }

    private String formatMultilineLocation(SourceLocation location) {
        boolean hasCustomContext;
        String line;
        int displayEndLine;
        StringBuilder sb = new StringBuilder();
        int keyLineNum = location.getLineNumber();
        String keyRawLine = location.getRawLine();
        int contentStartLineNum = location.getContentLineNumber();
        int contentEndLineNum = location.getContentEndLineNumber();
        int contentColumn = location.getContentColumn();
        if (contentStartLineNum <= 0) {
            contentStartLineNum = keyLineNum;
            contentEndLineNum = keyLineNum;
            contentColumn = location.getValueColumn() >= 0 ? location.getValueColumn() : 0;
        }
        String[] allLines = this.rawContent.split("\n", -1);
        int commentsAboveCount = 0;
        if (this.includeCommentsAbove && this.commentChecker != null) {
            commentsAboveCount = SourceErrorMarker.countConsecutiveCommentsAbove(allLines, keyLineNum - 1, this.commentChecker);
        }
        ArrayList<LineInfo> lineInfos = new ArrayList<LineInfo>();
        int charOffset = 0;
        for (int i = contentStartLineNum; i <= contentEndLineNum; ++i) {
            if (i - 1 >= allLines.length) continue;
            String line2 = allLines[i - 1];
            String trimmedLine = line2.substring(Math.min(contentColumn, line2.length()));
            lineInfos.add(new LineInfo(i, charOffset, trimmedLine, line2));
            charOffset += trimmedLine.length();
            if (i >= contentEndLineNum) continue;
            ++charOffset;
        }
        int errorStartLine = contentStartLineNum;
        int errorStartCol = contentColumn;
        int errorEndLine = contentStartLineNum;
        int errorEndCol = contentColumn;
        int underlineLength = 1;
        if (this.valueOffset >= 0) {
            OffsetPosition startPos = SourceErrorMarker.translateOffset(lineInfos, this.valueOffset, contentColumn);
            errorStartLine = startPos.lineNum;
            errorStartCol = startPos.column;
            int endOffset = this.valueOffset + Math.max(1, this.valueLength) - 1;
            OffsetPosition endPos = SourceErrorMarker.translateOffset(lineInfos, endOffset, contentColumn);
            errorEndLine = endPos.lineNum;
            errorEndCol = endPos.column;
            if (errorStartLine == errorEndLine) {
                underlineLength = Math.max(1, errorEndCol - errorStartCol + 1);
            }
        } else if (!lineInfos.isEmpty()) {
            LineInfo lastLine = (LineInfo)lineInfos.get(lineInfos.size() - 1);
            errorStartLine = lastLine.lineNum;
            errorEndLine = lastLine.lineNum;
            errorStartCol = contentColumn;
            errorEndCol = contentColumn + lastLine.trimmedContent.length() - 1;
            underlineLength = Math.max(1, lastLine.trimmedContent.length());
        }
        int displayStartLine = keyLineNum - commentsAboveCount;
        for (displayEndLine = Math.max(errorEndLine, contentEndLineNum); displayEndLine > errorEndLine && displayEndLine - 1 < allLines.length && (line = allLines[displayEndLine - 1]).trim().isEmpty(); --displayEndLine) {
        }
        int lineNumWidth = String.valueOf(displayEndLine).length();
        String padding = SourceErrorMarker.repeat(' ', lineNumWidth);
        sb.append(" --> ");
        if (this.sourceFile != null && !this.sourceFile.isEmpty()) {
            sb.append(this.sourceFile).append(":");
        }
        sb.append(errorStartLine).append(":").append(errorStartCol + 1);
        sb.append("\n");
        sb.append(padding).append(" |\n");
        int totalLines = displayEndLine - displayStartLine + 1;
        boolean bl = hasCustomContext = this.contextLinesBefore > 0 || this.contextLinesAfter > 0;
        if (totalLines <= 5 && !hasCustomContext) {
            for (int i = displayStartLine; i <= displayEndLine; ++i) {
                int markerLength;
                int markerStart;
                boolean isLastErrorLine;
                String line3 = i - 1 < allLines.length ? allLines[i - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i), lineNumWidth)).append(" | ").append(line3).append("\n");
                if (i < errorStartLine || i > errorEndLine) continue;
                sb.append(padding).append(" | ");
                boolean bl2 = isLastErrorLine = i == errorEndLine;
                if (i == errorStartLine && i == errorEndLine) {
                    markerStart = errorStartCol;
                    markerLength = underlineLength;
                } else if (i == errorStartLine) {
                    markerStart = errorStartCol;
                    markerLength = line3.length() - errorStartCol;
                } else if (i == errorEndLine) {
                    markerStart = contentColumn;
                    markerLength = errorEndCol - contentColumn + 1;
                } else {
                    markerStart = contentColumn;
                    markerLength = line3.length() - contentColumn;
                }
                sb.append(SourceErrorMarker.repeat(' ', markerStart));
                sb.append(SourceErrorMarker.repeat('^', Math.max(1, markerLength)));
                if (isLastErrorLine && this.hint != null && !this.hint.isEmpty()) {
                    sb.append(" ").append(this.hint);
                }
                sb.append("\n");
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
                sb.setLength(sb.length() - 1);
            }
        } else {
            String line4;
            int i;
            int ctxBefore = this.contextLinesBefore > 0 ? this.contextLinesBefore : 2;
            int ctxAfter = this.contextLinesAfter > 0 ? this.contextLinesAfter : 2;
            for (int i2 = displayStartLine; i2 < keyLineNum; ++i2) {
                String line5 = i2 - 1 < allLines.length ? allLines[i2 - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i2), lineNumWidth)).append(" | ").append(line5).append("\n");
            }
            sb.append(SourceErrorMarker.padLeft(String.valueOf(keyLineNum), lineNumWidth)).append(" | ").append(keyRawLine).append("\n");
            int lastLineAfterKey = Math.min(keyLineNum + ctxBefore, errorStartLine - 1);
            int firstLineBeforeError = Math.max(errorStartLine - ctxAfter, keyLineNum + 1);
            for (int i3 = keyLineNum + 1; i3 <= lastLineAfterKey; ++i3) {
                String line6 = i3 - 1 < allLines.length ? allLines[i3 - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i3), lineNumWidth)).append(" | ").append(line6).append("\n");
            }
            int skippedLines = firstLineBeforeError - lastLineAfterKey - 1;
            if (skippedLines > 0) {
                sb.append(padding).append(" | ... (").append(skippedLines).append(" more line").append(skippedLines > 1 ? "s" : "").append(")\n");
            }
            for (i = Math.max(firstLineBeforeError, lastLineAfterKey + 1); i < errorStartLine; ++i) {
                line4 = i - 1 < allLines.length ? allLines[i - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i), lineNumWidth)).append(" | ").append(line4).append("\n");
            }
            for (i = errorStartLine; i <= errorEndLine; ++i) {
                int markerLength;
                int markerStart;
                boolean isLastErrorLine;
                line4 = i - 1 < allLines.length ? allLines[i - 1] : "";
                sb.append(SourceErrorMarker.padLeft(String.valueOf(i), lineNumWidth)).append(" | ").append(line4).append("\n");
                sb.append(padding).append(" | ");
                boolean bl3 = isLastErrorLine = i == errorEndLine;
                if (i == errorStartLine && i == errorEndLine) {
                    markerStart = errorStartCol;
                    markerLength = underlineLength;
                } else if (i == errorStartLine) {
                    markerStart = errorStartCol;
                    markerLength = line4.length() - errorStartCol;
                } else if (i == errorEndLine) {
                    markerStart = contentColumn;
                    markerLength = errorEndCol - contentColumn + 1;
                } else {
                    markerStart = contentColumn;
                    markerLength = line4.length() - contentColumn;
                }
                sb.append(SourceErrorMarker.repeat(' ', markerStart));
                sb.append(SourceErrorMarker.repeat('^', Math.max(1, markerLength)));
                if (isLastErrorLine && this.hint != null && !this.hint.isEmpty()) {
                    sb.append(" ").append(this.hint);
                }
                if (i >= errorEndLine) continue;
                sb.append("\n");
            }
            if (errorEndLine < contentEndLineNum) {
                int remaining = contentEndLineNum - errorEndLine;
                if (remaining <= 2) {
                    for (int i4 = errorEndLine + 1; i4 <= contentEndLineNum; ++i4) {
                        String line7 = i4 - 1 < allLines.length ? allLines[i4 - 1] : "";
                        sb.append("\n").append(SourceErrorMarker.padLeft(String.valueOf(i4), lineNumWidth)).append(" | ").append(line7);
                    }
                } else {
                    sb.append("\n").append(padding).append(" | ... (").append(remaining).append(" more line").append(remaining > 1 ? "s" : "").append(")");
                }
            }
        }
        return sb.toString();
    }

    private static OffsetPosition translateOffset(List<LineInfo> lineInfos, int offset, int baseColumn) {
        int currentOffset = 0;
        for (LineInfo info : lineInfos) {
            int lineLength = info.trimmedContent.length();
            if (currentOffset + lineLength > offset) {
                int columnInTrimmed = offset - currentOffset;
                return new OffsetPosition(info.lineNum, baseColumn + columnInTrimmed);
            }
            currentOffset += lineLength + 1;
        }
        if (!lineInfos.isEmpty()) {
            LineInfo last = lineInfos.get(lineInfos.size() - 1);
            int lastCharCol = baseColumn + Math.max(0, last.trimmedContent.length() - 1);
            return new OffsetPosition(last.lineNum, lastCharCol);
        }
        return new OffsetPosition(1, baseColumn);
    }

    private static int countConsecutiveCommentsAbove(String[] lines, int lineIndex, Predicate<String> commentChecker) {
        int count = 0;
        for (int i = lineIndex - 1; i >= 0 && commentChecker.test(lines[i]); --i) {
            ++count;
        }
        return count;
    }

    private static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        char[] chars = new char[count];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    private static String padLeft(String str, int length) {
        if (str.length() >= length) {
            return str;
        }
        return SourceErrorMarker.repeat(' ', length - str.length()) + str;
    }

    @Generated
    private static int $default$valueOffset() {
        return -1;
    }

    @Generated
    private static int $default$valueLength() {
        return 1;
    }

    @Generated
    SourceErrorMarker(@NonNull SourceWalker walker, @NonNull ConfigPath path, String sourceFile, String hint, int valueOffset, int valueLength, String rawContent, int contextLinesBefore, int contextLinesAfter, boolean includeCommentsAbove, Predicate<String> commentChecker) {
        Objects.requireNonNull(walker, "walker is marked non-null but is null");
        Objects.requireNonNull(path, "path is marked non-null but is null");
        this.walker = walker;
        this.path = path;
        this.sourceFile = sourceFile;
        this.hint = hint;
        this.valueOffset = valueOffset;
        this.valueLength = valueLength;
        this.rawContent = rawContent;
        this.contextLinesBefore = contextLinesBefore;
        this.contextLinesAfter = contextLinesAfter;
        this.includeCommentsAbove = includeCommentsAbove;
        this.commentChecker = commentChecker;
    }

    @Generated
    public static SourceErrorMarkerBuilder builder() {
        return new SourceErrorMarkerBuilder();
    }

    private static class LineInfo {
        final int lineNum;
        final int startOffset;
        final String trimmedContent;
        final String rawLine;

        LineInfo(int lineNum, int startOffset, String trimmedContent, String rawLine) {
            this.lineNum = lineNum;
            this.startOffset = startOffset;
            this.trimmedContent = trimmedContent;
            this.rawLine = rawLine;
        }
    }

    private static class OffsetPosition {
        final int lineNum;
        final int column;

        OffsetPosition(int lineNum, int column) {
            this.lineNum = lineNum;
            this.column = column;
        }
    }

    @Generated
    public static class SourceErrorMarkerBuilder {
        @Generated
        private SourceWalker walker;
        @Generated
        private ConfigPath path;
        @Generated
        private String sourceFile;
        @Generated
        private String hint;
        @Generated
        private boolean valueOffset$set;
        @Generated
        private int valueOffset$value;
        @Generated
        private boolean valueLength$set;
        @Generated
        private int valueLength$value;
        @Generated
        private String rawContent;
        @Generated
        private int contextLinesBefore;
        @Generated
        private int contextLinesAfter;
        @Generated
        private boolean includeCommentsAbove;
        @Generated
        private Predicate<String> commentChecker;

        @Generated
        SourceErrorMarkerBuilder() {
        }

        @Generated
        public SourceErrorMarkerBuilder walker(@NonNull SourceWalker walker) {
            Objects.requireNonNull(walker, "walker is marked non-null but is null");
            this.walker = walker;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder path(@NonNull ConfigPath path) {
            Objects.requireNonNull(path, "path is marked non-null but is null");
            this.path = path;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder sourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder hint(String hint) {
            this.hint = hint;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder valueOffset(int valueOffset) {
            this.valueOffset$value = valueOffset;
            this.valueOffset$set = true;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder valueLength(int valueLength) {
            this.valueLength$value = valueLength;
            this.valueLength$set = true;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder contextLinesBefore(int contextLinesBefore) {
            this.contextLinesBefore = contextLinesBefore;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder contextLinesAfter(int contextLinesAfter) {
            this.contextLinesAfter = contextLinesAfter;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder includeCommentsAbove(boolean includeCommentsAbove) {
            this.includeCommentsAbove = includeCommentsAbove;
            return this;
        }

        @Generated
        public SourceErrorMarkerBuilder commentChecker(Predicate<String> commentChecker) {
            this.commentChecker = commentChecker;
            return this;
        }

        @Generated
        public SourceErrorMarker build() {
            int valueOffset$value = this.valueOffset$value;
            if (!this.valueOffset$set) {
                valueOffset$value = SourceErrorMarker.$default$valueOffset();
            }
            int valueLength$value = this.valueLength$value;
            if (!this.valueLength$set) {
                valueLength$value = SourceErrorMarker.$default$valueLength();
            }
            return new SourceErrorMarker(this.walker, this.path, this.sourceFile, this.hint, valueOffset$value, valueLength$value, this.rawContent, this.contextLinesBefore, this.contextLinesAfter, this.includeCommentsAbove, this.commentChecker);
        }

        @Generated
        public String toString() {
            return "SourceErrorMarker.SourceErrorMarkerBuilder(walker=" + this.walker + ", path=" + this.path + ", sourceFile=" + this.sourceFile + ", hint=" + this.hint + ", valueOffset$value=" + this.valueOffset$value + ", valueLength$value=" + this.valueLength$value + ", rawContent=" + this.rawContent + ", contextLinesBefore=" + this.contextLinesBefore + ", contextLinesAfter=" + this.contextLinesAfter + ", includeCommentsAbove=" + this.includeCommentsAbove + ", commentChecker=" + this.commentChecker + ")";
        }
    }
}

