/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigManager;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.TargetType;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.OkaeriConfigException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.OkaeriException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.SourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.ini.IniSourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.toml.TomlSourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.xml.XmlSourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.format.yaml.YamlSourceWalker;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.DeserializationData;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectSerializer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ObjectTransformer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.OkaeriSerdes;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesRegistry;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerializationData;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.standard.StandardSerdes;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.util.EnumMatcher;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.util.UnsafeUtil;

public abstract class Configurer {
    @NonNull
    private SerdesRegistry registry = new SerdesRegistry();

    public Configurer() {
        this.registry.register(new StandardSerdes());
    }

    public void register(@NonNull OkaeriSerdes pack) {
        Objects.requireNonNull(pack, "pack is marked non-null but is null");
        this.registry.register(pack);
    }

    public List<String> getExtensions() {
        return Collections.emptyList();
    }

    public SourceWalker createSourceWalker(String rawContent) {
        List<String> extensions = this.getExtensions();
        if (rawContent == null || extensions.isEmpty()) {
            return null;
        }
        switch (extensions.get(0).toLowerCase(Locale.ROOT)) {
            case "ini": 
            case "properties": {
                return IniSourceWalker.of(rawContent);
            }
            case "toml": {
                return TomlSourceWalker.of(rawContent);
            }
            case "xml": {
                return XmlSourceWalker.of(rawContent, "config");
            }
            case "yml": 
            case "yaml": {
                return YamlSourceWalker.of(rawContent);
            }
        }
        return null;
    }

    public boolean isCommentLine(String line) {
        return false;
    }

    public boolean isToStringObject(@NonNull Object object, GenericsDeclaration genericType, SerdesContext serdesContext) {
        Objects.requireNonNull(object, "object is marked non-null but is null");
        if (!(object instanceof Class)) {
            return object.getClass().isEnum() || this.isToStringObject(object.getClass(), genericType, serdesContext);
        }
        Class clazzObject = (Class)object;
        if (clazzObject.isEnum()) {
            return true;
        }
        if (genericType == null) {
            return false;
        }
        if (this.registry.canTransform(genericType, GenericsDeclaration.of(String.class))) {
            return true;
        }
        List<ObjectTransformer> transformersFrom = this.getRegistry().getTransformersFrom(genericType);
        for (ObjectTransformer stepOneTransformer : transformersFrom) {
            GenericsDeclaration stepOneTarget = stepOneTransformer.getPair().getTo();
            ObjectTransformer stepTwoTransformer = this.getRegistry().getTransformer(stepOneTarget, GenericsDeclaration.of(String.class));
            if (stepTwoTransformer == null) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isToStringObject(@NonNull Object object, GenericsDeclaration genericType) {
        Objects.requireNonNull(object, "object is marked non-null but is null");
        return this.isToStringObject(object, genericType, SerdesContext.of(this));
    }

    public Object simplifyCollection(@NonNull Collection<?> value, GenericsDeclaration genericType, @NonNull SerdesContext serdesContext, boolean conservative) throws OkaeriException {
        Objects.requireNonNull(value, "value is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        ArrayList<Object> collection = new ArrayList<Object>();
        GenericsDeclaration collectionSubtype = genericType == null ? null : genericType.getSubtypeAtOrNull(0);
        int index = 0;
        for (Object collectionElement : value) {
            collection.add(this.simplify(collectionElement, collectionSubtype, serdesContext.withIndex(index), conservative));
            ++index;
        }
        return collection;
    }

    public Object simplifyMap(@NonNull Map<Object, Object> value, GenericsDeclaration genericType, @NonNull SerdesContext serdesContext, boolean conservative) throws OkaeriException {
        Objects.requireNonNull(value, "value is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        GenericsDeclaration keyDeclaration = genericType == null ? null : genericType.getSubtypeAtOrNull(0);
        GenericsDeclaration valueDeclaration = genericType == null ? null : genericType.getSubtypeAtOrNull(1);
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            SerdesContext entryContext = serdesContext.withKey(entry.getKey());
            Object key = this.simplify(entry.getKey(), keyDeclaration, entryContext, conservative);
            Object kValue = this.simplify(entry.getValue(), valueDeclaration, entryContext, conservative);
            map.put(key, kValue);
        }
        return map;
    }

    public Object simplify(Object value, GenericsDeclaration genericType, @NonNull SerdesContext serdesContext, boolean conservative) throws OkaeriException {
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        if (value == null) {
            return null;
        }
        if (genericType != null && genericType.getType() == Object.class && !genericType.hasSubtypes()) {
            genericType = GenericsDeclaration.of(value);
        }
        Class<?> serializerType = genericType != null ? genericType.getType() : value.getClass();
        ObjectSerializer<?> serializer = null;
        if (serdesContext.getField() != null && serdesContext.getField().getCustomSerializer() != null) {
            serializer = serdesContext.getField().getCustomSerializer();
        }
        if (serializer == null) {
            serializer = this.registry.getSerializer(serializerType);
        }
        if (serializer == null) {
            GenericsDeclaration valueDeclaration;
            if (OkaeriConfig.class.isAssignableFrom(value.getClass())) {
                OkaeriConfig config = (OkaeriConfig)value;
                return config.asMap(this, conservative);
            }
            if (conservative && (serializerType.isPrimitive() || GenericsDeclaration.of(serializerType).isPrimitiveWrapper())) {
                return value;
            }
            if (serializerType.isPrimitive()) {
                Class<?> wrappedPrimitive = GenericsDeclaration.of(serializerType).wrap();
                return this.simplify(wrappedPrimitive.cast(value), GenericsDeclaration.of(wrappedPrimitive), serdesContext, conservative);
            }
            if (genericType == null && this.isToStringObject(serializerType, valueDeclaration = GenericsDeclaration.of(value), serdesContext)) {
                return this.resolveType(value, genericType, String.class, null, serdesContext);
            }
            if (this.isToStringObject(serializerType, genericType, serdesContext)) {
                return this.resolveType(value, genericType, String.class, null, serdesContext);
            }
            if (value instanceof Collection) {
                return this.simplifyCollection((Collection)value, genericType, serdesContext, conservative);
            }
            if (value instanceof Map) {
                return this.simplifyMap((Map)value, genericType, serdesContext, conservative);
            }
            if (value instanceof Serializable) {
                ConfigDeclaration declaration = ConfigDeclaration.of(value);
                SerializationData data = new SerializationData(this, serdesContext);
                declaration.getFields().forEach(field -> data.set(field.getName(), field.getValue(), field.getType()));
                LinkedHashMap<Object, Object> serializationMap = new LinkedHashMap<Object, Object>(data.asMap());
                return this.simplifyMap(serializationMap, GenericsDeclaration.of(Map.class, Collections.singletonList(String.class)), serdesContext, conservative);
            }
            throw new OkaeriException("cannot simplify type " + serializerType + " (" + genericType + "): '" + value + "' [" + value.getClass() + "]");
        }
        SerializationData serializationData = new SerializationData(this, serdesContext);
        serializer.serialize(value, serializationData, genericType == null ? GenericsDeclaration.of(value) : genericType);
        LinkedHashMap<Object, Object> serializationMap = new LinkedHashMap<Object, Object>(serializationData.asMap());
        if (serializationMap.containsKey("$$__value__$$")) {
            if (serializationMap.size() == 1) {
                return serializationMap.get("$$__value__$$");
            }
            throw new OkaeriException("magic value key is not allowed with other keys (" + serializationMap.keySet() + ") in the SerializationData for " + serializerType + " (" + genericType + "): '" + value + "' [" + value.getClass() + "]");
        }
        return this.simplifyMap(serializationMap, GenericsDeclaration.of(Map.class, Collections.singletonList(String.class)), serdesContext, conservative);
    }

    public Object simplifyField(Object value, GenericsDeclaration type, FieldDeclaration field, ConfigContext configContext) {
        return this.simplify(value, type, SerdesContext.of(this, configContext, field), true);
    }

    public <T> T resolveValue(Object value, @NonNull Class<T> clazz, GenericsDeclaration genericType, @NonNull SerdesContext serdesContext) {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        if (value == null) {
            return null;
        }
        return this.resolveType(value, GenericsDeclaration.of(value), clazz, genericType, serdesContext);
    }

    public <T> T resolveType(Object object, GenericsDeclaration genericSource, @NonNull Class<T> targetClazz, GenericsDeclaration genericTarget, @NonNull SerdesContext serdesContext) throws OkaeriException {
        ObjectTransformer transformer;
        GenericsDeclaration target;
        Objects.requireNonNull(targetClazz, "targetClazz is marked non-null but is null");
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        if (object == null) {
            return null;
        }
        GenericsDeclaration source = genericSource == null ? GenericsDeclaration.of(object) : genericSource;
        GenericsDeclaration genericsDeclaration = target = genericTarget == null ? GenericsDeclaration.of(targetClazz) : genericTarget;
        if (source.isPrimitive()) {
            source = GenericsDeclaration.of(source.wrap());
        }
        Class<Object> workingClazz = targetClazz;
        if (target.isPrimitive()) {
            target = GenericsDeclaration.of(target.wrap());
            workingClazz = target.getType();
        }
        ObjectSerializer<?> objectSerializer = null;
        if (serdesContext.getField() != null && serdesContext.getField().getCustomSerializer() != null) {
            objectSerializer = serdesContext.getField().getCustomSerializer();
        }
        if (objectSerializer == null) {
            objectSerializer = this.registry.getSerializer(workingClazz);
        }
        if (objectSerializer != null) {
            DeserializationData deserializationData = object instanceof Map ? new DeserializationData((Map)object, this, serdesContext) : new DeserializationData(Collections.singletonMap("$$__value__$$", object), this, serdesContext);
            try {
                Object deserialized = objectSerializer.deserialize(deserializationData, target);
                return (T)workingClazz.cast(deserialized);
            }
            catch (OkaeriConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw OkaeriConfigException.builder().message("Cannot deserialize").path(serdesContext.getPath()).expectedType(target).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).errorCode(objectSerializer.getClass()).cause(e).build();
            }
        }
        if (OkaeriConfig.class.isAssignableFrom(workingClazz)) {
            T config = ConfigManager.createUnsafe(targetClazz);
            Map configMap = this.resolveType(object, source, Map.class, GenericsDeclaration.of(Map.class, Arrays.asList(String.class, Object.class)), serdesContext);
            ((OkaeriConfig)config).setConfigurer(this);
            ((OkaeriConfig)config).setInternalState(configMap);
            ((OkaeriConfig)config).setInternalPath(serdesContext.getPath());
            if (serdesContext.getConfigContext() != null) {
                ((OkaeriConfig)config).setContext(serdesContext.getConfigContext());
            }
            return (T)((OkaeriConfig)config).update();
        }
        if (genericTarget != null) {
            Class<?> localTargetClazz = this.resolveTargetBaseType(serdesContext, target, source);
            if (object instanceof Collection && Collection.class.isAssignableFrom(localTargetClazz)) {
                Collection sourceList = (Collection)object;
                Collection targetList = (Collection)this.createInstance(localTargetClazz);
                GenericsDeclaration listDeclaration = genericTarget.getSubtypeAtOrNull(0);
                int index = 0;
                for (Object item : sourceList) {
                    Object converted = this.resolveType(item, GenericsDeclaration.of(item), listDeclaration.getType(), listDeclaration, serdesContext.withIndex(index));
                    targetList.add(converted);
                    ++index;
                }
                return (T)localTargetClazz.cast(targetList);
            }
            if (object instanceof Map && Map.class.isAssignableFrom(localTargetClazz)) {
                Map values = (Map)object;
                GenericsDeclaration keyDeclaration = genericTarget.getSubtypeAtOrNull(0);
                GenericsDeclaration valueDeclaration = genericTarget.getSubtypeAtOrNull(1);
                Map map = (Map)this.createInstance(localTargetClazz);
                for (Map.Entry entry : values.entrySet()) {
                    SerdesContext entryContext = serdesContext.withKey(entry.getKey());
                    Object key = this.resolveType(entry.getKey(), GenericsDeclaration.of(entry.getKey()), keyDeclaration.getType(), keyDeclaration, entryContext);
                    Object value = this.resolveType(entry.getValue(), GenericsDeclaration.of(entry.getValue()), valueDeclaration.getType(), valueDeclaration, entryContext);
                    map.put(key, value);
                }
                return (T)localTargetClazz.cast(map);
            }
        }
        if ((transformer = this.registry.getTransformer(source, target)) == null) {
            Class<?> objectClazz = object.getClass();
            try {
                if (object instanceof String && target.isEnum()) {
                    String strObject = (String)object;
                    try {
                        Method enumMethod = targetClazz.getMethod("valueOf", String.class);
                        Object enumValue = enumMethod.invoke(null, strObject);
                        if (enumValue != null) {
                            return targetClazz.cast(enumValue);
                        }
                    }
                    catch (InvocationTargetException ignored) {
                        Enum[] enumValues;
                        for (Enum value : enumValues = (Enum[])targetClazz.getEnumConstants()) {
                            if (!strObject.equalsIgnoreCase(value.name())) continue;
                            return targetClazz.cast(value);
                        }
                    }
                    String hint = EnumMatcher.suggest(strObject, targetClazz);
                    throw OkaeriConfigException.builder().message("Cannot resolve").path(serdesContext.getPath()).expectedType(target).actualValue(strObject).configurer(this).configContext(serdesContext.getConfigContext()).cause(new IllegalArgumentException(hint)).build();
                }
                if (source.isEnum() && targetClazz == String.class) {
                    Method enumMethod = objectClazz.getMethod("name", new Class[0]);
                    return targetClazz.cast(enumMethod.invoke(object, new Object[0]));
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
                throw new OkaeriException("failed to resolve enum " + object.getClass() + " <> " + targetClazz, exception);
            }
            if (GenericsDeclaration.doBoxTypesMatch(workingClazz, objectClazz)) {
                return (T)workingClazz.cast(object);
            }
            if ((GenericsDeclaration.of(objectClazz).isPrimitiveWrapper() || objectClazz.isPrimitive()) && (GenericsDeclaration.of(workingClazz).isPrimitiveWrapper() || workingClazz.isPrimitive())) {
                Object simplified = this.simplify(object, GenericsDeclaration.of(objectClazz), serdesContext, false);
                try {
                    return this.resolveType(simplified, GenericsDeclaration.of(simplified), targetClazz, GenericsDeclaration.of(targetClazz), serdesContext);
                }
                catch (OkaeriConfigException e) {
                    throw OkaeriConfigException.builder().message("Cannot transform").path(e.getPath()).expectedType(e.getExpectedType()).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).errorCode(e.getErrorCode()).cause(e.getCause()).build();
                }
            }
            List<ObjectTransformer> transformersFrom = this.getRegistry().getTransformersFrom(source);
            for (ObjectTransformer stepOneTransformer : transformersFrom) {
                GenericsDeclaration stepOneTarget = stepOneTransformer.getPair().getTo();
                ObjectTransformer stepTwoTransformer = this.getRegistry().getTransformer(stepOneTarget, target);
                if (stepTwoTransformer == null) continue;
                try {
                    Object transformed = stepOneTransformer.transform(object, serdesContext);
                    try {
                        Object doubleTransformed = stepTwoTransformer.transform(transformed, serdesContext);
                        return (T)workingClazz.cast(doubleTransformed);
                    }
                    catch (OkaeriConfigException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw OkaeriConfigException.builder().message("Cannot transform").path(serdesContext.getPath()).expectedType(target).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).errorCode(stepTwoTransformer.getOriginalClass()).cause(e).build();
                    }
                }
                catch (OkaeriConfigException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw OkaeriConfigException.builder().message("Cannot transform").path(serdesContext.getPath()).expectedType(target).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).errorCode(stepOneTransformer.getOriginalClass()).cause(e).build();
                }
            }
            if (object instanceof Map && Serializable.class.isAssignableFrom(workingClazz)) {
                Object serializableInstance = UnsafeUtil.allocateInstance(workingClazz);
                ConfigDeclaration declaration = ConfigDeclaration.of(workingClazz, serializableInstance);
                Map serializableMap = this.resolveType(object, source, Map.class, GenericsDeclaration.of(Map.class, Arrays.asList(String.class, Object.class)), serdesContext);
                for (FieldDeclaration field : declaration.getFields()) {
                    Object serializedValue = serializableMap.get(field.getName());
                    if (serializedValue == null) continue;
                    SerdesContext fieldContext = serdesContext.withProperty(field.getName()).withField(field);
                    Object deserializedValue = this.resolveType(serializedValue, GenericsDeclaration.of(serializedValue), field.getType().getType(), field.getType(), fieldContext);
                    try {
                        field.getField().set(serializableInstance, deserializedValue);
                    }
                    catch (IllegalAccessException exception) {
                        throw new OkaeriException("cannot set field of serializable " + field, exception);
                    }
                }
                return (T)serializableInstance;
            }
            try {
                return (T)workingClazz.cast(object);
            }
            catch (ClassCastException exception) {
                String message = "Cannot transform";
                if (object instanceof Map && !Map.class.isAssignableFrom(workingClazz)) {
                    message = "No serializer found for type '" + workingClazz.getSimpleName() + "'. Register an ObjectSerializer or make the class extend OkaeriConfig";
                }
                throw OkaeriConfigException.builder().message(message).path(serdesContext.getPath()).expectedType(target).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).cause(exception).build();
            }
        }
        try {
            return (T)workingClazz.cast(transformer.transform(object, serdesContext));
        }
        catch (OkaeriConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw OkaeriConfigException.builder().message("Cannot transform").path(serdesContext.getPath()).expectedType(target).actualValue(object).configurer(this).configContext(serdesContext.getConfigContext()).errorCode(transformer.getOriginalClass()).cause(e).build();
        }
    }

    public Class<?> resolveTargetBaseType(@NonNull SerdesContext serdesContext, @NonNull GenericsDeclaration target, @NonNull GenericsDeclaration source) {
        Objects.requireNonNull(serdesContext, "serdesContext is marked non-null but is null");
        Objects.requireNonNull(target, "target is marked non-null but is null");
        Objects.requireNonNull(source, "source is marked non-null but is null");
        FieldDeclaration serdesContextField = serdesContext.getField();
        Class<?> targetType = target.getType();
        if (serdesContextField != null && !serdesContextField.getType().equals(target)) {
            return targetType;
        }
        if (serdesContextField == null) {
            return targetType;
        }
        Optional<TargetType> targetTypeAnnotation = serdesContextField.getAnnotation(TargetType.class);
        if (targetTypeAnnotation.isPresent()) {
            return targetTypeAnnotation.get().value();
        }
        return targetType;
    }

    public Object createInstance(@NonNull Class<?> clazz) throws OkaeriException {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        try {
            if (Collection.class.isAssignableFrom(clazz)) {
                if (clazz == Set.class) {
                    return new LinkedHashSet();
                }
                if (clazz == List.class) {
                    return new ArrayList();
                }
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException exception) {
                    throw new OkaeriException("cannot create instance of " + clazz + " (tip: provide implementation (e.g. ArrayList) for types with no default constructor using @TargetType annotation)", exception);
                }
            }
            if (Map.class.isAssignableFrom(clazz)) {
                if (clazz == Map.class) {
                    return new LinkedHashMap();
                }
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException exception) {
                    throw new OkaeriException("cannot create instance of " + clazz + " (tip: provide implementation (e.g. LinkedHashMap) for types with no default constructor using @TargetType annotation)", exception);
                }
            }
            throw new OkaeriException("cannot create instance of " + clazz);
        }
        catch (Exception exception) {
            throw new OkaeriException("failed to create instance of " + clazz, exception);
        }
    }

    public abstract Map<String, Object> load(@NonNull InputStream var1, @NonNull ConfigDeclaration var2) throws Exception;

    public abstract void write(@NonNull OutputStream var1, @NonNull Map<String, Object> var2, @NonNull ConfigDeclaration var3) throws Exception;

    @Generated
    public void setRegistry(@NonNull SerdesRegistry registry) {
        Objects.requireNonNull(registry, "registry is marked non-null but is null");
        this.registry = registry;
    }

    @NonNull
    @Generated
    public SerdesRegistry getRegistry() {
        return this.registry;
    }
}

