/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.OkaeriSerdes;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.validator.ConfigValidator;

public class OkaeriConfigOptions {
    private final OkaeriConfig config;

    public OkaeriConfigOptions bindFile(@NonNull File bindFile) {
        Objects.requireNonNull(bindFile, "bindFile is marked non-null but is null");
        this.config.setBindFile(bindFile.toPath());
        return this;
    }

    public OkaeriConfigOptions bindFile(@NonNull Path path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        this.config.setBindFile(path);
        return this;
    }

    public OkaeriConfigOptions bindFile(@NonNull String pathname) {
        Objects.requireNonNull(pathname, "pathname is marked non-null but is null");
        this.config.setBindFile(Paths.get(pathname, new String[0]));
        return this;
    }

    public OkaeriConfigOptions configurer(@NonNull Configurer configurer) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        if (this.config.getConfigurer() != null) {
            configurer.setRegistry(this.config.getConfigurer().getRegistry());
        }
        this.config.setConfigurer(configurer);
        return this;
    }

    public OkaeriConfigOptions configurer(@NonNull Configurer configurer, OkaeriSerdes ... serdes) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        Objects.requireNonNull(serdes, "serdes is marked non-null but is null");
        if (this.config.getConfigurer() != null) {
            configurer.setRegistry(this.config.getConfigurer().getRegistry());
        }
        this.config.setConfigurer(configurer);
        this.config.getConfigurer().getRegistry().add(serdes);
        return this;
    }

    public OkaeriConfigOptions serdes(OkaeriSerdes ... serdes) {
        Objects.requireNonNull(serdes, "serdes is marked non-null but is null");
        if (this.config.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        this.config.getConfigurer().getRegistry().add(serdes);
        return this;
    }

    public OkaeriConfigOptions logger(@NonNull Logger logger) {
        Objects.requireNonNull(logger, "logger is marked non-null but is null");
        ConfigContext context = this.config.getContext();
        if (context == null) {
            throw new IllegalStateException("configurer must be set before setting logger");
        }
        context.setLogger(logger);
        return this;
    }

    public OkaeriConfigOptions removeOrphans(boolean removeOrphans) {
        ConfigContext context = this.config.getContext();
        if (context == null) {
            throw new IllegalStateException("configurer must be set before setting removeOrphans");
        }
        context.setRemoveOrphans(removeOrphans);
        return this;
    }

    public OkaeriConfigOptions errorComments(boolean errorComments) {
        ConfigContext context = this.config.getContext();
        if (context == null) {
            throw new IllegalStateException("configurer must be set before setting errorComments");
        }
        context.setErrorComments(errorComments);
        return this;
    }

    public OkaeriConfigOptions validator(@NonNull ConfigValidator validator) {
        Objects.requireNonNull(validator, "validator is marked non-null but is null");
        ConfigContext context = this.config.getContext();
        if (context == null) {
            throw new IllegalStateException("configurer must be set before setting validator");
        }
        context.setValidator(validator);
        return this;
    }

    @Generated
    OkaeriConfigOptions(OkaeriConfig config) {
        this.config = config;
    }
}

