/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfigOptions;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.ReadOnly;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.annotation.Variable;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.OkaeriConfigException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.OkaeriException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.migrate.ConfigMigration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.migrate.builtin.NamedMigration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.migrate.view.RawConfigView;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.ConfigPath;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.OkaeriSerdes;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;

public abstract class OkaeriConfig {
    private Path bindFile;
    private Configurer configurer;
    private ConfigDeclaration declaration;
    private ConfigContext context;
    private Map<String, Object> internalState = new LinkedHashMap<String, Object>();
    private ConfigPath internalPath = ConfigPath.root();

    public boolean isSubconfig() {
        return this.configurer == null && this.context != null;
    }

    public Configurer getEffectiveConfigurer() {
        if (this.configurer != null) {
            return this.configurer;
        }
        if (this.context != null) {
            return this.context.getRootConfig().getConfigurer();
        }
        return null;
    }

    public String getBindFileName() {
        Path file = this.bindFile;
        if (file == null && this.context != null) {
            file = this.context.getRootConfig().getBindFile();
        }
        if (file != null) {
            Path fileName = file.getFileName();
            return fileName != null ? fileName.toString() : null;
        }
        return null;
    }

    public ConfigDeclaration getDeclaration() {
        if (this.declaration == null) {
            this.declaration = ConfigDeclaration.of(this);
        }
        return this.declaration;
    }

    @Deprecated
    public OkaeriConfig updateDeclaration() {
        this.setDeclaration(ConfigDeclaration.of(this));
        return this;
    }

    public void setConfigurer(@NonNull Configurer configurer) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        this.configurer = configurer;
        if (this.context == null && !this.isSubconfig()) {
            this.context = new ConfigContext(this);
        }
    }

    public OkaeriConfig configure(@NonNull Consumer<OkaeriConfigOptions> configurator) {
        Objects.requireNonNull(configurator, "configurator is marked non-null but is null");
        OkaeriConfigOptions configurer = new OkaeriConfigOptions(this);
        configurator.accept(configurer);
        return this;
    }

    @Deprecated
    public OkaeriConfig withConfigurer(@NonNull Configurer configurer) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        if (this.getConfigurer() != null) {
            configurer.setRegistry(this.getConfigurer().getRegistry());
        }
        this.setConfigurer(configurer);
        return this;
    }

    @Deprecated
    public OkaeriConfig withConfigurer(@NonNull Configurer configurer, OkaeriSerdes ... serdesPack) {
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        Objects.requireNonNull(serdesPack, "serdesPack is marked non-null but is null");
        if (this.getConfigurer() != null) {
            configurer.setRegistry(this.getConfigurer().getRegistry());
        }
        this.setConfigurer(configurer);
        Arrays.stream(serdesPack).forEach(this.getConfigurer()::register);
        return this;
    }

    @Deprecated
    public OkaeriConfig withSerdesPack(@NonNull OkaeriSerdes serdesPack) {
        Objects.requireNonNull(serdesPack, "serdesPack is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        this.getConfigurer().register(serdesPack);
        return this;
    }

    @Deprecated
    public OkaeriConfig withBindFile(@NonNull File bindFile) {
        Objects.requireNonNull(bindFile, "bindFile is marked non-null but is null");
        this.setBindFile(bindFile.toPath());
        return this;
    }

    @Deprecated
    public OkaeriConfig withBindFile(@NonNull Path path) {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        this.setBindFile(path);
        return this;
    }

    @Deprecated
    public OkaeriConfig withBindFile(@NonNull String pathname) {
        Objects.requireNonNull(pathname, "pathname is marked non-null but is null");
        this.setBindFile(Paths.get(pathname, new String[0]));
        return this;
    }

    @Deprecated
    public OkaeriConfig withLogger(@NonNull Logger logger) {
        Objects.requireNonNull(logger, "logger is marked non-null but is null");
        if (this.context != null) {
            this.context.setLogger(logger);
        }
        return this;
    }

    @Deprecated
    public OkaeriConfig withRemoveOrphans(boolean removeOrphans) {
        if (this.context != null) {
            this.context.setRemoveOrphans(removeOrphans);
        }
        return this;
    }

    public void set(@NonNull String key, Object value) throws OkaeriException {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Configurer effectiveConfigurer = this.getEffectiveConfigurer();
        if (effectiveConfigurer == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        FieldDeclaration field = this.getDeclaration().getField(key).orElse(null);
        if (field != null) {
            value = effectiveConfigurer.resolveType(value, GenericsDeclaration.of(value), field.getType().getType(), field.getType(), SerdesContext.of(effectiveConfigurer, this.context, field));
            field.updateValue(value);
        }
        GenericsDeclaration fieldGenerics = field == null ? null : field.getType();
        Object simplified = effectiveConfigurer.simplifyField(value, fieldGenerics, field, this.context);
        this.internalState.put(key, simplified);
    }

    public Object get(@NonNull String key) throws OkaeriException {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        FieldDeclaration field = this.getDeclaration().getField(key).orElse(null);
        if (field != null) {
            return field.getValue();
        }
        return this.internalState.get(key);
    }

    public <T> T get(@NonNull String key, @NonNull Class<T> clazz) throws OkaeriException {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        return this.get(key, GenericsDeclaration.of(clazz));
    }

    public <T> T get(@NonNull String key, @NonNull GenericsDeclaration generics) throws OkaeriException {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        Objects.requireNonNull(generics, "generics is marked non-null but is null");
        Configurer effectiveConfigurer = this.getEffectiveConfigurer();
        if (effectiveConfigurer == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        FieldDeclaration field = this.getDeclaration().getField(key).orElse(null);
        if (field != null) {
            return (T)effectiveConfigurer.resolveType(field.getValue(), field.getType(), generics.getType(), generics, SerdesContext.of(effectiveConfigurer, this.context, field));
        }
        Object rawValue = this.internalState.get(key);
        return (T)effectiveConfigurer.resolveValue(rawValue, generics.getType(), generics, SerdesContext.of(effectiveConfigurer, this.context, null));
    }

    public OkaeriConfig saveDefaults() throws OkaeriException {
        if (this.getBindFile() == null) {
            throw new IllegalStateException("bindFile cannot be null");
        }
        if (Files.exists(this.getBindFile(), new LinkOption[0])) {
            return this;
        }
        return this.save();
    }

    public OkaeriConfig save() throws OkaeriException {
        if (this.getBindFile() == null) {
            throw new IllegalStateException("bindFile cannot be null");
        }
        return this.save(this.getBindFile());
    }

    public OkaeriConfig save(@NonNull File file) throws OkaeriException {
        Objects.requireNonNull(file, "file is marked non-null but is null");
        ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
        this.save(memoryBuffer);
        try {
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            try (FileOutputStream fileOut = new FileOutputStream(file, false);){
                memoryBuffer.writeTo(fileOut);
            }
            return this;
        }
        catch (IOException exception) {
            throw new OkaeriException("failed #save using file " + file, exception);
        }
    }

    public OkaeriConfig save(@NonNull Path path) throws OkaeriException {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return this.save(path.toFile());
    }

    public String saveToString() throws OkaeriException {
        return new String(this.saveToBytes(), StandardCharsets.UTF_8);
    }

    public byte[] saveToBytes() throws OkaeriException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.save(outputStream);
        return outputStream.toByteArray();
    }

    public OkaeriConfig save(@NonNull OutputStream outputStream) throws OkaeriException {
        Objects.requireNonNull(outputStream, "outputStream is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        if (this.context.hasValidator()) {
            this.context.validate(this, false);
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (FieldDeclaration fieldDeclaration : this.getDeclaration().getFields()) {
            Object valueToSave = fieldDeclaration.getAnnotation(ReadOnly.class).isPresent() ? fieldDeclaration.getStartingValue() : fieldDeclaration.getValue();
            try {
                Object simplified = this.getConfigurer().simplifyField(valueToSave, fieldDeclaration.getType(), fieldDeclaration, this.context);
                data.put(fieldDeclaration.getName(), simplified);
            }
            catch (Exception exception) {
                throw new OkaeriException("failed to simplify " + fieldDeclaration.getName(), exception);
            }
        }
        LinkedHashSet<String> allOrphans = new LinkedHashSet<String>();
        for (String key : this.internalState.keySet()) {
            if (data.containsKey(key)) continue;
            if (this.context.isRemoveOrphans()) {
                allOrphans.add(key);
                continue;
            }
            data.put(key, this.internalState.get(key));
        }
        if (this.context.isRemoveOrphans()) {
            this.removeOrphansRecursively(this.getDeclaration(), data, "", allOrphans);
            if (!allOrphans.isEmpty()) {
                this.context.getLogger().warning("Removed orphaned (undeclared) keys: " + allOrphans);
            }
        }
        this.internalState = data;
        try {
            this.getConfigurer().write(outputStream, data, this.getDeclaration());
        }
        catch (Exception exception) {
            throw new OkaeriException("failed #write", exception);
        }
        return this;
    }

    public Map<String, Object> asMap(@NonNull Configurer configurer, boolean conservative) throws OkaeriException {
        Object simplified;
        Objects.requireNonNull(configurer, "configurer is marked non-null but is null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (FieldDeclaration fieldDeclaration : this.getDeclaration().getFields()) {
            simplified = configurer.simplify(fieldDeclaration.getValue(), fieldDeclaration.getType(), SerdesContext.of(configurer, this.context, fieldDeclaration), conservative);
            map.put(fieldDeclaration.getName(), simplified);
        }
        for (Map.Entry entry : this.internalState.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            simplified = configurer.simplify(entry.getValue(), GenericsDeclaration.of(entry.getValue()), SerdesContext.of(configurer, this.context, null), conservative);
            map.put((String)entry.getKey(), simplified);
        }
        return map;
    }

    public Map<String, Object> asMap() throws OkaeriException {
        return this.asMap(this.getConfigurer(), true);
    }

    public Map<String, Object> asMap(boolean conservative) throws OkaeriException {
        return this.asMap(this.getConfigurer(), conservative);
    }

    public OkaeriConfig load(boolean update) throws OkaeriException {
        this.load();
        if (update) {
            this.save();
        }
        return this;
    }

    public OkaeriConfig load(@NonNull String data) throws OkaeriException {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        return this.load(data.getBytes(StandardCharsets.UTF_8));
    }

    public OkaeriConfig load(byte @NonNull [] data) throws OkaeriException {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        return this.load(inputStream);
    }

    public OkaeriConfig load(@NonNull InputStream inputStream) throws OkaeriException {
        Objects.requireNonNull(inputStream, "inputStream is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        try {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] chunk = new byte[8192];
            while ((bytesRead = inputStream.read(chunk)) != -1) {
                buffer.write(chunk, 0, bytesRead);
            }
            byte[] contentBytes = buffer.toByteArray();
            String rawContent = new String(contentBytes, StandardCharsets.UTF_8);
            this.context.setRawContent(rawContent);
            LinkedHashMap loaded = this.getConfigurer().load(new ByteArrayInputStream(contentBytes), this.getDeclaration());
            this.internalState = loaded != null ? loaded : new LinkedHashMap();
        }
        catch (Exception exception) {
            throw new OkaeriException("failed #load", exception);
        }
        return this.update();
    }

    public OkaeriConfig load() throws OkaeriException {
        return this.load(this.getBindFile());
    }

    public OkaeriConfig load(@NonNull File file) throws OkaeriException {
        Objects.requireNonNull(file, "file is marked non-null but is null");
        try {
            return this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException exception) {
            throw new OkaeriException("failed #load using file " + file, exception);
        }
    }

    public OkaeriConfig load(@NonNull Path path) throws OkaeriException {
        Objects.requireNonNull(path, "path is marked non-null but is null");
        return this.load(path.toFile());
    }

    public OkaeriConfig load(@NonNull Map<String, Object> map) throws OkaeriException {
        Objects.requireNonNull(map, "map is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        map.forEach(this::set);
        return this;
    }

    public OkaeriConfig load(@NonNull OkaeriConfig otherConfig) throws OkaeriException {
        Objects.requireNonNull(otherConfig, "otherConfig is marked non-null but is null");
        if (this.getConfigurer() == null) {
            throw new IllegalStateException("configurer cannot be null");
        }
        return this.load(otherConfig.asMap(this.getConfigurer(), true));
    }

    public OkaeriConfig validate() throws OkaeriException {
        if (!this.context.hasValidator()) {
            return this;
        }
        this.context.validate(this);
        return this;
    }

    public OkaeriConfig migrate(ConfigMigration ... migrations) throws OkaeriException {
        Objects.requireNonNull(migrations, "migrations is marked non-null but is null");
        return this.migrate((Long performed) -> {
            try {
                this.load(this.saveToString());
            }
            catch (OkaeriException exception) {
                throw new OkaeriException("failed #migrate due to load error after migrations (not saving)", exception);
            }
            this.save();
        }, migrations);
    }

    public OkaeriConfig migrate(@NonNull Consumer<Long> callback, ConfigMigration ... migrations) throws OkaeriException {
        Objects.requireNonNull(callback, "callback is marked non-null but is null");
        Objects.requireNonNull(migrations, "migrations is marked non-null but is null");
        RawConfigView view = new RawConfigView(this);
        long performed = Arrays.stream(migrations).filter(migration -> {
            try {
                return migration.migrate(this, view);
            }
            catch (Exception exception) {
                throw new OkaeriException("migrate failure in " + migration.getClass().getName(), exception);
            }
        }).peek(migration -> {
            if (migration instanceof NamedMigration) {
                String name = migration.getClass().getSimpleName();
                String description = ((NamedMigration)migration).getDescription();
                this.context.getLogger().info(name + ": " + description);
            }
        }).count();
        if (performed > 0L) {
            callback.accept(performed);
        }
        return this;
    }

    public OkaeriConfig update() throws OkaeriException {
        if (this.getDeclaration() == null) {
            throw new IllegalStateException("declaration cannot be null: config not initialized");
        }
        this.loadValuesFromInternalState();
        this.processVariablesRecursively(this.getDeclaration(), this, new HashSet<Object>());
        if (this.context.hasValidator()) {
            this.context.validate(this, true);
        }
        return this;
    }

    private void loadValuesFromInternalState() throws OkaeriException {
        Configurer effectiveConfigurer = this.getEffectiveConfigurer();
        if (effectiveConfigurer == null) {
            throw new IllegalStateException("no effective configurer available");
        }
        for (FieldDeclaration field : this.getDeclaration().getFields()) {
            Object value;
            String fieldName = field.getName();
            GenericsDeclaration genericType = field.getType();
            Class<?> type = field.getType().getType();
            if (!this.internalState.containsKey(fieldName)) continue;
            ConfigPath fieldPath = this.internalPath == null || this.internalPath.isEmpty() ? ConfigPath.of(fieldName) : this.internalPath.property(fieldName);
            SerdesContext serdesContext = SerdesContext.of(effectiveConfigurer, this.context, field).withPath(fieldPath);
            Object rawValue = this.internalState.get(fieldName);
            try {
                value = effectiveConfigurer.resolveValue(rawValue, type, genericType, serdesContext);
            }
            catch (OkaeriConfigException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw OkaeriConfigException.builder().message("Cannot deserialize").path(fieldPath).expectedType(genericType).configurer(effectiveConfigurer).configContext(this.context).cause(exception).build();
            }
            field.updateValue(value);
            field.setStartingValue(value);
        }
        if (this.context.hasValidator()) {
            this.context.validate(this, true);
        }
    }

    private void processVariablesRecursively(@NonNull ConfigDeclaration declaration, @NonNull Object configInstance, @NonNull Set<Object> visited) {
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        Objects.requireNonNull(configInstance, "configInstance is marked non-null but is null");
        Objects.requireNonNull(visited, "visited is marked non-null but is null");
        Configurer effectiveConfigurer = this.getEffectiveConfigurer();
        if (!visited.add(configInstance)) {
            return;
        }
        for (FieldDeclaration field : declaration.getFields()) {
            field.setObject(configInstance);
            Variable variable = field.getVariable();
            if (variable != null && effectiveConfigurer != null) {
                String property;
                String rawProperty = System.getProperty(variable.value());
                String string = property = rawProperty == null ? System.getenv(variable.value()) : rawProperty;
                if (property != null) {
                    Object value;
                    GenericsDeclaration fieldType = field.getType();
                    ConfigPath fieldPath = this.internalPath == null || this.internalPath.isEmpty() ? ConfigPath.of(field.getName()) : this.internalPath.property(field.getName());
                    SerdesContext serdesContext = SerdesContext.of(effectiveConfigurer, this.context, field).withPath(fieldPath);
                    try {
                        value = effectiveConfigurer.resolveType(property, GenericsDeclaration.of(property), fieldType.getType(), fieldType, serdesContext);
                    }
                    catch (OkaeriConfigException exception) {
                        throw exception;
                    }
                    catch (Exception exception) {
                        throw OkaeriConfigException.builder().message("Failed to resolve @Variable(" + variable.value() + ")").path(fieldPath).expectedType(fieldType).actualValue(property).configurer(effectiveConfigurer).configContext(this.context).cause(exception).build();
                    }
                    field.updateValue(value);
                    field.setVariableHide(true);
                }
            }
            try {
                Object nestedObject = field.getValue();
                if (nestedObject == null) continue;
                GenericsDeclaration fieldType = field.getType();
                Class<?> nestedClass = fieldType.getType();
                if (!fieldType.isConfig()) continue;
                ConfigDeclaration nestedDeclaration = ConfigDeclaration.of(nestedClass);
                this.processVariablesRecursively(nestedDeclaration, nestedObject, visited);
            }
            catch (Exception exception) {
                throw new OkaeriException("failed to process variables recursively", exception);
            }
        }
    }

    private void removeOrphansRecursively(@NonNull ConfigDeclaration declaration, @NonNull Map<String, Object> data, @NonNull String keyPrefix, @NonNull Set<String> allOrphans) {
        Objects.requireNonNull(declaration, "declaration is marked non-null but is null");
        Objects.requireNonNull(data, "data is marked non-null but is null");
        Objects.requireNonNull(keyPrefix, "keyPrefix is marked non-null but is null");
        Objects.requireNonNull(allOrphans, "allOrphans is marked non-null but is null");
        Configurer effectiveConfigurer = this.getEffectiveConfigurer();
        for (FieldDeclaration field : declaration.getFields()) {
            Object nestedValue;
            String fullPath;
            String fieldName = field.getName();
            String string = fullPath = keyPrefix.isEmpty() ? fieldName : keyPrefix + "." + fieldName;
            GenericsDeclaration fieldType = field.getType();
            if (!fieldType.isConfig() || !((nestedValue = data.get(fieldName)) instanceof Map)) continue;
            Map nestedMap = (Map)nestedValue;
            if (effectiveConfigurer != null && effectiveConfigurer.getRegistry().getSerializer(fieldType.getType()) != null) continue;
            ConfigDeclaration nestedDeclaration = ConfigDeclaration.of(fieldType.getType());
            Set<String> declaredKeys = nestedDeclaration.getFieldMap().keySet();
            LinkedHashSet nestedOrphanedKeys = new LinkedHashSet(nestedMap.keySet());
            nestedOrphanedKeys.removeAll(declaredKeys);
            for (String orphanKey : nestedOrphanedKeys) {
                nestedMap.remove(orphanKey);
                allOrphans.add(fullPath + "." + orphanKey);
            }
            this.removeOrphansRecursively(nestedDeclaration, nestedMap, fullPath, allOrphans);
        }
    }

    @Generated
    public OkaeriConfig() {
    }

    @Generated
    public Path getBindFile() {
        return this.bindFile;
    }

    @Generated
    protected void setBindFile(Path bindFile) {
        this.bindFile = bindFile;
    }

    @Generated
    public Configurer getConfigurer() {
        return this.configurer;
    }

    @Generated
    protected void setDeclaration(ConfigDeclaration declaration) {
        this.declaration = declaration;
    }

    @Generated
    public ConfigContext getContext() {
        return this.context;
    }

    @Generated
    public void setContext(ConfigContext context) {
        this.context = context;
    }

    @Generated
    public Map<String, Object> getInternalState() {
        return this.internalState;
    }

    @Generated
    public void setInternalState(Map<String, Object> internalState) {
        this.internalState = internalState;
    }

    @Generated
    public ConfigPath getInternalPath() {
        return this.internalPath;
    }

    @Generated
    public void setInternalPath(ConfigPath internalPath) {
        this.internalPath = internalPath;
    }
}

