/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfigInitializer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.Configurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.configurer.InMemoryConfigurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.OkaeriException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.ConfigDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.FieldDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.schema.GenericsDeclaration;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.serdes.SerdesContext;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.util.UnsafeUtil;

public final class ConfigManager {
    public static <T extends OkaeriConfig> T create(@NonNull Class<T> clazz) throws OkaeriException {
        OkaeriConfig config;
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        try {
            config = (OkaeriConfig)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException exception) {
            throw new OkaeriException("cannot create " + clazz.getSimpleName() + " instance: make sure default constructor is available or if subconfig use new instead");
        }
        return (T)ConfigManager.initialize(config);
    }

    public static <T extends OkaeriConfig> T createUnsafe(@NonNull Class<T> clazz) throws OkaeriException {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        return (T)((OkaeriConfig)UnsafeUtil.allocateInstance(clazz));
    }

    public static <T extends OkaeriConfig> T create(@NonNull Class<T> clazz, @NonNull OkaeriConfigInitializer initializer) throws OkaeriException {
        Objects.requireNonNull(clazz, "clazz is marked non-null but is null");
        Objects.requireNonNull(initializer, "initializer is marked non-null but is null");
        T config = ConfigManager.create(clazz);
        try {
            initializer.apply((OkaeriConfig)config);
        }
        catch (Exception exception) {
            if (((OkaeriConfig)config).getConfigurer() != null) {
                throw new OkaeriException("failed to initialize " + clazz.getName() + " [" + ((OkaeriConfig)config).getConfigurer().getClass() + "]", exception);
            }
            throw new OkaeriException("failed to initialize " + clazz.getName(), exception);
        }
        return config;
    }

    public static <T extends OkaeriConfig> T transformCopy(@NonNull OkaeriConfig config, @NonNull Class<T> into) throws OkaeriException {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        Objects.requireNonNull(into, "into is marked non-null but is null");
        T copy = ConfigManager.initialize(ConfigManager.createUnsafe(into));
        Configurer configurer = config.getConfigurer();
        ((OkaeriConfig)copy).setConfigurer(configurer);
        ConfigDeclaration copyDeclaration = ((OkaeriConfig)copy).getDeclaration();
        ConfigDeclaration sourceDeclaration = config.getDeclaration();
        if (config.getBindFile() != null) {
            ((OkaeriConfig)copy).setBindFile(config.getBindFile());
        }
        Map<String, Object> sourceState = config.getInternalState();
        ConfigContext copyContext = ((OkaeriConfig)copy).getContext();
        copyDeclaration.getFields().forEach(targetField -> {
            GenericsDeclaration generics;
            Object value;
            String fieldName = targetField.getName();
            Optional<FieldDeclaration> sourceField = sourceDeclaration.getField(fieldName);
            if (sourceField.isPresent()) {
                value = sourceField.get().getValue();
                if (value != null && (value instanceof OkaeriConfig || !value.getClass().isPrimitive())) {
                    value = configurer.simplify(value, sourceField.get().getType(), SerdesContext.of(configurer, copyContext, sourceField.get()), false);
                }
                generics = GenericsDeclaration.of(value);
            } else if (sourceState != null && sourceState.containsKey(fieldName)) {
                value = sourceState.get(fieldName);
                generics = GenericsDeclaration.of(value);
            } else {
                return;
            }
            if (value != null && (targetField.getType().getType() != value.getClass() || !generics.isPrimitiveWrapper() && !generics.isPrimitive())) {
                value = configurer.resolveType(value, generics, targetField.getType().getType(), targetField.getType(), SerdesContext.of(configurer, copyContext, targetField));
            }
            targetField.updateValue(value);
        });
        return copy;
    }

    public static <T extends OkaeriConfig> T deepCopy(@NonNull OkaeriConfig config, @NonNull Configurer newConfigurer, @NonNull Class<T> into) throws OkaeriException {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        Objects.requireNonNull(newConfigurer, "newConfigurer is marked non-null but is null");
        Objects.requireNonNull(into, "into is marked non-null but is null");
        T copy = ConfigManager.initialize(ConfigManager.createUnsafe(into));
        newConfigurer.register(config.getConfigurer().getRegistry().allSerdes());
        ((OkaeriConfig)copy).setConfigurer(newConfigurer);
        if (config.getBindFile() != null) {
            ((OkaeriConfig)copy).setBindFile(config.getBindFile());
        }
        if (config.getConfigurer() instanceof InMemoryConfigurer) {
            LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
            for (FieldDeclaration field : config.getDeclaration().getFields()) {
                Object simplified = newConfigurer.simplifyField(field.getValue(), field.getType(), field, ((OkaeriConfig)copy).getContext());
                state.put(field.getName(), simplified);
            }
            ((OkaeriConfig)copy).setInternalState(state);
            ((OkaeriConfig)copy).update();
            return copy;
        }
        ((OkaeriConfig)copy).load(config.saveToString());
        return copy;
    }

    public static <T extends OkaeriConfig> T initialize(@NonNull T config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        config.getDeclaration();
        return config;
    }

    @Generated
    private ConfigManager() {
    }
}

