/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.okaeri.configs;

import java.util.Objects;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.OkaeriConfig;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.exception.ValidationException;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.validator.ConfigValidator;

public class ConfigContext {
    private final OkaeriConfig rootConfig;
    private String rawContent;
    private boolean errorComments = false;
    private boolean removeOrphans = false;
    private ConfigValidator validator;
    private Logger logger;

    public ConfigContext(@NonNull OkaeriConfig rootConfig) {
        Objects.requireNonNull(rootConfig, "rootConfig is marked non-null but is null");
        this.rootConfig = rootConfig;
        this.logger = Logger.getLogger(rootConfig.getClass().getSimpleName());
    }

    public boolean hasValidator() {
        return this.validator != null;
    }

    public void validate(@NonNull Object entity) {
        Objects.requireNonNull(entity, "entity is marked non-null but is null");
        this.validate(entity, null);
    }

    public void validate(@NonNull Object entity, Boolean isLoad) {
        Objects.requireNonNull(entity, "entity is marked non-null but is null");
        if (this.validator == null) {
            return;
        }
        if (isLoad != null) {
            if (isLoad.booleanValue() && !this.validator.validateOnLoad()) {
                return;
            }
            if (!isLoad.booleanValue() && !this.validator.validateOnSave()) {
                return;
            }
        }
        if (!this.validator.isValid(entity)) {
            throw new ValidationException(this.validator.getClass().getSimpleName() + " marked entity " + entity.getClass().getSimpleName() + " as invalid without throwing an exception");
        }
    }

    @Generated
    public OkaeriConfig getRootConfig() {
        return this.rootConfig;
    }

    @Generated
    public String getRawContent() {
        return this.rawContent;
    }

    @Generated
    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    @Generated
    public boolean isErrorComments() {
        return this.errorComments;
    }

    @Generated
    public void setErrorComments(boolean errorComments) {
        this.errorComments = errorComments;
    }

    @Generated
    public boolean isRemoveOrphans() {
        return this.removeOrphans;
    }

    @Generated
    public void setRemoveOrphans(boolean removeOrphans) {
        this.removeOrphans = removeOrphans;
    }

    @Generated
    public ConfigValidator getValidator() {
        return this.validator;
    }

    @Generated
    public void setValidator(ConfigValidator validator) {
        this.validator = validator;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

