/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.foliascheduler.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinecraftVersions {
    @NotNull
    private static final Map<String, Update> allUpdates = new LinkedHashMap<String, Update>();
    @NotNull
    private static final Map<String, Version> allVersions = new LinkedHashMap<String, Version>();
    @Nullable
    private static Version CURRENT = null;
    @NotNull
    public static final Update WORLD_OF_COLOR = MinecraftVersions.registerUpdate(new Update(1, 12, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 1);
    }));
    @NotNull
    public static final Update UPDATE_AQUATIC = MinecraftVersions.registerUpdate(new Update(1, 13, update -> {
        update.version(0, 1);
        update.version(1, 2);
        update.version(2, 2);
    }));
    @NotNull
    public static final Update VILLAGE_AND_PILLAGE = MinecraftVersions.registerUpdate(new Update(1, 14, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 1);
        update.version(3, 1);
        update.version(4, 1);
    }));
    @NotNull
    public static final Update BUZZY_BEES = MinecraftVersions.registerUpdate(new Update(1, 15, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 1);
    }));
    @NotNull
    public static final Update NETHER_UPDATE = MinecraftVersions.registerUpdate(new Update(1, 16, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 2);
        update.version(3, 2);
        update.version(4, 3);
        update.version(5, 3);
    }));
    @NotNull
    public static final Update CAVES_AND_CLIFFS_1 = MinecraftVersions.registerUpdate(new Update(1, 17, update -> {
        update.version(0, 1);
        update.version(1, 1);
    }));
    @NotNull
    public static final Update CAVES_AND_CLIFFS_2 = MinecraftVersions.registerUpdate(new Update(1, 18, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 2);
    }));
    @NotNull
    public static final Update WILD_UPDATE = MinecraftVersions.registerUpdate(new Update(1, 19, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 2);
        update.version(3, 3);
        update.version(4, 3);
    }));
    @NotNull
    public static final Update TRAILS_AND_TAILS = MinecraftVersions.registerUpdate(new Update(1, 20, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 2);
        update.version(3, 3);
        update.version(4, 3);
        update.version(5, 4);
        update.version(6, 4);
    }));
    @NotNull
    public static final Update TRICKY_TRIALS = MinecraftVersions.registerUpdate(new Update(1, 21, update -> {
        update.version(0, 1);
        update.version(1, 1);
        update.version(2, 2);
        update.version(3, 2);
        update.version(4, 3);
        update.version(5, 4);
        update.version(6, 5);
        update.version(7, 5);
    }));

    private MinecraftVersions() {
    }

    @NotNull
    private static Update registerUpdate(@NotNull Update update) {
        allUpdates.put(update.toString(), update);
        for (Version version : update.versions) {
            allVersions.put(version.toString(), version);
        }
        return update;
    }

    @NotNull
    public static Map<String, Update> updates() {
        return Collections.unmodifiableMap(allUpdates);
    }

    @NotNull
    public static Map<String, Version> versions() {
        return Collections.unmodifiableMap(allVersions);
    }

    @NotNull
    public static Version getCurrent() {
        if (CURRENT == null) {
            CURRENT = MinecraftVersions.parseCurrentVersion(Bukkit.getVersion());
        }
        return CURRENT;
    }

    @NotNull
    static Version parseCurrentVersion(@NotNull String versionString) {
        Pattern pattern = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?");
        Matcher matcher = pattern.matcher(versionString);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not find any version in: " + versionString);
        }
        String currentVersion = matcher.group();
        String[] parts = currentVersion.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
        Version version = allVersions.get(major + "." + minor + "." + patch);
        if (version != null) {
            return version;
        }
        return new Version(major, minor, patch, -1);
    }

    public static class Version
    implements Comparable<Version> {
        @NotNull
        private final Update update;
        private final int major;
        private final int minor;
        private final int patch;
        private final int protocol;

        public Version(int major, int minor, int patch, int protocol) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.protocol = protocol;
            this.update = new Update(major, minor, Collections.singletonList(this));
        }

        public Version(@NotNull Update update, int patch, int protocol) {
            this.update = update;
            this.major = update.major;
            this.minor = update.minor;
            this.patch = patch;
            this.protocol = protocol;
        }

        @NotNull
        public Update getUpdate() {
            return this.update;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public boolean isCurrent() {
            return MinecraftVersions.getCurrent().equals(this);
        }

        public boolean isAbove() {
            return MinecraftVersions.getCurrent().compareTo(this) > 0;
        }

        public boolean isAtLeast() {
            return MinecraftVersions.getCurrent().compareTo(this) >= 0;
        }

        public boolean isBelow() {
            return MinecraftVersions.getCurrent().compareTo(this) < 0;
        }

        public boolean isAtMost() {
            return MinecraftVersions.getCurrent().compareTo(this) <= 0;
        }

        @NotNull
        public String toProtocolString() {
            return "v" + this.major + "_" + this.minor + "_R" + this.protocol;
        }

        @Override
        public int compareTo(@NotNull Version other) {
            int majorCompare = Integer.compare(this.major, other.major);
            if (majorCompare != 0) {
                return majorCompare;
            }
            int minorCompare = Integer.compare(this.minor, other.minor);
            if (minorCompare != 0) {
                return minorCompare;
            }
            return Integer.compare(this.patch, other.patch);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version = (Version)o;
            return this.major == version.major && this.minor == version.minor && this.patch == version.patch;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch);
        }

        @NotNull
        public String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }
    }

    public static class Update
    implements Comparable<Update> {
        private final int major;
        private final int minor;
        private final List<Version> versions = new ArrayList<Version>();
        private boolean lock = false;

        public Update(int major, int minor, @NotNull List<Version> versions) {
            this.major = major;
            this.minor = minor;
            this.versions.addAll(versions);
            this.lock = true;
        }

        public Update(int major, int minor, @NotNull Consumer<Update> init) {
            this.major = major;
            this.minor = minor;
            init.accept(this);
            this.lock = true;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        void version(int patch, int protocol) {
            if (this.lock) {
                throw new IllegalStateException("Cannot add versions after initialization");
            }
            Version version = new Version(this, patch, protocol);
            this.versions.add(version);
        }

        public boolean isCurrent() {
            return MinecraftVersions.getCurrent().getUpdate().equals(this);
        }

        public boolean isAbove() {
            return MinecraftVersions.getCurrent().getUpdate().compareTo(this) > 0;
        }

        public boolean isAtLeast() {
            return MinecraftVersions.getCurrent().getUpdate().compareTo(this) >= 0;
        }

        public boolean isBelow() {
            return MinecraftVersions.getCurrent().getUpdate().compareTo(this) < 0;
        }

        public boolean isAtMost() {
            return MinecraftVersions.getCurrent().getUpdate().compareTo(this) <= 0;
        }

        @NotNull
        public Version get(int patch) {
            try {
                return this.versions.get(patch);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown version: " + this.major + "." + this.minor + "." + patch);
            }
        }

        @Override
        public int compareTo(@NotNull Update other) {
            int majorCompare = Integer.compare(this.major, other.major);
            return majorCompare != 0 ? majorCompare : Integer.compare(this.minor, other.minor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Update update = (Update)o;
            return this.major == update.major && this.minor == update.minor && Objects.equals(this.versions, update.versions);
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.versions);
        }

        @NotNull
        public String toString() {
            return this.major + "." + this.minor;
        }
    }
}

