/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.foliascheduler.folia;

import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import ru.padow.discordsrvoauth.relocated.foliascheduler.AsyncSchedulerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.EntitySchedulerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.GlobalSchedulerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.RegionSchedulerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.ServerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.folia.FoliaAsyncScheduler;
import ru.padow.discordsrvoauth.relocated.foliascheduler.folia.FoliaEntityScheduler;
import ru.padow.discordsrvoauth.relocated.foliascheduler.folia.FoliaGlobalScheduler;
import ru.padow.discordsrvoauth.relocated.foliascheduler.folia.FoliaRegionScheduler;

@ApiStatus.Internal
public class FoliaServer
implements ServerImplementation {
    @NotNull
    private final Plugin owningPlugin;
    @NotNull
    private final FoliaGlobalScheduler globalScheduler;
    @NotNull
    private final FoliaAsyncScheduler asyncScheduler;

    @ApiStatus.Internal
    public FoliaServer(@NotNull Plugin owningPlugin) {
        this.owningPlugin = owningPlugin;
        this.globalScheduler = new FoliaGlobalScheduler(owningPlugin);
        this.asyncScheduler = new FoliaAsyncScheduler(owningPlugin);
    }

    @Override
    @NotNull
    public Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location) {
        return Bukkit.isOwnedByCurrentRegion((Location)location);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Location location, int squareRadiusChunks) {
        return Bukkit.isOwnedByCurrentRegion((Location)location, (int)squareRadiusChunks);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Block block) {
        return Bukkit.isOwnedByCurrentRegion((Block)block);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull World world, int chunkX, int chunkZ, int squareRadiusChunks) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ, (int)squareRadiusChunks);
    }

    @Override
    public boolean isOwnedByCurrentRegion(@NotNull Entity entity) {
        return Bukkit.isOwnedByCurrentRegion((Entity)entity);
    }

    @Override
    @NotNull
    public GlobalSchedulerImplementation global() {
        return this.globalScheduler;
    }

    @Override
    @NotNull
    public AsyncSchedulerImplementation async() {
        return this.asyncScheduler;
    }

    @Override
    @NotNull
    public EntitySchedulerImplementation entity(@NotNull Entity entity) {
        return new FoliaEntityScheduler(this.owningPlugin, entity);
    }

    @Override
    @NotNull
    public RegionSchedulerImplementation region(@NotNull World world, int chunkX, int chunkZ) {
        return new FoliaRegionScheduler(this.owningPlugin, world, chunkX, chunkZ);
    }

    @Override
    public void cancelTasks() {
        this.globalScheduler.cancelTasks();
        this.asyncScheduler.cancelTasks();
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> teleportAsync(@NotNull Entity entity, @NotNull Location location, @NotNull PlayerTeleportEvent.TeleportCause cause) {
        return entity.teleportAsync(location, cause);
    }
}

