/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.foliascheduler.bukkit;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.padow.discordsrvoauth.relocated.foliascheduler.TaskImplementation;

@ApiStatus.Internal
public class BukkitTask<T>
implements TaskImplementation<T> {
    @NotNull
    private final Plugin owningPlugin;
    private final boolean isRepeatingTask;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final AtomicReference<org.bukkit.scheduler.BukkitTask> scheduledTaskRef;
    @NotNull
    private final CompletableFuture<TaskImplementation<T>> future;
    @Nullable
    private T callback;

    @ApiStatus.Internal
    public BukkitTask(@NotNull Plugin owningPlugin, boolean isRepeatingTask) {
        this.owningPlugin = owningPlugin;
        this.isRepeatingTask = isRepeatingTask;
        this.lock = new ReentrantLock();
        this.scheduledTaskRef = new AtomicReference();
        this.future = new CompletableFuture();
    }

    @ApiStatus.Internal
    public void setScheduledTask(@NotNull org.bukkit.scheduler.BukkitTask task) {
        this.scheduledTaskRef.set(task);
    }

    @Override
    @NotNull
    public Plugin getOwningPlugin() {
        return this.owningPlugin;
    }

    @Override
    public void cancel() {
        this.scheduledTaskRef.get().cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.scheduledTaskRef.get().isCancelled();
    }

    @Override
    public boolean isRunning() {
        return this.owningPlugin.getServer().getScheduler().isCurrentlyRunning(this.scheduledTaskRef.get().getTaskId());
    }

    @Override
    public boolean isRepeatingTask() {
        return this.isRepeatingTask;
    }

    @Override
    @Nullable
    public T getCallback() {
        this.lock.lock();
        try {
            T t = this.callback;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ApiStatus.Internal
    public void setCallback(@Nullable T callback) {
        this.lock.lock();
        try {
            this.callback = callback;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public CompletableFuture<TaskImplementation<T>> asFuture() {
        return this.future;
    }
}

