/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.foliascheduler.bukkit;

import java.util.function.Function;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.padow.discordsrvoauth.relocated.foliascheduler.EntitySchedulerImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.TaskImplementation;
import ru.padow.discordsrvoauth.relocated.foliascheduler.bukkit.BukkitTask;

@ApiStatus.Internal
public class BukkitEntityScheduler
implements EntitySchedulerImplementation {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Entity entity;

    @ApiStatus.Internal
    public BukkitEntityScheduler(@NotNull Plugin plugin, @NotNull Entity entity) {
        this.plugin = plugin;
        this.entity = entity;
    }

    @NotNull
    private <T> BukkitRunnable buildBukkitRunnable(final @NotNull Function<TaskImplementation<T>, T> function, final @NotNull BukkitTask<T> taskImplementation) {
        return new BukkitRunnable(){

            public void run() {
                taskImplementation.setCallback(function.apply(taskImplementation));
                taskImplementation.asFuture().complete(taskImplementation);
            }
        };
    }

    private boolean isRetired(@Nullable Runnable retired) {
        if (!this.entity.isValid()) {
            if (retired != null) {
                retired.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(final @NotNull Runnable run, final @Nullable Runnable retired, long delay) {
        if (this.isRetired(retired)) {
            return false;
        }
        new BukkitRunnable(){

            public void run() {
                if (BukkitEntityScheduler.this.isRetired(retired)) {
                    return;
                }
                run.run();
            }
        }.runTaskLater(this.plugin, delay);
        return true;
    }

    @Override
    @Nullable
    public <T> TaskImplementation<T> run(@NotNull Function<TaskImplementation<T>, T> function, @Nullable Runnable retired) {
        if (this.isRetired(retired)) {
            return null;
        }
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTask(this.plugin));
        return taskImplementation;
    }

    @Override
    @Nullable
    public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, T> function, @Nullable Runnable retired, long delay) {
        if (this.isRetired(retired)) {
            return null;
        }
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTaskLater(this.plugin, delay));
        return taskImplementation;
    }

    @Override
    @Nullable
    public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, T> function, @Nullable Runnable retired, long delay, long period) {
        if (this.isRetired(retired)) {
            return null;
        }
        BukkitTask taskImplementation = new BukkitTask(this.plugin, true);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTaskTimer(this.plugin, delay, period));
        return taskImplementation;
    }
}

