/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.annotation.JsonFormat;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.core.JsonGenerator;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.core.JsonParser;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.BeanProperty;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.JavaType;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.JsonMappingException;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.JsonNode;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.JsonSerializer;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.SerializerProvider;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.jsontype.TypeSerializer;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.ser.ContextualSerializer;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            JsonFormat.Shape shape = format.getShape();
            if (shape.isNumeric()) {
                return new AsNumber(this._forPrimitive);
            }
            if (shape == JsonFormat.Shape.STRING) {
                return new ToStringSerializer((Class<?>)this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object>
    implements ContextualSerializer {
        private static final long serialVersionUID = 1L;
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws IOException {
            g.writeNumber(Boolean.FALSE.equals(value) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            g.writeBoolean(Boolean.TRUE.equals(value));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
            JsonFormat.Shape shape;
            JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format != null && !(shape = format.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }
    }
}

