/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth.relocated.fasterxml.jackson.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.annotation.JacksonAnnotation;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.annotation.JacksonAnnotationValue;
import ru.padow.discordsrvoauth.relocated.fasterxml.jackson.annotation.OptBoolean;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JacksonInject {
    public String value() default "";

    public OptBoolean useInput() default OptBoolean.DEFAULT;

    public OptBoolean optional() default OptBoolean.DEFAULT;

    public static class Value
    implements JacksonAnnotationValue<JacksonInject>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(null, null, null);
        protected final Object _id;
        protected final Boolean _useInput;
        protected final Boolean _optional;

        protected Value(Object id, Boolean useInput, Boolean optional) {
            this._id = id;
            this._useInput = useInput;
            this._optional = optional;
        }

        @Override
        public Class<JacksonInject> valueFor() {
            return JacksonInject.class;
        }

        public static Value empty() {
            return EMPTY;
        }

        @Deprecated
        public static Value construct(Object id, Boolean useInput) {
            return Value.construct(id, useInput, null);
        }

        public static Value construct(Object id, Boolean useInput, Boolean optional) {
            if ("".equals(id)) {
                id = null;
            }
            if (Value._empty(id, useInput, optional)) {
                return EMPTY;
            }
            return new Value(id, useInput, optional);
        }

        public static Value from(JacksonInject src) {
            if (src == null) {
                return EMPTY;
            }
            return Value.construct(src.value(), src.useInput().asBoolean(), src.optional().asBoolean());
        }

        public static Value forId(Object id) {
            return Value.construct(id, null, null);
        }

        public Value withId(Object id) {
            if (id == null ? this._id == null : id.equals(this._id)) {
                return this;
            }
            return new Value(id, this._useInput, this._optional);
        }

        public Value withUseInput(Boolean useInput) {
            if (useInput == null ? this._useInput == null : useInput.equals(this._useInput)) {
                return this;
            }
            return new Value(this._id, useInput, this._optional);
        }

        public Value withOptional(Boolean optional) {
            if (optional == null ? this._optional == null : optional.equals(this._optional)) {
                return this;
            }
            return new Value(this._id, this._useInput, optional);
        }

        public Object getId() {
            return this._id;
        }

        public Boolean getUseInput() {
            return this._useInput;
        }

        public Boolean getOptional() {
            return this._optional;
        }

        public boolean hasId() {
            return this._id != null;
        }

        public boolean willUseInput(boolean defaultSetting) {
            return this._useInput == null ? defaultSetting : this._useInput;
        }

        public String toString() {
            return String.format("JacksonInject.Value(id=%s,useInput=%s,optional=%s)", this._id, this._useInput, this._optional);
        }

        public int hashCode() {
            int h = 1;
            if (this._id != null) {
                h += this._id.hashCode();
            }
            if (this._useInput != null) {
                h += this._useInput.hashCode();
            }
            if (this._optional != null) {
                h += this._optional.hashCode();
            }
            return h;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() == this.getClass()) {
                Value other = (Value)o;
                return Objects.equals(this._id, other._id) && Objects.equals(this._useInput, other._useInput) && Objects.equals(this._optional, other._optional);
            }
            return false;
        }

        private static boolean _empty(Object id, Boolean useInput, Boolean optional) {
            return id == null && useInput == null && optional == null;
        }
    }
}

