/*
 * Decompiled with CFR 0.152.
 */
package ru.padow.discordsrvoauth;

import com.sun.net.httpserver.HttpServer;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.objects.managers.AccountLinkManager;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.padow.discordsrvoauth.Config;
import ru.padow.discordsrvoauth.Utils;
import ru.padow.discordsrvoauth.relocated.bstats.bukkit.Metrics;
import ru.padow.discordsrvoauth.relocated.foliascheduler.FoliaCompatibility;
import ru.padow.discordsrvoauth.relocated.foliascheduler.ServerImplementation;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.ConfigManager;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.toml.TomlJacksonConfigurer;
import ru.padow.discordsrvoauth.relocated.okaeri.configs.yaml.bukkit.YamlBukkitConfigurer;
import ru.padow.discordsrvoauth.routes.CallbackHandler;
import ru.padow.discordsrvoauth.routes.LinkHandler;

public class DiscordSRVOAuth
extends JavaPlugin
implements Listener {
    private static Config config;
    private ServerImplementation scheduler;
    private HttpServer server;
    private ExecutorService executor;

    public void onEnable() {
        Logger logger = this.getLogger();
        this.scheduler = new FoliaCompatibility((Plugin)this).getServerImplementation();
        File toml = new File(this.getDataFolder(), "config.toml");
        File yaml = new File(this.getDataFolder(), "config.yml");
        if (yaml.exists() && !toml.exists()) {
            try {
                Config yamlConfig = ConfigManager.create(Config.class, it -> {
                    it.withConfigurer(new YamlBukkitConfigurer());
                    it.withBindFile(yaml);
                    it.load();
                });
                ConfigManager.create(Config.class, it -> {
                    it.withConfigurer(new TomlJacksonConfigurer());
                    it.withBindFile(toml);
                    it.saveDefaults();
                    it.load();
                });
                config = ConfigManager.create(Config.class, it -> {
                    it.withConfigurer(new TomlJacksonConfigurer());
                    it.withBindFile(toml);
                    it.load();
                });
                config.setHttps(yamlConfig.isHttps());
                config.setUrl(yamlConfig.getUrl());
                config.setPort(yamlConfig.getPort());
                config.setLinkRoute(yamlConfig.getLinkRoute());
                config.setKickMessage(yamlConfig.getKickMessage());
                config.setClientId(yamlConfig.getClientId());
                config.setClientSecret(yamlConfig.getClientSecret());
                config.setBotToken(yamlConfig.getBotToken());
                config.setGuildId(yamlConfig.getGuildId());
                config.setDisableWebserver(yamlConfig.isDisableWebserver());
                config.setBstats(yamlConfig.isBstats());
                config.save();
                yaml.renameTo(new File(this.getDataFolder(), "config.yml.old"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            config = ConfigManager.create(Config.class, it -> {
                it.withConfigurer(new TomlJacksonConfigurer());
                it.withBindFile(toml);
                it.saveDefaults();
                it.load(true);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.scheduler.async().runNow(() -> this.startServer());
        if (config.isBstats()) {
            new Metrics((Plugin)this, 22358);
        }
        try {
            Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
            logger.info("Using MiniMessage for the kick message");
        }
        catch (Exception e) {
            logger.info("Using legacy codes for the kick message");
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("discordsrvoauth").setExecutor((CommandExecutor)this);
    }

    public void onDisable() {
        this.stopServer();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("discordsrvoauth")) {
            if (args.length == 0) {
                String message = String.join((CharSequence)"\n", "  <color:#235a8a>\u2588<color:#a77044>\u2588<color:#235a8c>\u2588<color:#225786>\u2588<color:#245c8f>\u2588<color:#1f4f7a>\u2588<color:#a77044>\u2588<color:#235a8a>\u2588", "  <color:#a77044>\u2588<color:#fbaca2>\u2588<color:#95643d>\u2588<color:#1f4f7a>\u2588<color:#20527e>\u2588<color:#95643d>\u2588<color:#fbaca2>\u2588<color:#a77044>\u2588", "  <color:#1e4d77>\u2588<color:#235a8c>\u2588<color:#163856>\u2588<color:#1a4266>\u2588<color:#1a4266>\u2588<color:#1b456a>\u2588<color:#1f4f7a>\u2588<color:#245c8f>\u2588", "  <color:#1e4c77>\u2588<color:#163856>\u2588<color:#ae8f79>\u2588<color:#c19d82>\u2588<color:#ae8f79>\u2588<color:#c19d82>\u2588<color:#163856>\u2588<color:#20527e>\u2588    <gold>DiscordSRVOAuth <gray>v" + this.getDescription().getVersion(), "  <color:#193f62>\u2588<color:#c29e84>\u2588<color:#ae8f79>\u2588<color:#c9a68c>\u2588<color:#fbbc94>\u2588<color:#fbbc94>\u2588<color:#c9a68b>\u2588<color:#1d4a72>\u2588       <green>Made by <click:open_url:'https://padow.ru'><color:#256091>PadowYT2</click>", "  <color:#c9a68b>\u2588<color:#fbbc94>\u2588<color:#fbbc94>\u2588<color:#febb92>\u2588<color:#febb92>\u2588<color:#ffb991>\u2588<color:#ffb991>\u2588<color:#c9a68b>\u2588", "  <color:#ffb990>\u2588<color:#ffb991>\u2588<color:#a67044>\u2588<color:#242424>\u2588<color:#333332>\u2588<color:#a67044>\u2588<color:#ffb991>\u2588<color:#ffb991>\u2588", "  <color:#ffb584>\u2588<color:#ffb990>\u2588<color:#ffc197>\u2588<color:#f87e70>\u2588<color:#fa9589>\u2588<color:#ffc197>\u2588<color:#ffb990>\u2588<color:#ffb584>\u2588");
                try {
                    if (!(sender instanceof Player)) {
                        throw new Exception();
                    }
                    Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
                    sender.sendMessage(MiniMessage.miniMessage().deserialize((Object)("\n" + message + "\n")));
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a76DiscordSRVOAuth \u00a77v" + this.getDescription().getVersion() + "\n\u00a7aMade by \u00a71PadowYT2");
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("discordsrvoauth.reload")) {
                if (this.server != null) {
                    this.server.stop(1);
                }
                config.load();
                this.scheduler.async().runNow(() -> this.startServer());
                sender.sendMessage("\u00a7aReloaded the plugin");
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("discordsrvoauth") && sender.hasPermission("discordsrvoauth.reload") && args.length == 1) {
            return Arrays.asList("reload");
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(AsyncPlayerPreLoginEvent event) {
        AccountLinkManager accountLinkManager = DiscordSRV.getPlugin().getAccountLinkManager();
        if (accountLinkManager == null) {
            return;
        }
        UUID playerUuid = event.getUniqueId();
        String discordId = accountLinkManager.getDiscordIdBypassCache(playerUuid);
        if (discordId == null) {
            String code = accountLinkManager.generateCode(playerUuid);
            String route = "/" + config.getLinkRoute() + "?code=" + code;
            String botName = "Discord Bot";
            try {
                botName = DiscordSRV.getPlugin().getMainGuild().getSelfMember().getEffectiveName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String kickMessage = config.getKickMessage().replaceAll("&", "\u00a7").replace("{JOIN}", Utils.getBaseURL(config, true) + route).replace("{KICK}", Utils.getBaseURL(config, false) + route).replace("{CODE}", code).replace("{BOT}", botName);
            try {
                Class.forName("net.kyori.adventure.text.minimessage.MiniMessage");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, MiniMessage.miniMessage().deserialize((Object)kickMessage));
            }
            catch (Exception e) {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, kickMessage);
            }
        }
    }

    private void startServer() {
        this.stopServer();
        if (config.isDisableWebserver()) {
            return;
        }
        try {
            System.setProperty("sun.net.httpserver.maxReqTime", "10000");
            System.setProperty("sun.net.httpserver.maxRspTime", "10000");
            this.server = HttpServer.create(new InetSocketAddress("0.0.0.0", config.getPort()), 50);
            this.server.createContext("/", exchange -> {
                exchange.sendResponseHeaders(404, -1L);
                exchange.close();
            });
            this.server.createContext("/" + config.getLinkRoute(), new LinkHandler());
            this.server.createContext("/callback", new CallbackHandler());
            this.executor = Executors.newCachedThreadPool();
            this.server.setExecutor(this.executor);
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void stopServer() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        if (this.server != null) {
            this.server.stop(1);
        }
    }

    @Generated
    public static Config config() {
        return config;
    }
}

