/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.token;

import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.Value;

public class BinaryOperation
implements Value {
    private BinaryOperator operator;
    private Value first;
    private Value second;

    public BinaryOperation(BinaryOperator operator, Value first, Value second) {
        this.operator = operator;
        this.first = first;
        this.second = second;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public Value[] getValues() {
        return new Value[]{this.first, this.second};
    }

    @Override
    public double getValue() {
        return this.operator.operate.applyAsDouble(this.first.getValue(), this.second.getValue());
    }

    @Override
    public TokenType getType() {
        return TokenType.BINARY_OPERATION;
    }

    public String toString() {
        return "(" + this.first.toString() + this.operator.symbol + this.second.toString() + ")";
    }

    @Override
    public BinaryOperation getClone() {
        return new BinaryOperation(this.operator, this.first.getClone(), this.second.getClone());
    }
}

