/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.UltimateShop;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SchedulerUtil {
    private BukkitTask bukkitTask;
    private ScheduledTask scheduledTask;

    public SchedulerUtil(BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }

    public SchedulerUtil(ScheduledTask scheduledTask) {
        this.scheduledTask = scheduledTask;
    }

    public void cancel() {
        if (UltimateShop.isFolia) {
            this.scheduledTask.cancel();
        } else {
            this.bukkitTask.cancel();
        }
    }

    public static void runSync(Runnable task) {
        if (UltimateShop.isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)UltimateShop.instance, task);
        } else {
            Bukkit.getScheduler().runTask((Plugin)UltimateShop.instance, task);
        }
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (UltimateShop.isFolia) {
            task.run();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)UltimateShop.instance, task);
        }
    }

    public static SchedulerUtil runTaskLater(Runnable task, long delayTicks) {
        if (UltimateShop.isFolia) {
            if (delayTicks <= 0L) {
                delayTicks = 1L;
            }
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)UltimateShop.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLater((Plugin)UltimateShop.instance, task, delayTicks));
    }

    public static SchedulerUtil runTaskTimer(Runnable task, long delayTicks, long periodTicks) {
        if (UltimateShop.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)UltimateShop.instance, scheduledTask -> task.run(), delayTicks, periodTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskTimer((Plugin)UltimateShop.instance, task, delayTicks, periodTicks));
    }

    public static SchedulerUtil runTaskLaterAsynchronously(Runnable task, long delayTicks) {
        if (UltimateShop.isFolia) {
            return new SchedulerUtil(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)UltimateShop.instance, scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)UltimateShop.instance, task, delayTicks));
    }

    public static SchedulerUtil runTaskLater(Block block, Runnable task, long delayTicks) {
        if (UltimateShop.isFolia) {
            if (delayTicks <= 0L) {
                delayTicks = 1L;
            }
            return new SchedulerUtil(Bukkit.getRegionScheduler().runDelayed((Plugin)UltimateShop.instance, block.getLocation(), scheduledTask -> task.run(), delayTicks));
        }
        return new SchedulerUtil(Bukkit.getScheduler().runTaskLater((Plugin)UltimateShop.instance, task, delayTicks));
    }
}

