/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.mythicchanger.paper.utils.PaperTextUtil;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.utils.PacketListener;
import cn.superiormc.ultimateshop.utils.TextUtil;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PacketInventoryUtil {
    public static PacketInventoryUtil packetInventoryUtil;
    protected final Map<UUID, Integer> WINDOW_IDS = new ConcurrentHashMap<UUID, Integer>();
    protected final Map<UUID, Integer> WINDOW_TYPES = new ConcurrentHashMap<UUID, Integer>();

    public PacketInventoryUtil() {
        packetInventoryUtil = this;
        this.initListener();
    }

    private void initListener() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)new PacketListener());
    }

    public void updateTitle(Player player, InvGUI gui) {
        String newTitle = TextUtil.withPAPI(gui.title, player);
        UUID uuid = player.getUniqueId();
        Integer windowId = this.WINDOW_IDS.get(uuid);
        Integer windowType = this.WINDOW_TYPES.get(uuid);
        if (windowId == null || windowType == null) {
            return;
        }
        WrapperPlayServerOpenWindow packet = new WrapperPlayServerOpenWindow(windowId.intValue(), windowType.intValue(), PaperTextUtil.modernParse((String)newTitle));
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)packet);
        if (ConfigManager.configManager.getBoolean("menu.title-update.resend-items-pack")) {
            ArrayList<com.github.retrooper.packetevents.protocol.item.ItemStack> items = new ArrayList<com.github.retrooper.packetevents.protocol.item.ItemStack>();
            for (ItemStack bukkitItem : gui.getInv().getContents()) {
                items.add(SpigotConversionUtil.fromBukkitItemStack((ItemStack)bukkitItem));
            }
            WrapperPlayServerWindowItems itemsPacket = new WrapperPlayServerWindowItems(windowId.intValue(), 0, items, null);
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)itemsPacket);
        }
        player.updateInventory();
    }

    public void clear(Player player) {
        UUID uuid = player.getUniqueId();
        this.WINDOW_IDS.remove(uuid);
        this.WINDOW_TYPES.remove(uuid);
    }
}

