/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.utils.TextUtil;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemStack;
import org.geysermc.floodgate.api.FloodgateApi;
import org.json.JSONObject;

public class CommonUtil {
    public static boolean checkPluginLoad(String pluginName) {
        if (pluginName == null) {
            return false;
        }
        if (ConfigManager.configManager.getBoolean("bypass-plugin-check." + pluginName)) {
            return true;
        }
        return UltimateShop.instance.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    public static boolean checkPermission(Player player, String permission) {
        if (CommonUtil.checkPluginLoad("LuckPerms")) {
            return LuckPermsProvider.get().getPlayerAdapter(Player.class).getPermissionData((Object)player).checkPermission(permission).asBoolean();
        }
        return player.hasPermission(permission);
    }

    public static boolean getMajorVersion(int version) {
        return UltimateShop.majorVersion >= version;
    }

    public static boolean getMinorVersion(int majorVersion, int minorVersion) {
        return UltimateShop.majorVersion > majorVersion || UltimateShop.majorVersion == majorVersion && UltimateShop.minorVersion >= minorVersion;
    }

    public static LocalDateTime getNowTime() {
        LocalDateTime now = LocalDateTime.now();
        if (ConfigManager.configManager.getBoolean("time-offset.enabled")) {
            return now.plusHours(ConfigManager.configManager.getInt("time-offset.offset-hours", 0)).plusMinutes(ConfigManager.configManager.getInt("time-offset.offset-minutes", 0)).plusSeconds(ConfigManager.configManager.getInt("time-offset.offset-seconds", 0));
        }
        return now;
    }

    public static void summonMythicMobs(Location location, String mobID, int level) {
        block2: {
            try {
                MythicBukkit.inst().getMobManager().getMythicMob(mobID).ifPresent(mob -> mob.spawn(io.lumine.mythic.bukkit.BukkitAdapter.adapt((Location)location), (double)level));
            }
            catch (NoClassDefFoundError ep) {
                MythicMob mob2 = MythicMobs.inst().getMobManager().getMythicMob(mobID);
                if (mob2 == null) break block2;
                mob2.spawn(BukkitAdapter.adapt((Location)location), (double)level);
            }
        }
    }

    public static String modifyString(String text, String ... args) {
        for (int i = 0; i < args.length; i += 2) {
            String var1 = "{" + args[i] + "}";
            String var2 = "%" + args[i] + "%";
            text = args[i + 1] == null ? text.replace(var1, "").replace(var2, "") : text.replace(var1, args[i + 1]).replace(var2, args[i + 1]);
        }
        return text;
    }

    public static List<String> modifyList(Player player, List<String> config, String ... args) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (String s : config) {
            for (int i = 0; i < args.length; i += 2) {
                String var = "{" + args[i] + "}";
                s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
            }
            String[] tempVal1 = s.split(";;");
            if (tempVal1.length > 1) {
                for (String string : tempVal1) {
                    resultList.add(TextUtil.withPAPI(string, player));
                }
                continue;
            }
            resultList.add(TextUtil.withPAPI(s, player));
        }
        return resultList;
    }

    public static LocalDateTime stringToTime(String time) {
        if (time.equals("null")) {
            return null;
        }
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static LocalDateTime stringToTime(String time, String format) {
        if (time.equals("null")) {
            return null;
        }
        return LocalDateTime.parse(time, DateTimeFormatter.ofPattern(format));
    }

    public static String timeToString(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String timeToString(LocalDateTime time, String format) {
        if (time == null) {
            return null;
        }
        return time.format(DateTimeFormatter.ofPattern(format));
    }

    public static void mkDir(File dir) {
        if (!dir.exists()) {
            File parentFile = dir.getParentFile();
            if (parentFile == null) {
                return;
            }
            String parentPath = parentFile.getPath();
            CommonUtil.mkDir(new File(parentPath));
            dir.mkdir();
        }
    }

    public static boolean getClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean checkClass(String className, String methodName) {
        try {
            Method[] methods;
            Class<?> targetClass = Class.forName(className);
            for (Method method : methods = targetClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isBedrockPlayer(Player player) {
        if (!UltimateShop.useGeyser || !ConfigManager.configManager.getBoolean("menu.bedrock.enabled")) {
            return false;
        }
        if (ConfigManager.configManager.getString("menu.bedrock.check-method", "FLOODGATE").equalsIgnoreCase("FLOODGATE")) {
            return FloodgateApi.getInstance().getPlayer(player.getUniqueId()) != null;
        }
        return player.getUniqueId().toString().startsWith("00000000-0000-0000-000");
    }

    public static NamespacedKey parseNamespacedKey(String key) {
        String[] keySplit = key.split(":");
        if (keySplit.length == 1) {
            return NamespacedKey.minecraft((String)key.toLowerCase());
        }
        if (CommonUtil.getMajorVersion(16)) {
            return NamespacedKey.fromString((String)key);
        }
        return new NamespacedKey("ultimateshop", "unknown");
    }

    public static Color parseColor(String color) {
        String[] keySplit = color.replace(" ", "").split(",");
        if (keySplit.length == 3) {
            return Color.fromRGB((int)Integer.parseInt(keySplit[0]), (int)Integer.parseInt(keySplit[1]), (int)Integer.parseInt(keySplit[2]));
        }
        return Color.fromRGB((int)Integer.parseInt(color));
    }

    public static List<Color> parseColorList(List<String> rawList) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String value : rawList) {
            try {
                colors.add(CommonUtil.parseColor(value));
            }
            catch (Exception e) {
                return colors;
            }
        }
        return colors;
    }

    public static void giveOrDrop(Player player, ItemStack ... item) {
        if (player == null || item == null) {
            return;
        }
        HashMap result = player.getInventory().addItem(item);
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                player.getWorld().dropItem(player.getLocation(), (ItemStack)result.get(id));
            }
        }
    }

    public static JSONObject fetchJson(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            JSONObject jSONObject = new JSONObject(response.toString());
            return jSONObject;
        }
    }

    public static void logFile(String filePath, String textToAppend) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(UltimateShop.instance.getDataFolder()) + "/" + filePath, true));){
            writer.write(textToAppend);
            writer.newLine();
        }
        catch (IOException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Can not write log file: " + filePath);
        }
    }

    public static String translateStringList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String tempVal1 : list) {
            if (!first) {
                builder.append(";;");
            }
            builder.append(tempVal1);
            first = false;
        }
        return builder.toString();
    }

    public static List<String> translateString(String string) {
        if (string == null) {
            return null;
        }
        return new ArrayList<String>(Arrays.asList(string.split(";;")));
    }

    public static boolean containsAnyString(String text, String ... keywords) {
        if (text == null || keywords == null) {
            return false;
        }
        for (String keyword : keywords) {
            if (!text.equals(keyword)) continue;
            return true;
        }
        return false;
    }

    public static boolean actionIsLeftClick(Action action) {
        return action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
    }

    public static boolean actionIsRightClick(Action action) {
        return action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
    }
}

