/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.utils;

import cn.superiormc.ultimateshop.gui.AbstractGUI;
import cn.superiormc.ultimateshop.gui.GUIStatus;
import cn.superiormc.ultimateshop.utils.SchedulerUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;

public class CommandUtil {
    private static final Map<Player, SchedulerUtil> guiUpdateTask = new HashMap<Player, SchedulerUtil>();

    public static void registerCustomCommand(BukkitCommand command) {
        CommandMap commandMap;
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (commandMap == null) {
            return;
        }
        commandMap.register("ultimateshop", (Command)command);
    }

    public static void updateGUI(Player player) {
        GUIStatus guiStatus;
        if (player != null && (guiStatus = AbstractGUI.playerList.get(player)) != null && guiStatus.getGUI() != null) {
            SchedulerUtil task = guiUpdateTask.get(player);
            if (task != null) {
                task.cancel();
                guiUpdateTask.remove(player);
            }
            guiUpdateTask.put(player, SchedulerUtil.runTaskLater(() -> guiStatus.getGUI().constructGUI(), 20L));
        }
    }
}

