/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.menus;

import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreBuyButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectMoreDisplayButton;
import cn.superiormc.ultimateshop.objects.menus.MenuType;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectMoreMenu
extends ObjectMenu {
    private final ObjectItem item;
    private int displayItemSlot = -1;
    private final ConfigurationSection section;
    private boolean invalid;

    public ObjectMoreMenu(ConfigurationSection section, ObjectItem item) {
        super(section.getString("menu", "buy-more"), item);
        this.item = item;
        this.type = MenuType.More;
        this.section = section;
        this.invalid = true;
        this.initDisplayItem();
        this.initConfirmItem();
        this.initSelectAmountItem();
    }

    private void initDisplayItem() {
        if (this.menuConfigs == null) {
            return;
        }
        String displayItem = this.menuConfigs.getString("display-item");
        if (displayItem == null) {
            return;
        }
        this.parseLayout(this.menuConfigs.getStringList("layout"), (slot, id) -> {
            if (displayItem.equals(id)) {
                this.displayItemSlot = slot;
                this.getButtons().put((Integer)slot, new ObjectMoreDisplayButton(this.menuConfigs.getConfigurationSection("display-item"), this.item));
            }
        });
    }

    private void initConfirmItem() {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("confirm-items");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            ObjectMoreBuyButton buyButton = new ObjectMoreBuyButton(tempVal1.getConfigurationSection(button), this.item);
            this.buttonItems.put(button, buyButton);
            if (buyButton.isInvalid()) continue;
            this.invalid = false;
        }
        this.parseLayout(this.menuConfigs.getStringList("layout"), (slot, id) -> {
            AbstractButton btn = (AbstractButton)this.buttonItems.get(id);
            if (btn != null) {
                this.getButtons().put((Integer)slot, btn);
            }
        });
    }

    private void initSelectAmountItem() {
        if (this.menuConfigs == null) {
            return;
        }
        ConfigurationSection tempVal1 = this.menuConfigs.getConfigurationSection("amount-items");
        if (tempVal1 == null) {
            return;
        }
        for (String button : tempVal1.getKeys(false)) {
            this.buttonItems.put(button, new ObjectMoreButton(tempVal1.getConfigurationSection(button)));
        }
        this.parseLayout(this.menuConfigs.getStringList("layout"), (slot, id) -> {
            AbstractButton btn = (AbstractButton)this.buttonItems.get(id);
            if (btn != null) {
                this.getButtons().put((Integer)slot, btn);
            }
        });
    }

    public int getDisplayItemSlot() {
        return this.displayItemSlot;
    }

    public ConfigurationSection getSection() {
        return this.section;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

