/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.subobjects;

import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import java.util.Random;
import org.bukkit.entity.Player;

public class RandomElement {
    private final String value;
    private final int rate;
    private final ObjectCondition condition;

    public RandomElement(String value, int rate, ObjectCondition condition) {
        this.value = value;
        this.rate = rate;
        this.condition = condition;
    }

    public String getValue() {
        return this.value;
    }

    public String parseValue() {
        String[] element = this.value.split("~");
        if (element.length == 1) {
            return this.value;
        }
        int min = Integer.parseInt(element[0]);
        int max = Integer.parseInt(element[1]);
        Random random = new Random();
        return String.valueOf(random.nextInt(max - min + 1) + min);
    }

    public int getRate() {
        return this.rate;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }

    public boolean isAvailable(Player player) {
        return this.condition.getAllBoolean(new ObjectThingRun(player));
    }
}

