/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items.subobjects;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.objects.caches.ObjectRandomPlaceholderCache;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.objects.items.subobjects.RandomElement;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectRandomPlaceholder {
    private final String id;
    private final ConfigurationSection section;
    private final List<RandomElement> elements = new ArrayList<RandomElement>();
    private final Collection<ObjectRandomPlaceholder> notSameAs = new ArrayList<ObjectRandomPlaceholder>();
    private final int elementAmount;
    private final boolean perPlayer;

    public ObjectRandomPlaceholder(String id, ConfigurationSection section) {
        this.id = id;
        this.section = section;
        this.perPlayer = section.getBoolean("per-player-element", false);
        this.elementAmount = section.getInt("element-amount", 1);
        if (section.isList("elements")) {
            for (String str : section.getStringList("elements")) {
                this.elements.add(new RandomElement(str, 1, new ObjectCondition()));
            }
        } else if (section.isConfigurationSection("elements")) {
            ConfigurationSection elemSec = section.getConfigurationSection("elements");
            for (String key : elemSec.getKeys(false)) {
                ConfigurationSection single = elemSec.getConfigurationSection(key);
                if (single == null) continue;
                int rate = single.getInt("rate", 1);
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fAdded element " + key + " for random placeholder: " + id + ".yml!");
                this.elements.add(new RandomElement(key, rate, new ObjectCondition(single.getConfigurationSection("conditions"))));
            }
        }
        UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded random placeholder: " + id + ".yml!");
    }

    public Collection<ObjectRandomPlaceholder> getNotSameAs() {
        return this.notSameAs;
    }

    public String getID() {
        return this.id;
    }

    public List<String> getConfigElements() {
        ArrayList<String> result = new ArrayList<String>();
        for (RandomElement randomElement : this.elements) {
            result.add(randomElement.getValue());
        }
        return result;
    }

    public List<RandomElement> getElements() {
        return this.elements;
    }

    public List<String> getNewValue(ObjectCache cache) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.elements.isEmpty()) {
            result.add("ERROR: Value Empty");
            return result;
        }
        ArrayList<RandomElement> available = new ArrayList<RandomElement>();
        for (RandomElement elem : this.elements) {
            if (!cache.isServer() && !elem.isAvailable(cache.getPlayer())) continue;
            available.add(elem);
        }
        if (available.isEmpty()) {
            result.add("ERROR: No Available Value");
            return result;
        }
        ArrayList<RandomElement> chosenList = new ArrayList<RandomElement>();
        int size = available.size();
        for (int i = 0; i < Math.min(this.elementAmount, size); ++i) {
            RandomElement chosen = this.getWeightedRandom(available);
            chosenList.add(chosen);
            available.remove(chosen);
        }
        boolean sortByOriginal = this.section.getBoolean("element-sort", true);
        if (sortByOriginal) {
            HashSet chosenSet = new HashSet(chosenList);
            for (RandomElement elem : this.elements) {
                if (!chosenSet.contains(elem)) continue;
                result.add(elem.parseValue());
            }
        } else {
            for (RandomElement elem : chosenList) {
                result.add(elem.parseValue());
            }
        }
        return result;
    }

    private RandomElement getWeightedRandom(List<RandomElement> elements) {
        int totalWeight = elements.stream().mapToInt(RandomElement::getRate).sum();
        int rnd = new Random().nextInt(totalWeight);
        int cur = 0;
        for (RandomElement elem : elements) {
            if (rnd >= (cur += elem.getRate())) continue;
            return elem;
        }
        return elements.get(0);
    }

    public ConfigurationSection getConfig() {
        return this.section;
    }

    public String getMode() {
        String tempVal1 = this.section.getString("reset-mode");
        if (tempVal1 == null) {
            return "NEVER";
        }
        return tempVal1.toUpperCase();
    }

    public List<String> getNowValue(ObjectCache cache) {
        ObjectRandomPlaceholderCache tempVal1 = cache.getRandomPlaceholderCache().get(this);
        if (tempVal1 == null) {
            cache.addRandomPlaceholderCache(this);
            tempVal1 = cache.getRandomPlaceholderCache().get(this);
        }
        if (tempVal1 == null) {
            return new ArrayList<String>();
        }
        return tempVal1.getNowValue(false, false);
    }

    public boolean isPerPlayer() {
        return this.perPlayer;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectRandomPlaceholder) {
            return ((ObjectRandomPlaceholder)object).getID().equals(this.getID());
        }
        return false;
    }

    public static String getNowValue(Player player, String id, int x) {
        return "ERROR: Free Version";
    }

    public static LocalDateTime getRefreshDoneTimeObject(Player player, String id) {
        return CommonUtil.getNowTime().withYear(2999);
    }

    public static String getRefreshDoneTime(Player player, String id) {
        return CommonUtil.timeToString(ObjectRandomPlaceholder.getRefreshDoneTimeObject(player, id), ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public static String getNextTime(Player player, String id) {
        return "";
    }
}

