/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class TakeResult {
    private final Map<AbstractSingleThing, BigDecimal> resultMap;
    private boolean resultBoolean;
    public boolean empty;

    public TakeResult(Map<AbstractSingleThing, BigDecimal> resultMap) {
        this.resultMap = resultMap;
        this.resultBoolean = false;
        this.empty = resultMap.isEmpty();
    }

    public void setResultBoolean() {
        this.resultBoolean = true;
    }

    public void addResultMapElement(AbstractSingleThing thing, BigDecimal amount) {
        this.resultMap.put(thing, amount);
        this.empty = false;
    }

    public Map<AbstractSingleThing, BigDecimal> getResultMap() {
        return this.resultMap;
    }

    public AbstractThings getThings() {
        Iterator<AbstractSingleThing> iterator = this.resultMap.keySet().iterator();
        if (iterator.hasNext()) {
            AbstractSingleThing singleThing = iterator.next();
            return singleThing.getThings();
        }
        return null;
    }

    public boolean getResultBoolean() {
        return this.resultBoolean;
    }

    public void take(int times, int amount, Inventory inventory, Player player) {
        for (AbstractSingleThing singleThing : this.resultMap.keySet()) {
            double cost = this.resultMap.get(singleThing).doubleValue();
            singleThing.playerHasEnough(inventory, player, true, cost);
            singleThing.takeAction.runAllActions(new ObjectThingRun(player, times, amount, cost));
        }
    }
}

