/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.actions.ObjectSingleAction;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class ObjectAction {
    private ConfigurationSection section;
    private final List<ObjectSingleAction> everyActions = new ArrayList<ObjectSingleAction>();
    private final List<ObjectSingleAction> onceActions = new ArrayList<ObjectSingleAction>();
    private ObjectShop shop = null;
    private ObjectItem item = null;
    private boolean isEmpty = false;
    private ProductTradeStatus lastTradeStatus = null;

    public ObjectAction() {
        this.isEmpty = true;
    }

    public ObjectAction(ConfigurationSection section) {
        this.section = section;
        this.initAction();
    }

    public ObjectAction(ConfigurationSection section, ObjectShop shop) {
        this.section = section;
        this.shop = shop;
        this.initAction();
    }

    public ObjectAction(ConfigurationSection section, ObjectItem item) {
        this.section = section;
        this.shop = item.getShopObject();
        this.item = item;
        this.initAction();
    }

    private void initAction() {
        if (this.section == null) {
            this.isEmpty = true;
            this.section = new MemoryConfiguration();
            return;
        }
        for (String key : this.section.getKeys(false)) {
            ConfigurationSection singleActionSection = this.section.getConfigurationSection(key);
            if (singleActionSection == null) continue;
            ObjectSingleAction singleAction = this.item != null ? new ObjectSingleAction(this, singleActionSection, this.item) : (this.shop != null ? new ObjectSingleAction(this, singleActionSection, this.shop) : new ObjectSingleAction(this, singleActionSection));
            if (singleAction.isMultiOnce()) {
                this.onceActions.add(singleAction);
                continue;
            }
            this.everyActions.add(singleAction);
        }
        this.isEmpty = this.onceActions.isEmpty() && this.everyActions.isEmpty();
    }

    public void runAllActions(ObjectThingRun thingRun) {
        this.runAllOnceActions(thingRun);
        for (int i = 0; i < thingRun.getMulti(); ++i) {
            this.runAllEveryActions(thingRun);
        }
    }

    public void runAllEveryActions(ObjectThingRun thingRun) {
        for (ObjectSingleAction singleAction : this.everyActions) {
            singleAction.doAction(thingRun);
        }
    }

    public void runAllOnceActions(ObjectThingRun thingRun) {
        for (ObjectSingleAction singleAction : this.onceActions) {
            singleAction.doAction(thingRun);
        }
    }

    public void runAnyActions(ObjectThingRun thingRun, int amount) {
        this.runRandomOnceActions(thingRun, amount);
        for (int i = 0; i < thingRun.getMulti(); ++i) {
            this.runRandomEveryActions(thingRun, amount);
        }
    }

    public void runRandomOnceActions(ObjectThingRun thingRun, int x) {
        Collections.shuffle(this.onceActions);
        for (int i = 0; i < Math.min(x, this.onceActions.size()); ++i) {
            this.onceActions.get(i).doAction(thingRun);
        }
    }

    public void runRandomEveryActions(ObjectThingRun thingRun, int x) {
        Collections.shuffle(this.everyActions);
        for (int i = 0; i < Math.min(x, this.everyActions.size()); ++i) {
            this.everyActions.get(i).doAction(thingRun);
        }
    }

    public void setLastTradeStatus(ProductTradeStatus status) {
        this.lastTradeStatus = status;
    }

    public ProductTradeStatus getLastTradeStatus() {
        return this.lastTradeStatus;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public ConfigurationSection getSection() {
        return this.section;
    }
}

