/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.AbstractThings;
import cn.superiormc.ultimateshop.objects.items.GiveItemStack;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Player;

public class GiveResult {
    private final Map<AbstractSingleThing, BigDecimal> resultMap;
    public boolean empty;

    public GiveResult(Map<AbstractSingleThing, BigDecimal> resultMap) {
        this.resultMap = resultMap;
        this.empty = resultMap.isEmpty();
    }

    public void addResultMapElement(AbstractSingleThing thing, BigDecimal amount) {
        this.resultMap.put(thing, amount);
        this.empty = false;
    }

    public Map<AbstractSingleThing, BigDecimal> getResultMap() {
        return this.resultMap;
    }

    public AbstractThings getThings() {
        Iterator<AbstractSingleThing> iterator = this.resultMap.keySet().iterator();
        if (iterator.hasNext()) {
            AbstractSingleThing singleThing = iterator.next();
            return singleThing.getThings();
        }
        return null;
    }

    public boolean give(int times, int multi, Player player, double multiplier) {
        boolean resultBoolean = true;
        ArrayList<GiveItemStack> giveItemStacks = new ArrayList<GiveItemStack>();
        for (AbstractSingleThing singleThing : this.resultMap.keySet()) {
            GiveItemStack giveItemStack = singleThing.playerCanGive(player, this.resultMap.get(singleThing).doubleValue());
            giveItemStacks.add(giveItemStack);
            if (giveItemStack.isCanGive()) continue;
            resultBoolean = false;
        }
        if (!resultBoolean) {
            return false;
        }
        for (GiveItemStack giveItemStack : giveItemStacks) {
            giveItemStack.giveToPlayer(times, multi, multiplier, player);
        }
        return true;
    }
}

