/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.HookManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveItemStack {
    private ItemStack displayItem;
    private ItemStack targetItem;
    private Collection<ItemStack> items;
    private double cost;
    private boolean canGive;
    private final AbstractSingleThing thing;

    public GiveItemStack(Collection<ItemStack> items, ItemStack targetItem, ItemStack displayItem, boolean canGive, AbstractSingleThing thing) {
        this.displayItem = displayItem;
        this.targetItem = targetItem;
        this.items = items;
        this.thing = thing;
        this.canGive = !ConfigManager.configManager.getBoolean("give-item.check-full") ? true : canGive;
    }

    public GiveItemStack(double cost, AbstractSingleThing thing) {
        this.cost = cost;
        this.thing = thing;
        this.canGive = true;
    }

    public GiveItemStack(ItemStack targetItem, ItemStack displayItem, AbstractSingleThing thing) {
        this.targetItem = targetItem;
        this.thing = thing;
        this.displayItem = displayItem;
        this.items = new ArrayList<ItemStack>();
        this.items.add(displayItem);
        this.canGive = true;
    }

    public GiveItemStack(AbstractSingleThing thing) {
        this.thing = thing;
        this.canGive = true;
    }

    public Collection<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public void giveToPlayer(int times, int multi, double multiplier, Player player) {
        if (this.thing.singleSection == null) {
            return;
        }
        switch (this.thing.type) {
            case VANILLA_ITEM: 
            case HOOK_ITEM: 
            case MATCH_ITEM: {
                if (this.items == null) break;
                for (ItemStack tempVal1 : this.items) {
                    CommonUtil.giveOrDrop(player, tempVal1);
                }
                break;
            }
            case HOOK_ECONOMY: {
                HookManager.hookManager.giveEconomy(this.thing.singleSection.getString("economy-plugin"), this.thing.singleSection.getString("economy-type", "Unknown"), player, this.cost * multiplier);
                break;
            }
            case VANILLA_ECONOMY: {
                HookManager.hookManager.giveEconomy(this.thing.singleSection.getString("economy-type"), player, (int)(this.cost * multiplier));
            }
        }
        this.thing.giveAction.runAllActions(new ObjectThingRun(player, times, multi, this.cost));
    }

    public void setCanGive(boolean canGive) {
        this.canGive = canGive;
    }

    public boolean isCanGive() {
        return this.canGive;
    }

    public ItemStack getTargetItem() {
        return this.targetItem;
    }

    public AbstractSingleThing getThing() {
        return this.thing;
    }
}

