/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.items;

import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.ThingMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class AbstractThings {
    public ThingMode mode;
    public ConfigurationSection section;
    public boolean empty;
    protected ObjectItem item;

    public AbstractThings() {
        this.mode = ThingMode.UNKNOWN;
        this.empty = true;
    }

    public AbstractThings(ConfigurationSection section, String mode, ObjectItem item) {
        this.initThingMode(mode);
        this.section = section;
        this.item = item;
    }

    public ThingMode getMode() {
        return this.mode;
    }

    public abstract GiveResult give(Player var1, int var2, int var3);

    public abstract TakeResult take(Inventory var1, Player var2, int var3, int var4, boolean var5);

    private void initThingMode(String mode) {
        switch (mode.toUpperCase()) {
            case "ANY": {
                this.mode = ThingMode.ANY;
                break;
            }
            case "ALL": {
                this.mode = ThingMode.ALL;
                break;
            }
            case "CLASSIC": 
            case "CLASSIC_ALL": {
                this.mode = ThingMode.CLASSIC_ALL;
                break;
            }
            case "CLASSIC_ANY": {
                this.mode = ThingMode.CLASSIC_ANY;
                break;
            }
            default: {
                this.mode = ThingMode.UNKNOWN;
            }
        }
    }

    public ObjectItem getItem() {
        return this.item;
    }
}

