/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.conditions;

import cn.superiormc.ultimateshop.managers.ConditionManager;
import cn.superiormc.ultimateshop.objects.AbstractSingleRun;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.objects.items.ObjectCondition;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectSingleCondition
extends AbstractSingleRun {
    private final ObjectCondition condition;
    private ObjectAction notMeetActions;
    private ObjectAction meetActions;

    public ObjectSingleCondition(ObjectCondition condition, ConfigurationSection conditionSection) {
        super(conditionSection);
        this.condition = condition;
        this.initActions();
    }

    public ObjectSingleCondition(ObjectCondition condition, ConfigurationSection conditionSection, ObjectItem item) {
        super(conditionSection, item);
        this.condition = condition;
        this.initActions();
    }

    public ObjectSingleCondition(ObjectCondition condition, ConfigurationSection conditionSection, ObjectShop shop) {
        super(conditionSection, shop);
        this.condition = condition;
        this.initActions();
    }

    private void initActions() {
        this.meetActions = new ObjectAction(this.section.getConfigurationSection("meet-actions"));
        this.notMeetActions = new ObjectAction(this.section.getConfigurationSection("not-meet-actions"));
    }

    public boolean checkBoolean(ObjectThingRun thingRun) {
        if (this.startApply >= 0 && thingRun.getTimes() < this.startApply) {
            return true;
        }
        if (this.endApply >= 0 && thingRun.getTimes() > this.startApply) {
            return true;
        }
        if (!this.apply.isEmpty() && !this.apply.contains(thingRun.getTimes())) {
            return true;
        }
        if (this.clickType != null && !this.clickType.equals(thingRun.getType().name())) {
            return true;
        }
        if (thingRun.getPlayer() != null && this.bedrockOnly && !CommonUtil.isBedrockPlayer(thingRun.getPlayer())) {
            return true;
        }
        if (thingRun.getPlayer() != null && this.javaOnly && CommonUtil.isBedrockPlayer(thingRun.getPlayer())) {
            return true;
        }
        boolean result = ConditionManager.conditionManager.checkBoolean(this, thingRun);
        return result;
    }

    public ObjectCondition getCondition() {
        return this.condition;
    }
}

