/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.conditions;

import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.conditions.ObjectSingleCondition;

public abstract class AbstractCheckCondition {
    private final String type;
    private String[] requiredArgs;

    public AbstractCheckCondition(String type) {
        this.type = type;
    }

    protected void setRequiredArgs(String ... requiredArgs) {
        this.requiredArgs = requiredArgs;
    }

    public boolean checkCondition(ObjectSingleCondition singleCondition, ObjectThingRun thingRun) {
        if (this.requiredArgs != null) {
            for (String arg : this.requiredArgs) {
                if (singleCondition.getSection().contains(arg)) continue;
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your condition missing required arg: " + arg + ".");
                return true;
            }
        }
        return this.onCheckCondition(singleCondition, thingRun);
    }

    protected abstract boolean onCheckCondition(ObjectSingleCondition var1, ObjectThingRun var2);

    public String getType() {
        return this.type;
    }
}

