/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.SchedulerUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ResetTaskPool {
    private static final long MERGE_SECONDS = 1L;
    private static final Set<ResetTaskGroup> GROUPS = ConcurrentHashMap.newKeySet();

    private ResetTaskPool() {
    }

    public static void registerBuy(ObjectUseTimesCache cache, LocalDateTime refreshTime) {
        ResetTaskPool.register(cache, refreshTime, true);
    }

    public static void registerSell(ObjectUseTimesCache cache, LocalDateTime refreshTime) {
        ResetTaskPool.register(cache, refreshTime, false);
    }

    private static void register(ObjectUseTimesCache cache, LocalDateTime refreshTime, boolean buy) {
        if (refreshTime == null || refreshTime.getYear() == 2999) {
            return;
        }
        ResetTaskGroup group = ResetTaskPool.findOrCreateGroup(refreshTime, buy);
        group.add(cache);
        if (ConfigManager.configManager.getBoolean("debug-2")) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fReset Time: " + String.valueOf(group.triggerTime) + " Cache: " + String.valueOf(cache) + " Group Amount: " + GROUPS.size() + "!");
            for (ObjectUseTimesCache dc : group.caches) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fOther Caches: " + String.valueOf(dc) + "!");
            }
        }
    }

    public static void unregisterBuy(ObjectUseTimesCache cache) {
        ResetTaskPool.unregister(cache, true);
    }

    public static void unregisterSell(ObjectUseTimesCache cache) {
        ResetTaskPool.unregister(cache, false);
    }

    private static void unregister(ObjectUseTimesCache cache, boolean buy) {
        for (ResetTaskGroup group : GROUPS) {
            if (group.isBuy() != buy || !group.remove(cache)) continue;
            if (group.isEmpty()) {
                group.cancel();
                GROUPS.remove(group);
            }
            return;
        }
    }

    private static ResetTaskGroup findOrCreateGroup(LocalDateTime refreshTime, boolean buy) {
        for (ResetTaskGroup group : GROUPS) {
            if (group.isBuy() != buy || !group.isNear(refreshTime)) continue;
            group.updateTriggerTime(refreshTime);
            return group;
        }
        ResetTaskGroup group = new ResetTaskGroup(refreshTime, buy);
        GROUPS.add(group);
        return group;
    }

    private static final class ResetTaskGroup {
        private final boolean buy;
        private final Set<ObjectUseTimesCache> caches = ConcurrentHashMap.newKeySet();
        private volatile LocalDateTime triggerTime;
        private SchedulerUtil task;

        ResetTaskGroup(LocalDateTime time, boolean buy) {
            this.buy = buy;
            this.triggerTime = time;
            this.schedule();
        }

        boolean isBuy() {
            return this.buy;
        }

        boolean isNear(LocalDateTime time) {
            long diff;
            if (ConfigManager.configManager.getBoolean("debug-2")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fTrigger Time: " + String.valueOf(this.triggerTime) + " Object Time: " + String.valueOf(time) + "!");
            }
            return (diff = Math.abs(Duration.between(this.triggerTime, time).toSeconds())) <= 1L;
        }

        void updateTriggerTime(LocalDateTime time) {
            if (time.isAfter(this.triggerTime)) {
                this.triggerTime = time;
                this.reschedule();
            }
        }

        void add(ObjectUseTimesCache cache) {
            this.caches.add(cache);
        }

        boolean remove(ObjectUseTimesCache cache) {
            return this.caches.remove(cache);
        }

        boolean isEmpty() {
            return this.caches.isEmpty();
        }

        void cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private void schedule() {
            long delayMillis = Duration.between(CommonUtil.getNowTime(), this.triggerTime).toMillis();
            if (delayMillis <= 0L) {
                this.run();
                return;
            }
            long delayTicks = delayMillis / 50L;
            if (ConfigManager.configManager.getBoolean("debug-2")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fDelay: " + delayTicks + "!");
            }
            this.task = SchedulerUtil.runTaskLater(this::run, delayTicks + 10L);
        }

        private void reschedule() {
            this.cancel();
            this.schedule();
        }

        private void run() {
            for (ObjectUseTimesCache cache : this.caches) {
                if (this.buy) {
                    cache.refreshBuyTimes();
                } else {
                    cache.refreshSellTimes();
                }
                if (!ConfigManager.configManager.getBoolean("debug-2")) continue;
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fAuto reset actived for cache: " + String.valueOf(cache) + "!");
            }
            this.caches.clear();
            GROUPS.remove(this);
            if (ConfigManager.configManager.getBoolean("debug-2")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fGroup removed, left amount: " + GROUPS.size() + "!");
            }
        }
    }
}

