/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.caches;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.BungeeCordManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.objects.caches.ResetTaskPool;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.utils.CommandUtil;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.time.LocalDateTime;
import java.util.Objects;

public class ObjectUseTimesCache {
    private int buyUseTimes;
    private int totalBuyUseTimes;
    private int sellUseTimes;
    private int totalSellUseTimes;
    private LocalDateTime lastBuyTime = null;
    private LocalDateTime lastSellTime = null;
    private LocalDateTime lastResetBuyTime = null;
    private LocalDateTime lastResetSellTime = null;
    private LocalDateTime cooldownBuyTime = null;
    private LocalDateTime cooldownSellTime = null;
    private final ObjectItem product;
    private final ObjectCache cache;
    private final boolean firstInsert;

    public ObjectUseTimesCache(ObjectCache cache, int buyUseTimes, int totalBuyUseTimes, int sellUseTimes, int totalSellUseTimes, String lastBuyTime, String lastSellTime, String lastResetBuyTime, String lastResetSellTime, String cooldownBuyTime, String cooldownSellTime, ObjectItem product, boolean firstInsert) {
        this.firstInsert = firstInsert;
        this.cache = cache;
        this.buyUseTimes = buyUseTimes;
        this.totalBuyUseTimes = totalBuyUseTimes;
        if (lastBuyTime != null) {
            this.lastBuyTime = CommonUtil.stringToTime(lastBuyTime);
        }
        this.sellUseTimes = sellUseTimes;
        this.totalSellUseTimes = totalSellUseTimes;
        if (lastSellTime != null) {
            this.lastSellTime = CommonUtil.stringToTime(lastSellTime);
        }
        if (lastResetBuyTime != null) {
            this.lastResetBuyTime = CommonUtil.stringToTime(lastResetBuyTime);
        }
        if (lastResetSellTime != null) {
            this.lastResetSellTime = CommonUtil.stringToTime(lastResetSellTime);
        }
        if (cooldownBuyTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cSet cooldown time to " + String.valueOf(product));
            }
            this.cooldownBuyTime = CommonUtil.stringToTime(cooldownBuyTime);
        }
        if (cooldownSellTime != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cSet cooldown time to " + String.valueOf(product));
            }
            this.cooldownSellTime = CommonUtil.stringToTime(cooldownSellTime);
        }
        this.product = product;
        this.refreshTimes();
    }

    public void refreshTimes() {
        this.refreshBuyTimes();
        this.refreshSellTimes();
        this.initBuyResetTask();
        this.initSellResetTask();
    }

    public synchronized void initBuyResetTask() {
        if (!ConfigManager.configManager.getBoolean("use-times.auto-reset-mode")) {
            return;
        }
        ResetTaskPool.unregisterBuy(this);
        LocalDateTime refreshTime = this.getBuyRefreshTime();
        if (refreshTime == null || refreshTime.getYear() == 2999) {
            return;
        }
        ResetTaskPool.registerBuy(this, refreshTime);
    }

    public synchronized void initSellResetTask() {
        if (!ConfigManager.configManager.getBoolean("use-times.auto-reset-mode")) {
            return;
        }
        ResetTaskPool.unregisterSell(this);
        LocalDateTime refreshTime = this.getSellRefreshTime();
        if (refreshTime == null || refreshTime.getYear() == 2999) {
            return;
        }
        ResetTaskPool.registerSell(this, refreshTime);
    }

    public synchronized void cancelResetTime() {
        ResetTaskPool.unregisterBuy(this);
        ResetTaskPool.unregisterSell(this);
    }

    public int getBuyUseTimes() {
        return this.buyUseTimes;
    }

    public int getTotalBuyUseTimes() {
        return 0;
    }

    public int getSellUseTimes() {
        return this.sellUseTimes;
    }

    public int getTotalSellUseTimes() {
        return 0;
    }

    public void setBuyUseTimes(int i) {
        this.setBuyUseTimes(i, false, false);
    }

    public void setBuyUseTimes(int i, boolean isReset) {
        this.setBuyUseTimes(i, false, isReset);
    }

    public synchronized void setBuyUseTimes(int i, boolean notUseBungee, boolean isReset) {
        int maxTimes = this.product.getBuyTimesMaxValue(this.cache.getPlayer());
        if (i > 2147473647) {
            this.setSellUseTimes(0);
            this.setBuyUseTimes(i - this.sellUseTimes);
        }
        if (!isReset) {
            this.totalBuyUseTimes = this.totalBuyUseTimes > 2147473647 ? i : (this.totalBuyUseTimes += i - this.buyUseTimes);
        }
        this.buyUseTimes = i;
        if (!notUseBungee && this.cache.isServer() && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "buy-times", String.valueOf(i));
        }
    }

    public void setSellUseTimes(int i) {
        this.setSellUseTimes(i, false, false);
    }

    public void setSellUseTimes(int i, boolean isReset) {
        this.setSellUseTimes(i, false, isReset);
    }

    public synchronized void setSellUseTimes(int i, boolean notUseBungee, boolean isReset) {
        int maxTimes = this.product.getSellTimesMaxValue(this.cache.getPlayer());
        if (i > 2147473647) {
            this.setBuyUseTimes(0);
            this.setSellUseTimes(i - this.buyUseTimes);
        }
        if (!isReset) {
            this.totalSellUseTimes = this.totalSellUseTimes > 2147473647 ? i : (this.totalSellUseTimes += i - this.sellUseTimes);
        }
        this.sellUseTimes = i;
        if (!notUseBungee && this.cache.isServer() && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "sell-times", String.valueOf(i));
        }
    }

    public synchronized void setLastBuyTime(LocalDateTime time) {
        if (time == null) {
            this.lastResetBuyTime = Objects.requireNonNullElseGet(this.cooldownBuyTime, LocalDateTime::now);
        }
        this.setLastBuyTime(time, false);
    }

    public synchronized void setLastBuyTime(LocalDateTime time, boolean notUseBungee) {
        this.lastBuyTime = time;
        if (!notUseBungee && this.cache.isServer() && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-buy-time", CommonUtil.timeToString(time));
        }
    }

    public synchronized void setLastSellTime(LocalDateTime time) {
        if (time == null) {
            this.lastResetSellTime = Objects.requireNonNullElseGet(this.cooldownSellTime, LocalDateTime::now);
        }
        this.setLastSellTime(time, false);
    }

    public synchronized void setLastSellTime(LocalDateTime time, boolean notUseBungee) {
        this.lastSellTime = time;
        if (!notUseBungee && this.cache.isServer() && BungeeCordManager.bungeeCordManager != null) {
            BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "last-sell-time", CommonUtil.timeToString(time));
        }
    }

    public synchronized void setCooldownBuyTime() {
        this.setCooldownBuyTime(false);
    }

    public synchronized void resetCooldownBuyTime() {
        this.cooldownBuyTime = null;
    }

    public synchronized void setCooldownBuyTime(boolean notUseBungee) {
        if (this.cooldownBuyTime == null || this.cooldownBuyTime.isBefore(CommonUtil.getNowTime())) {
            String mode = this.product.getBuyTimesResetMode();
            String tempVal1 = TextUtil.withPAPI(this.product.getBuyTimesResetTime(), this.cache.getPlayer());
            if (mode == null || tempVal1.isEmpty()) {
                return;
            }
            switch (mode) {
                case "COOLDOWN_TIMED": {
                    this.cooldownBuyTime = this.createTimedBuyRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.isServer() || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                    break;
                }
                case "COOLDOWN_TIMER": {
                    this.cooldownBuyTime = this.createTimerBuyRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.isServer() || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-buy-time", null);
                    break;
                }
                case "COOLDOWN_CUSTOM": {
                    this.cooldownBuyTime = CommonUtil.stringToTime(tempVal1, TextUtil.withPAPI(this.product.getBuyTimesResetFormat(), this.cache.getPlayer()));
                }
            }
        }
    }

    public synchronized void setCooldownSellTime() {
        this.setCooldownSellTime(false);
    }

    public synchronized void resetCooldownSellTime() {
        this.cooldownSellTime = null;
    }

    public synchronized void setCooldownSellTime(boolean notUseBungee) {
        if (this.cooldownSellTime == null || this.cooldownSellTime.isBefore(CommonUtil.getNowTime())) {
            String mode = this.product.getSellTimesResetMode();
            String tempVal1 = TextUtil.withPAPI(this.product.getSellTimesResetTime(), this.cache.getPlayer());
            if (mode == null || tempVal1.isEmpty()) {
                return;
            }
            switch (mode) {
                case "COOLDOWN_TIMED": {
                    this.cooldownSellTime = this.createTimedSellRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.isServer() || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                    break;
                }
                case "COOLDOWN_TIMER": {
                    this.cooldownSellTime = this.createTimerSellRefreshTime(tempVal1);
                    if (notUseBungee || !this.cache.isServer() || BungeeCordManager.bungeeCordManager == null) break;
                    BungeeCordManager.bungeeCordManager.sendToOtherServer(this.product.getShop(), this.product.getProduct(), "cooldown-sell-time", null);
                    break;
                }
                case "COOLDOWN_CUSTOM": {
                    this.cooldownSellTime = CommonUtil.stringToTime(tempVal1, TextUtil.withPAPI(this.product.getSellTimesResetFormat(), this.cache.getPlayer()));
                }
            }
        }
    }

    public String getLastBuyTime() {
        if (this.lastBuyTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastBuyTime);
    }

    public String getLastSellTime() {
        if (this.lastSellTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastSellTime);
    }

    public String getLastResetBuyTime() {
        if (this.lastResetBuyTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastResetBuyTime);
    }

    public String getLastResetSellTime() {
        if (this.lastResetSellTime == null) {
            return null;
        }
        return CommonUtil.timeToString(this.lastResetSellTime);
    }

    public String getCooldownBuyTime() {
        if (this.cooldownBuyTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCooldown time: " + String.valueOf(this.cooldownBuyTime));
        }
        return CommonUtil.timeToString(this.cooldownBuyTime);
    }

    public String getCooldownSellTime() {
        if (this.cooldownSellTime == null) {
            return null;
        }
        if (ConfigManager.configManager.getBoolean("debug")) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCooldown time: " + String.valueOf(this.cooldownSellTime));
        }
        return CommonUtil.timeToString(this.cooldownSellTime);
    }

    public LocalDateTime getBuyRefreshTimeWithUpdate() {
        String mode = this.product.getBuyTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getBuyTimesResetTime(), this.cache.getPlayer());
        return this.createRefreshTime(mode, tempVal1, true);
    }

    public LocalDateTime getSellRefreshTimeWithUpdate() {
        String mode = this.product.getSellTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getSellTimesResetTime(), this.cache.getPlayer());
        return this.createRefreshTime(mode, tempVal1, false);
    }

    public LocalDateTime getBuyRefreshTime() {
        LocalDateTime result;
        String mode = this.product.getBuyTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getBuyTimesResetTime(), this.cache.getPlayer());
        switch (mode) {
            case "COOLDOWN_TIMED": 
            case "COOLDOWN_TIMER": {
                result = this.cooldownBuyTime;
                this.createRefreshTime(mode, tempVal1, true);
                break;
            }
            default: {
                result = this.createRefreshTime(mode, tempVal1, true);
            }
        }
        return result;
    }

    public LocalDateTime getSellRefreshTime() {
        LocalDateTime result;
        String mode = this.product.getSellTimesResetMode();
        String tempVal1 = TextUtil.withPAPI(this.product.getSellTimesResetTime(), this.cache.getPlayer());
        switch (mode) {
            case "COOLDOWN_TIMED": 
            case "COOLDOWN_TIMER": {
                result = this.cooldownSellTime;
                this.createRefreshTime(mode, tempVal1, false);
                break;
            }
            default: {
                result = this.createRefreshTime(mode, tempVal1, false);
            }
        }
        return result;
    }

    public String getBuyRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getBuyRefreshTimeWithUpdate();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public String getBuyRefreshTimeNextName() {
        return "";
    }

    public String getBuyLastTimeName() {
        return "0";
    }

    public String getBuyLastResetTimeName() {
        return "0";
    }

    public String getSellRefreshTimeDisplayName() {
        LocalDateTime tempVal1 = this.getSellRefreshTimeWithUpdate();
        if (tempVal1 == null || tempVal1.getYear() == 2999) {
            return ConfigManager.configManager.getString("placeholder.refresh.never", new String[0]);
        }
        return CommonUtil.timeToString(tempVal1, ConfigManager.configManager.getString("placeholder.refresh.format", new String[0]));
    }

    public String getSellRefreshTimeNextName() {
        return "0";
    }

    public String getSellLastTimeName() {
        return "0";
    }

    public String getSellLastResetTimeName() {
        return "0";
    }

    private synchronized LocalDateTime createTimedBuyRefreshTime(String time) {
        LocalDateTime refreshResult;
        block6: {
            refreshResult = null;
            int n = 0;
            String[] tempVal3 = time.split(";;");
            String[] stringArray = tempVal3;
            int n2 = stringArray.length;
            if (n >= n2) break block6;
            String tempVal4 = stringArray[n];
            String[] tempVal2 = tempVal4.split(":");
            int month = 0;
            int day = 0;
            if (tempVal2.length < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + tempVal4 + " is invalid.");
                return CommonUtil.getNowTime();
            }
            if (tempVal2.length == 5) {
                month = Integer.parseInt(tempVal2[0]);
            }
            if (tempVal2.length >= 4) {
                day = Integer.parseInt(tempVal2[tempVal2.length - 4]);
            }
            LocalDateTime checkTime = this.lastBuyTime;
            if (this.lastBuyTime == null) {
                checkTime = CommonUtil.getNowTime();
            }
            LocalDateTime thisResult = checkTime.withHour(Integer.parseInt(tempVal2[tempVal2.length - 3])).withMinute(Integer.parseInt(tempVal2[tempVal2.length - 2])).withSecond(Integer.parseInt(tempVal2[tempVal2.length - 1]));
            if (!checkTime.isBefore(thisResult = thisResult.plusDays(day).plusMonths(month))) {
                thisResult = thisResult.plusDays(1L);
            }
            if (refreshResult == null || thisResult.isBefore(refreshResult)) {
                refreshResult = thisResult;
            }
        }
        return refreshResult;
    }

    private synchronized LocalDateTime createTimedSellRefreshTime(String time) {
        LocalDateTime refreshResult;
        block6: {
            refreshResult = null;
            int n = 0;
            String[] tempVal3 = time.split(";;");
            String[] stringArray = tempVal3;
            int n2 = stringArray.length;
            if (n >= n2) break block6;
            String tempVal4 = stringArray[n];
            String[] tempVal2 = tempVal4.split(":");
            int month = 0;
            int day = 0;
            if (tempVal2.length < 3) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + tempVal4 + " is invalid.");
                return CommonUtil.getNowTime();
            }
            if (tempVal2.length == 5) {
                month = Integer.parseInt(tempVal2[0]);
            }
            if (tempVal2.length >= 4) {
                day = Integer.parseInt(tempVal2[1]);
            }
            LocalDateTime checkTime = this.lastSellTime;
            if (this.lastSellTime == null) {
                checkTime = CommonUtil.getNowTime();
            }
            LocalDateTime thisResult = checkTime.withHour(Integer.parseInt(tempVal2[tempVal2.length - 3])).withMinute(Integer.parseInt(tempVal2[tempVal2.length - 2])).withSecond(Integer.parseInt(tempVal2[tempVal2.length - 1]));
            if (!checkTime.isBefore(thisResult = thisResult.plusDays(day).plusMonths(month))) {
                thisResult = thisResult.plusDays(1L);
            }
            if (refreshResult == null || thisResult.isBefore(refreshResult)) {
                refreshResult = thisResult;
            }
        }
        return refreshResult;
    }

    private synchronized LocalDateTime createTimerBuyRefreshTime(String time) {
        String[] tempVal2;
        LocalDateTime refreshResult = this.lastBuyTime;
        if (refreshResult == null) {
            refreshResult = CommonUtil.getNowTime();
        }
        if ((tempVal2 = time.split(":")).length < 3) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + time + " is invalid.");
            return CommonUtil.getNowTime();
        }
        int month = 0;
        int day = 0;
        if ((refreshResult = refreshResult.plusMonths(month).plusDays(day).plusHours(Integer.parseInt(tempVal2[tempVal2.length - 3])).plusMinutes(Integer.parseInt(tempVal2[tempVal2.length - 2])).plusSeconds(Integer.parseInt(tempVal2[tempVal2.length - 1]))).isBefore(CommonUtil.getNowTime())) {
            return CommonUtil.getNowTime();
        }
        return refreshResult;
    }

    private synchronized LocalDateTime createTimerSellRefreshTime(String time) {
        String[] tempVal2;
        LocalDateTime refreshResult = this.lastSellTime;
        if (refreshResult == null) {
            refreshResult = CommonUtil.getNowTime();
        }
        if ((tempVal2 = time.split(":")).length < 3) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your reset time " + time + " is invalid.");
            return CommonUtil.getNowTime();
        }
        int month = 0;
        int day = 0;
        if ((refreshResult = refreshResult.plusMonths(month).plusDays(day).plusHours(Integer.parseInt(tempVal2[tempVal2.length - 3])).plusMinutes(Integer.parseInt(tempVal2[tempVal2.length - 2])).plusSeconds(Integer.parseInt(tempVal2[tempVal2.length - 1]))).isBefore(CommonUtil.getNowTime())) {
            return CommonUtil.getNowTime();
        }
        return refreshResult;
    }

    private LocalDateTime createRefreshTime(String mode, String time, boolean buyOrSell) {
        switch (mode) {
            case "COOLDOWN_TIMED": 
            case "COOLDOWN_TIMER": 
            case "COOLDOWN_CUSTOM": {
                return CommonUtil.getNowTime();
            }
            case "TIMED": {
                if (buyOrSell) {
                    return this.createTimedBuyRefreshTime(time);
                }
                return this.createTimedSellRefreshTime(time);
            }
            case "TIMER": {
                if (buyOrSell) {
                    return this.createTimerBuyRefreshTime(time);
                }
                return this.createTimerSellRefreshTime(time);
            }
            case "CUSTOM": {
                return CommonUtil.stringToTime(time);
            }
            case "RANDOM_PLACEHOLDER": {
                return ObjectRandomPlaceholder.getRefreshDoneTimeObject(this.cache.getPlayer(), time);
            }
        }
        return CommonUtil.getNowTime().withYear(2999);
    }

    public synchronized void refreshBuyTimes() {
        LocalDateTime tempVal1 = this.getBuyRefreshTime();
        if (tempVal1 != null && tempVal1.isBefore(CommonUtil.getNowTime())) {
            this.setBuyUseTimes(this.product.getBuyTimesResetValue(this.cache.getPlayer()), true);
            this.setLastBuyTime(null);
            this.resetCooldownBuyTime();
            this.initBuyResetTask();
            CommandUtil.updateGUI(this.cache.getPlayer());
        }
    }

    public synchronized void refreshSellTimes() {
        LocalDateTime tempVal1 = this.getSellRefreshTime();
        if (tempVal1 != null && tempVal1.isBefore(CommonUtil.getNowTime())) {
            this.setSellUseTimes(this.product.getSellTimesResetValue(this.cache.getPlayer()), true);
            this.setLastSellTime(null);
            this.resetCooldownSellTime();
            this.initSellResetTask();
            CommandUtil.updateGUI(this.cache.getPlayer());
        }
    }

    public LocalDateTime getLastBuyTimeObject() {
        return this.lastBuyTime;
    }

    public LocalDateTime getLastSellTimeObject() {
        return this.lastSellTime;
    }

    public boolean isEmpty() {
        return this.buyUseTimes == 0 && this.totalBuyUseTimes == 0 && this.sellUseTimes == 0 && this.totalSellUseTimes == 0;
    }

    public boolean isFirstInsert() {
        return this.firstInsert;
    }

    public String toString() {
        if (this.cache.isServer()) {
            return "Server Cache";
        }
        return "Player Cache: " + this.cache.getPlayer().getName();
    }
}

