/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.buttons;

import cn.superiormc.ultimateshop.methods.Items.BuildItem;
import cn.superiormc.ultimateshop.methods.ModifyDisplayItem;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ButtonType;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.utils.MathUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ObjectMoreBuyButton
extends AbstractButton {
    private final ObjectItem item;

    public ObjectMoreBuyButton(ConfigurationSection config, ObjectItem item) {
        super(config);
        this.item = item;
        this.type = ButtonType.CONFIRM;
    }

    @Override
    public ObjectDisplayItemStack getDisplayItem(Player player, int multi) {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection("display-item");
        if (tempVal1 == null) {
            return ObjectDisplayItemStack.getAir();
        }
        String amount = tempVal1.getString("amount", "1");
        ObjectDisplayItemStack addLoreDisplayItem = new ObjectDisplayItemStack(BuildItem.buildItemStack(player, tempVal1, MathUtil.doCalculate(TextUtil.withPAPI(amount, player)).intValue(), new String[0]));
        if (this.config != null && !this.config.getBoolean("modify-lore", true)) {
            return addLoreDisplayItem;
        }
        return ModifyDisplayItem.modifyItem(player, multi, addLoreDisplayItem, this.item, true, this.getClickType());
    }

    public String getClickType() {
        return this.config.getString("click-action", null);
    }

    public boolean isInvalid() {
        if (this.getClickType() == null) {
            return false;
        }
        return switch (this.getClickType()) {
            case "buy" -> this.item.getBuyPrice().empty;
            case "sell" -> this.item.getSellPrice().empty;
            case "buy-or-sell" -> {
                if (this.item.getBuyPrice().empty && this.item.getSellPrice().empty) {
                    yield true;
                }
                yield false;
            }
            case "sell-all" -> {
                if (this.item.getSellPrice().empty || !this.item.isEnableSellAll()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

