/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects.actions;

import cn.superiormc.ultimateshop.managers.ActionManager;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.AbstractSingleRun;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.ObjectAction;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import org.bukkit.configuration.ConfigurationSection;

public class ObjectSingleAction
extends AbstractSingleRun {
    private final ObjectAction action;

    public ObjectSingleAction(ObjectAction action, ConfigurationSection actionSection) {
        super(actionSection);
        this.action = action;
    }

    public ObjectSingleAction(ObjectAction action, ConfigurationSection actionSection, ObjectItem item) {
        super(actionSection, item);
        this.action = action;
    }

    public ObjectSingleAction(ObjectAction action, ConfigurationSection actionSection, ObjectShop shop) {
        super(actionSection, shop);
        this.action = action;
    }

    public void doAction(ObjectThingRun thingRun) {
        if (this.startApply >= 0 && thingRun.getTimes() < this.startApply) {
            return;
        }
        if (this.endApply >= 0 && thingRun.getTimes() > this.startApply) {
            return;
        }
        if (!this.apply.isEmpty() && !this.apply.contains(thingRun.getTimes())) {
            return;
        }
        if (this.sellAllOnce && thingRun.getSellAll()) {
            return;
        }
        if (this.clickType != null && !this.clickType.equals(thingRun.getType().name())) {
            return;
        }
        if (this.openOnce && thingRun.isReopen()) {
            return;
        }
        if (thingRun.getPlayer() != null && this.bedrockOnly && !CommonUtil.isBedrockPlayer(thingRun.getPlayer())) {
            return;
        }
        if (thingRun.getPlayer() != null && this.javaOnly && CommonUtil.isBedrockPlayer(thingRun.getPlayer())) {
            return;
        }
        ActionManager.actionManager.doAction(this, thingRun);
    }

    public boolean isMultiOnce() {
        return this.multiOnce;
    }

    public boolean isSellAllOnce() {
        return this.sellAllOnce;
    }

    public void setLastTradeStatus(ProductTradeStatus status) {
        this.action.setLastTradeStatus(status);
    }

    public ObjectAction getAction() {
        return this.action;
    }
}

