/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.objects;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class ObjectThingRun {
    private final Player player;
    private final int times;
    private final double amount;
    private final int multi;
    private final boolean sellAll;
    private final ClickType type;
    private final boolean reopen;

    public ObjectThingRun(Player player) {
        this.player = player;
        this.times = 1;
        this.amount = 1.0;
        this.multi = 1;
        this.sellAll = false;
        this.type = null;
        this.reopen = false;
    }

    public ObjectThingRun(Player player, boolean reopen) {
        this.player = player;
        this.times = 1;
        this.amount = 1.0;
        this.multi = 1;
        this.sellAll = false;
        this.type = null;
        this.reopen = reopen;
    }

    public ObjectThingRun(Player player, ClickType type) {
        this.player = player;
        this.times = 1;
        this.amount = 1.0;
        this.multi = 1;
        this.sellAll = false;
        this.type = type;
        this.reopen = false;
    }

    public ObjectThingRun(Player player, int times, int multi, double amount) {
        this.player = player;
        this.times = times;
        this.amount = amount;
        this.multi = multi;
        this.sellAll = false;
        this.type = null;
        this.reopen = false;
    }

    public ObjectThingRun(Player player, int times, int multi, double amount, boolean sellAll) {
        this.player = player;
        this.times = times;
        this.amount = amount;
        this.multi = multi;
        this.sellAll = sellAll;
        this.type = null;
        this.reopen = false;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getTimes() {
        return Math.max(this.times, 0);
    }

    public boolean getSellAll() {
        return this.sellAll;
    }

    public ClickType getType() {
        return this.type;
    }

    public double getAmount() {
        if (this.amount < 0.0) {
            return 0.0;
        }
        return this.amount;
    }

    public int getMulti() {
        if (this.multi < 1) {
            return 1;
        }
        return this.multi;
    }

    public boolean isReopen() {
        return this.reopen;
    }
}

