/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods.Product;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.api.ItemFinishTransactionEvent;
import cn.superiormc.ultimateshop.api.ItemPreTransactionEvent;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.GiveResult;
import cn.superiormc.ultimateshop.objects.items.TakeResult;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;

public class BuyProductMethod {
    public static ProductTradeStatus startBuy(ObjectItem item, Player player, boolean forceDisplayMessage) {
        return BuyProductMethod.startBuy(item, player, forceDisplayMessage, false, 1);
    }

    public static ProductTradeStatus startBuy(ObjectItem item, Player player, boolean forceDisplayMessage, boolean notCost, int multi) {
        return BuyProductMethod.startBuy((Inventory)player.getInventory(), item, player, forceDisplayMessage, notCost, multi);
    }

    public static ProductTradeStatus startBuy(Inventory inventory, ObjectItem item, Player player, boolean forceDisplayMessage, boolean notCost, int multi) {
        int newValue;
        boolean shouldSendMessage;
        if (item == null) {
            return ProductTradeStatus.ERROR;
        }
        if (item.getShopObject().getProductNotHidden(player, item) == null) {
            return ProductTradeStatus.ERROR;
        }
        boolean bl = shouldSendMessage = inventory instanceof PlayerInventory && !notCost && (forceDisplayMessage || !item.getShopObject().getShopConfig().getBoolean("settings.hide-message", false));
        if (!item.getBuyCondition(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "buy-condition-not-meet", "product", item.getProduct());
            }
            return ProductTradeStatus.PERMISSION;
        }
        if (item.getBuyPrice().empty) {
            return ProductTradeStatus.ERROR;
        }
        ObjectCache tempVal3 = CacheManager.cacheManager.getObjectCache(player);
        ObjectCache tempVal11 = CacheManager.cacheManager.serverCache;
        if (tempVal3 == null) {
            LanguageManager.languageManager.sendStringText(player, "error.player-not-found", "player", player.getName());
            return ProductTradeStatus.ERROR;
        }
        int playerUseTimes = 0;
        int serverUseTimes = 0;
        ObjectUseTimesCache tempVal9 = tempVal3.getUseTimesCache().get(item);
        ObjectUseTimesCache tempVal8 = tempVal11.getUseTimesCache().get(item);
        if (tempVal9 != null) {
            tempVal9.refreshTimes();
            playerUseTimes = tempVal9.getBuyUseTimes();
        } else {
            tempVal9 = tempVal3.createUseTimesCache(item);
        }
        if (item.getPlayerBuyLimit(player) != -1 && playerUseTimes + multi > item.getPlayerBuyLimit(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "limit-reached-buy-player", "item", item.getDisplayName(player), "times", String.valueOf(playerUseTimes), "limit", String.valueOf(item.getPlayerBuyLimit(player)), "refresh", tempVal9.getBuyRefreshTimeDisplayName(), "next", tempVal9.getBuyRefreshTimeNextName());
            }
            return ProductTradeStatus.PLAYER_MAX;
        }
        ObjectPrices tempVal5 = item.getBuyPrice();
        if (tempVal8 != null) {
            tempVal8.refreshTimes();
            serverUseTimes = tempVal8.getBuyUseTimes();
        } else {
            tempVal8 = tempVal11.createUseTimesCache(item);
        }
        if (item.getServerBuyLimit(player) != -1 && serverUseTimes + multi > item.getServerBuyLimit(player)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "limit-reached-buy-server", "item", item.getDisplayName(player), "times", String.valueOf(serverUseTimes), "limit", String.valueOf(item.getServerBuyLimit(player)), "refresh", tempVal8.getBuyRefreshTimeDisplayName(), "next", tempVal8.getBuyRefreshTimeNextName());
            }
            return ProductTradeStatus.SERVER_MAX;
        }
        GiveResult giveResult = null;
        TakeResult takeResult = tempVal5.take(inventory, player, playerUseTimes, multi, false);
        if (!notCost) {
            giveResult = item.getReward().give(player, playerUseTimes, multi);
            ItemPreTransactionEvent event = new ItemPreTransactionEvent(true, player, multi, item, giveResult, takeResult);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
        if (!takeResult.getResultBoolean()) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "buy-price-not-enough", "item", item.getDisplayName(player), "price", ObjectPrices.getDisplayNameInLine(player, multi, takeResult.getResultMap(), tempVal5.getMode(), !ConfigManager.configManager.getBoolean("placeholder.status.can-used-everywhere")));
            }
            return ProductTradeStatus.NOT_ENOUGH;
        }
        if (notCost) {
            return new ProductTradeStatus(ProductTradeStatus.Status.DONE, takeResult);
        }
        if (!giveResult.give(playerUseTimes, multi, player, 1.0)) {
            if (shouldSendMessage) {
                LanguageManager.languageManager.sendStringText(player, "inventory-full");
            }
            return ProductTradeStatus.INVENTORY_FULL;
        }
        takeResult.take(playerUseTimes, multi, inventory, player);
        int calculateAmount = multi * item.getDisplayItemObject().getAmountPlaceholder(player);
        item.getBuyAction().runAllActions(new ObjectThingRun(player, playerUseTimes, multi, calculateAmount));
        if (tempVal9 != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                newValue = tempVal9.getBuyUseTimes() + multi;
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7aSet player limit value to " + newValue + "!");
            }
            tempVal9.setBuyUseTimes(tempVal9.getBuyUseTimes() + multi);
            tempVal9.setLastBuyTime(CommonUtil.getNowTime());
            tempVal9.setCooldownBuyTime();
        }
        if (tempVal8 != null) {
            if (ConfigManager.configManager.getBoolean("debug")) {
                newValue = tempVal8.getBuyUseTimes() + multi;
                UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7aSet server limit value to " + newValue + "!");
            }
            tempVal8.setBuyUseTimes(tempVal8.getBuyUseTimes() + multi);
            tempVal8.setLastBuyTime(CommonUtil.getNowTime());
            tempVal8.setCooldownBuyTime();
        }
        if (!(item.getShopObject().getShopConfig().getBoolean("settings.hide-message", false) || giveResult.empty || takeResult.empty)) {
            LanguageManager.languageManager.sendStringText(player, "success-buy", "item", item.getDisplayName(player), "price", ObjectPrices.getDisplayNameInLine(player, multi, takeResult.getResultMap(), tempVal5.getMode(), !ConfigManager.configManager.getBoolean("placeholder.status.can-used-everywhere")), "amount", String.valueOf(calculateAmount));
        }
        if (ConfigManager.configManager.getBoolean("log-transaction.enabled")) {
            // empty if block
        }
        ItemFinishTransactionEvent event = new ItemFinishTransactionEvent(true, player, multi, item);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return new ProductTradeStatus(ProductTradeStatus.Status.DONE, takeResult, giveResult, multi);
    }

    private static /* synthetic */ void lambda$startBuy$0(String filePath, String log) {
        CommonUtil.logFile(filePath, log);
    }
}

