/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.methods.Product.BuyProductMethod;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.meta.ItemMeta;

public class ModifyDisplayItem {
    public static ObjectDisplayItemStack modifyItem(Player player, int multi, ObjectDisplayItemStack addLoreDisplayItem, ObjectItem item, boolean buyMore) {
        return ModifyDisplayItem.modifyItem(player, multi, addLoreDisplayItem, item, buyMore, "general");
    }

    public static ObjectDisplayItemStack modifyItem(Player player, int multi, ObjectDisplayItemStack addLoreDisplayItem, ObjectItem item, boolean buyMore, String clickType) {
        ItemMeta tempVal2;
        if (clickType == null) {
            clickType = "general";
        }
        if ((tempVal2 = addLoreDisplayItem.getMeta()) == null) {
            return addLoreDisplayItem;
        }
        if (item.getItemConfig().getString("display-name") != null) {
            UltimateShop.methodUtil.setItemName(tempVal2, item.getDisplayName(player), player);
        }
        if (tempVal2.hasDisplayName()) {
            UltimateShop.methodUtil.setItemName(tempVal2, CommonUtil.modifyString(UltimateShop.methodUtil.getItemName(tempVal2), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player)), player);
        }
        ArrayList<String> addLore = new ArrayList<String>();
        if (tempVal2.hasLore()) {
            addLore.addAll(CommonUtil.modifyList(player, UltimateShop.methodUtil.getItemLore(tempVal2), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player)));
        }
        addLore.addAll(ModifyDisplayItem.getModifiedLore(player, multi, item, buyMore, false, clickType));
        if (!addLore.isEmpty()) {
            UltimateShop.methodUtil.setItemLore(tempVal2, addLore, player);
        }
        addLoreDisplayItem.setItemMeta(tempVal2);
        return addLoreDisplayItem;
    }

    public static List<String> getModifiedLore(Player player, int multi, ObjectItem item, boolean buyMore, boolean bedrock, String clickType) {
        List<String> resultLore = new ArrayList<String>();
        ObjectUseTimesCache ObjectCache2 = CacheManager.cacheManager.getObjectCache(player).getUseTimesCache().get(item);
        ObjectUseTimesCache serverCache = CacheManager.cacheManager.serverCache.getUseTimesCache().get(item);
        if (ObjectCache2 == null) {
            ObjectCache2 = CacheManager.cacheManager.getObjectCache(player).createUseTimesCache(item);
        }
        if (serverCache == null) {
            serverCache = CacheManager.cacheManager.serverCache.createUseTimesCache(item);
        }
        Map<Character, Boolean> prefixConditions = ModifyDisplayItem.buildPrefixMap(player, item, clickType, buyMore, bedrock, ObjectCache2, serverCache);
        for (String rawLine : item.getAddLore()) {
            ParsedLine parsed;
            if (rawLine.endsWith("-i") || rawLine.endsWith("-m") || rawLine.endsWith("-b")) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cYour display item add lore config is not updated, please reconfigure your display item add lore configs at config.yml file! You can get latest config at plugin Wiki: https://ultimateshop.superiormc.cn/info/configuration-files .");
            }
            if (!(parsed = ParsedLine.parse(rawLine)).isConditional()) {
                resultLore.add(parsed.getPureText());
                continue;
            }
            boolean condition = parsed.conditions.stream().allMatch(c -> {
                Boolean val = (Boolean)prefixConditions.get(Character.valueOf(c.key));
                if (val == null) {
                    val = false;
                }
                return c.negate ? !val.booleanValue() : val;
            });
            if (!condition) continue;
            resultLore.add(parsed.getPureText());
        }
        if (!resultLore.isEmpty()) {
            resultLore = CommonUtil.modifyList(player, resultLore, "buy-price", ObjectPrices.getDisplayNameInLine(player, multi, item.getBuyPrice().take((Inventory)player.getInventory(), player, ObjectCache2.getBuyUseTimes(), multi, true).getResultMap(), item.getBuyPrice().getMode(), false), "sell-price", ObjectPrices.getDisplayNameInLine(player, multi, item.getSellPrice().give(player, ObjectCache2.getBuyUseTimes(), multi).getResultMap(), item.getSellPrice().getMode(), false), "buy-limit-player", String.valueOf(item.getPlayerBuyLimit(player)), "sell-limit-player", String.valueOf(item.getPlayerSellLimit(player)), "buy-limit-server", String.valueOf(item.getServerBuyLimit(player)), "sell-limit-server", String.valueOf(item.getServerSellLimit(player)), "buy-total-player", String.valueOf(ObjectCache2.getTotalBuyUseTimes()), "sell-total-player", String.valueOf(ObjectCache2.getTotalSellUseTimes()), "buy-total-server", String.valueOf(serverCache.getTotalBuyUseTimes()), "sell-total-server", String.valueOf(serverCache.getTotalSellUseTimes()), "buy-times-player", String.valueOf(ObjectCache2.getBuyUseTimes()), "sell-times-player", String.valueOf(ObjectCache2.getSellUseTimes()), "buy-refresh-player", ObjectCache2.getBuyRefreshTimeDisplayName(), "sell-refresh-player", ObjectCache2.getSellRefreshTimeDisplayName(), "buy-next-player", ObjectCache2.getBuyRefreshTimeNextName(), "sell-next-player", ObjectCache2.getSellRefreshTimeNextName(), "buy-times-server", String.valueOf(serverCache.getBuyUseTimes()), "sell-times-server", String.valueOf(serverCache.getSellUseTimes()), "buy-refresh-server", serverCache.getBuyRefreshTimeDisplayName(), "sell-refresh-server", serverCache.getSellRefreshTimeDisplayName(), "buy-next-server", serverCache.getBuyRefreshTimeNextName(), "sell-next-server", serverCache.getSellRefreshTimeNextName(), "last-buy-player", ObjectCache2.getBuyLastTimeName(), "last-sell-player", ObjectCache2.getSellLastTimeName(), "last-buy-server", serverCache.getBuyLastTimeName(), "last-sell-server", serverCache.getSellLastTimeName(), "last-reset-buy-player", ObjectCache2.getBuyLastResetTimeName(), "last-reset-sell-player", ObjectCache2.getSellLastResetTimeName(), "last-reset-buy-server", serverCache.getBuyLastResetTimeName(), "last-reset-sell-server", serverCache.getSellLastResetTimeName(), "buy-click", ModifyDisplayItem.getBuyClickPlaceholder(player, multi, item, clickType), "sell-click", ModifyDisplayItem.getSellClickPlaceholder(player, multi, item, clickType), "amount", String.valueOf(multi), "item-name", item.getDisplayName(player));
        }
        return resultLore;
    }

    private static Map<Character, Boolean> buildPrefixMap(Player player, ObjectItem item, String clickType, boolean buyMore, boolean bedrock, ObjectUseTimesCache p, ObjectUseTimesCache s) {
        HashMap<Character, Boolean> map = new HashMap<Character, Boolean>();
        map.put(Character.valueOf('a'), !item.getBuyPrice().empty);
        map.put(Character.valueOf('b'), !item.getSellPrice().empty);
        map.put(Character.valueOf('c'), item.getPlayerBuyLimit(player) != -1);
        map.put(Character.valueOf('d'), item.getServerBuyLimit(player) != -1);
        map.put(Character.valueOf('e'), item.getPlayerSellLimit(player) != -1);
        map.put(Character.valueOf('f'), item.getServerSellLimit(player) != -1);
        map.put(Character.valueOf('g'), item.getPlayerBuyLimit(player) > 0 && p.getBuyUseTimes() >= item.getPlayerBuyLimit(player));
        map.put(Character.valueOf('h'), item.getPlayerSellLimit(player) > 0 && p.getSellUseTimes() >= item.getPlayerSellLimit(player));
        map.put(Character.valueOf('i'), item.getServerBuyLimit(player) > 0 && s.getBuyUseTimes() >= item.getServerBuyLimit(player));
        map.put(Character.valueOf('j'), item.getServerSellLimit(player) > 0 && s.getSellUseTimes() >= item.getServerSellLimit(player));
        map.put(Character.valueOf('k'), item.getBuyMore());
        map.put(Character.valueOf('m'), !item.getSellPrice().empty && item.isEnableSellAll());
        map.put(Character.valueOf('n'), !item.getBuyPrice().empty && ModifyDisplayItem.parseClickType(item, clickType, true) || !item.getSellPrice().empty && ModifyDisplayItem.parseClickType(item, clickType, false));
        map.put(Character.valueOf('p'), buyMore);
        map.put(Character.valueOf('q'), !buyMore);
        map.put(Character.valueOf('x'), bedrock);
        map.put(Character.valueOf('y'), !bedrock);
        map.put(Character.valueOf('u'), ModifyDisplayItem.parseClickType(item, clickType, true));
        map.put(Character.valueOf('v'), ModifyDisplayItem.parseClickType(item, clickType, false));
        return map;
    }

    private static String getBuyClickPlaceholder(Player player, int multi, ObjectItem item, String clickType) {
        if (!ConfigManager.configManager.getBoolean("placeholder.click.enabled")) {
            if (item.getSellPrice().empty || clickType.equals("buy")) {
                return ConfigManager.configManager.getString("placeholder.click.buy-with-no-sell", "", "amount", String.valueOf(multi));
            }
            return ConfigManager.configManager.getString("placeholder.click.buy", "", "amount", String.valueOf(multi));
        }
        String s = "";
        switch (BuyProductMethod.startBuy(item, player, false, true, multi).getStatus()) {
            case ERROR: {
                s = ConfigManager.configManager.getString("placeholder.click.error", "", "amount", String.valueOf(multi));
                break;
            }
            case PERMISSION: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-condition-not-meet", "", "amount", String.valueOf(multi));
                break;
            }
            case PLAYER_MAX: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-max-limit-player", "", "amount", String.valueOf(multi));
                break;
            }
            case SERVER_MAX: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-max-limit-server", "", "amount", String.valueOf(multi));
                break;
            }
            case NOT_ENOUGH: {
                s = ConfigManager.configManager.getString("placeholder.click.buy-price-not-enough", "", "amount", String.valueOf(multi));
                break;
            }
            case DONE: {
                s = item.getSellPrice().empty || clickType.equals("buy") ? ConfigManager.configManager.getString("placeholder.click.buy-with-no-sell", "", "amount", String.valueOf(multi)) : ConfigManager.configManager.getString("placeholder.click.buy", "", "amount", String.valueOf(multi));
            }
        }
        return s;
    }

    private static String getSellClickPlaceholder(Player player, int multi, ObjectItem item, String clickType) {
        if (!ConfigManager.configManager.getBoolean("placeholder.click.enabled")) {
            if (item.getBuyPrice().empty || clickType.equals("sell")) {
                return ConfigManager.configManager.getString("placeholder.click.sell-with-no-buy", "", "amount", String.valueOf(multi));
            }
            return ConfigManager.configManager.getString("placeholder.click.sell", "", "amount", String.valueOf(multi));
        }
        return switch (SellProductMethod.startSell(item, player, false, true, multi).getStatus()) {
            case ProductTradeStatus.Status.ERROR -> ConfigManager.configManager.getString("placeholder.click.error", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.PERMISSION -> ConfigManager.configManager.getString("placeholder.click.sell-condition-not-meet", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.PLAYER_MAX -> ConfigManager.configManager.getString("placeholder.click.sell-max-limit-player", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.SERVER_MAX -> ConfigManager.configManager.getString("placeholder.click.sell-max-limit-server", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.NOT_ENOUGH -> ConfigManager.configManager.getString("placeholder.click.sell-price-not-enough", "", "amount", String.valueOf(multi));
            case ProductTradeStatus.Status.DONE -> {
                if (item.getBuyPrice().empty || clickType.equals("sell")) {
                    yield ConfigManager.configManager.getString("placeholder.click.sell-with-no-buy", "", "amount", String.valueOf(multi));
                }
                yield ConfigManager.configManager.getString("placeholder.click.sell", "", "amount", String.valueOf(multi));
            }
            default -> "Unknown";
        };
    }

    private static boolean parseClickType(ObjectItem item, String clickType, boolean buyOrSell) {
        if (clickType == null || clickType.equals("general")) {
            return true;
        }
        switch (clickType) {
            case "buy": {
                return buyOrSell;
            }
            case "sell": {
                return !buyOrSell;
            }
            case "sell-all": {
                return !buyOrSell && item.isEnableSellAll();
            }
            case "buy-or-sell": {
                if (item.getBuyPrice().empty && !item.getSellPrice().empty) {
                    return !buyOrSell;
                }
                return buyOrSell;
            }
        }
        return false;
    }

    private static class ParsedLine {
        final List<ConditionElement> conditions;
        final boolean conditional;
        final String text;

        ParsedLine(List<ConditionElement> conditions, String text) {
            this.conditions = conditions;
            this.conditional = !conditions.isEmpty();
            this.text = text;
        }

        boolean isConditional() {
            return this.conditional;
        }

        String getPureText() {
            return this.text;
        }

        static ParsedLine parse(String line) {
            if (line == null) {
                line = "";
            }
            ArrayList<ConditionElement> list = new ArrayList<ConditionElement>();
            StringBuilder out = new StringBuilder();
            int idx = 0;
            int len = line.length();
            while (idx < len) {
                char key;
                int end;
                char ch = line.charAt(idx);
                if (ch == '(' && idx + 2 < len && line.charAt(idx + 1) == '@' && (end = line.indexOf(41, idx)) != -1) {
                    String inside = line.substring(idx + 2, end);
                    ParsedLine.extractConditions(inside, list, true);
                    idx = end + 1;
                    continue;
                }
                if (ch == '@' && idx + 1 < len && Character.isLetter(key = line.charAt(idx + 1))) {
                    list.add(new ConditionElement(key, false));
                    idx += 2;
                    continue;
                }
                out.append(ch);
                ++idx;
            }
            if (out.toString().trim().isEmpty() && !list.isEmpty()) {
                return new ParsedLine(list, "");
            }
            return new ParsedLine(list, out.toString());
        }

        private static void extractConditions(String inside, List<ConditionElement> list, boolean negate) {
            int i = 0;
            while (i < inside.length()) {
                char k;
                char c = inside.charAt(i);
                if (Character.isLetter(c)) {
                    list.add(new ConditionElement(c, negate));
                    ++i;
                    continue;
                }
                if (c == '@' && i + 1 < inside.length() && Character.isLetter(k = inside.charAt(i + 1))) {
                    list.add(new ConditionElement(k, negate));
                    i += 2;
                    continue;
                }
                ++i;
            }
        }
    }

    private static class ConditionElement {
        final char key;
        final boolean negate;

        ConditionElement(char key, boolean negate) {
            this.key = key;
            this.negate = negate;
        }
    }
}

