/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.methods.Items;

import cn.superiormc.mythicchanger.manager.ChangesManager;
import cn.superiormc.mythicchanger.objects.ObjectAction;
import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.HookManager;
import cn.superiormc.ultimateshop.managers.ItemManager;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import com.google.common.base.Enums;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class BuildItem {
    public static ItemStack buildItemStack(Player player, ConfigurationSection section, int amount, String ... args) {
        ItemStack item = new ItemStack(Material.STONE);
        return BuildItem.editItemStack(item, player, section, amount, args);
    }

    public static ItemStack editItemStack(ItemStack item, Player player, ConfigurationSection section, int amount, String ... args) {
        ConfigurationSection changeSection;
        ConfigurationSection attributesKey;
        ConfigurationSection enchantsKey;
        List itemFlagKey;
        String rarityKey;
        int maxStackKey;
        int customModelDataKey;
        List lores;
        String itemNameKey;
        ItemMeta meta;
        String materialKey = section.getString("material");
        if (materialKey != null) {
            Material material = Material.getMaterial((String)materialKey.toUpperCase());
            if (material != null) {
                item.setType(material);
            } else {
                ItemStack savedItem = ItemManager.itemManager.getItemByKey(player, section.getString("material"));
                if (savedItem != null) {
                    item = savedItem;
                }
            }
        } else {
            String pluginName = section.getString("hook-plugin");
            Object itemID = section.getString("hook-item");
            Object itemThing = section.get("item");
            if (pluginName != null && itemID != null) {
                if (pluginName.equals("MMOItems") && !((String)itemID).contains(";;")) {
                    itemID = section.getString("hook-item-type") + ";;" + (String)itemID;
                } else if (pluginName.equals("EcoArmor") && !((String)itemID).contains(";;")) {
                    itemID = (String)itemID + ";;" + section.getString("hook-item-type");
                }
                ItemStack hookItem = HookManager.hookManager.getHookItem(player, pluginName, (String)itemID);
                if (hookItem != null) {
                    item = hookItem;
                }
            } else if (itemThing != null) {
                item = UltimateShop.methodUtil.getItemObject(itemThing);
            }
        }
        if (amount > 0) {
            item.setAmount(amount);
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        String displayNameKey = section.getString("name", section.getString("display"));
        if (displayNameKey != null) {
            UltimateShop.methodUtil.setItemName(meta, CommonUtil.modifyString(displayNameKey, args), player);
        }
        if (CommonUtil.getMinorVersion(20, 5) && (itemNameKey = section.getString("item-name")) != null) {
            UltimateShop.methodUtil.setItemItemName(meta, CommonUtil.modifyString(itemNameKey, args), player);
        }
        if (!(lores = section.getStringList("lore")).isEmpty()) {
            UltimateShop.methodUtil.setItemLore(meta, CommonUtil.modifyList(player, lores, args), player);
        }
        if ((customModelDataKey = section.getInt("custom-model-data", section.getInt("cmd", -1))) > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelDataKey));
        }
        if (CommonUtil.getMinorVersion(20, 5) && (maxStackKey = section.getInt("max-stack", -1)) > 0 && maxStackKey < 100) {
            meta.setMaxStackSize(Integer.valueOf(maxStackKey));
        }
        if (CommonUtil.getMinorVersion(20, 5)) {
            ConfigurationSection foodKey = section.getConfigurationSection("food");
            FoodComponent foodComponent = meta.getFood();
            if (foodKey != null) {
                double foodSaturation;
                int foodNutrition;
                if (foodKey.contains("can-always-eat")) {
                    foodComponent.setCanAlwaysEat(foodKey.getBoolean("can-always-eat"));
                }
                if ((foodNutrition = foodKey.getInt("nutrition", -1)) > 0) {
                    foodComponent.setNutrition(foodNutrition);
                }
                if ((foodSaturation = foodKey.getDouble("saturation", -1.0)) > 0.0) {
                    foodComponent.setSaturation((float)foodSaturation);
                }
                ConfigurationSection convertItem = section.getConfigurationSection("convert");
                if (!CommonUtil.getMinorVersion(21, 2)) {
                    double eatSecond = foodKey.getDouble("eat-seconds", -1.0);
                    if (eatSecond >= 0.0) {
                        foodComponent.setEatSeconds((float)eatSecond);
                    }
                    if (CommonUtil.getMajorVersion(21) && convertItem != null) {
                        foodComponent.setUsingConvertsTo(BuildItem.buildItemStack(player, convertItem, convertItem.getInt("amount"), args));
                    }
                    for (String effects : foodKey.getStringList("effects")) {
                        String[] effectParseResult = effects.replace(" ", "").split(",");
                        if (effectParseResult.length < 4) continue;
                        PotionEffectType potionEffectType = null;
                        potionEffectType = CommonUtil.getMajorVersion(20) ? (PotionEffectType)Registry.EFFECT.get(CommonUtil.parseNamespacedKey(effectParseResult[0])) : PotionEffectType.getByName((String)effectParseResult[0]);
                        if (potionEffectType == null) continue;
                        PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.parseInt(effectParseResult[1]), Integer.parseInt(effectParseResult[2]), effectParseResult.length < 5 || Boolean.parseBoolean(effectParseResult[3]), effectParseResult.length < 6 || Boolean.parseBoolean(effectParseResult[4]), effectParseResult.length < 7 || Boolean.parseBoolean(effectParseResult[5]));
                        foodComponent.addEffect(potionEffect, Float.parseFloat(effectParseResult[effectParseResult.length - 1]));
                    }
                }
                meta.setFood(foodComponent);
            }
        }
        if (CommonUtil.getMajorVersion(21)) {
            ConfigurationSection toolKey = section.getConfigurationSection("tool");
            ToolComponent toolComponent = meta.getTool();
            if (toolKey != null) {
                double miningSpeed;
                int damagePerBlock = toolKey.getInt("damage-per-block", -1);
                if (damagePerBlock >= 0) {
                    toolComponent.setDamagePerBlock(damagePerBlock);
                }
                if ((miningSpeed = toolKey.getDouble("mining-speed", -1.0)) > 0.0) {
                    toolComponent.setDefaultMiningSpeed((float)miningSpeed);
                }
                for (String rules : toolKey.getStringList("rules")) {
                    String[] ruleParseResult = rules.replace(" ", "").split(",");
                    if (ruleParseResult.length < 3) continue;
                    ArrayList<Material> materials = new ArrayList<Material>();
                    int i = 0;
                    for (String singleMaterial : ruleParseResult) {
                        Tag tempVal1 = Bukkit.getTag((String)"items", (NamespacedKey)CommonUtil.parseNamespacedKey(singleMaterial), Material.class);
                        if (tempVal1 != null) {
                            float speed = Float.parseFloat(ruleParseResult[1]);
                            boolean correctForDrop = Boolean.parseBoolean(ruleParseResult[2]);
                            toolComponent.addRule(tempVal1, Float.valueOf(speed), Boolean.valueOf(correctForDrop));
                            continue;
                        }
                        Tag tempVal2 = Bukkit.getTag((String)"blocks", (NamespacedKey)CommonUtil.parseNamespacedKey(singleMaterial), Material.class);
                        if (tempVal2 != null) {
                            float speed = Float.parseFloat(ruleParseResult[1]);
                            boolean correctForDrop = Boolean.parseBoolean(ruleParseResult[2]);
                            toolComponent.addRule(tempVal2, Float.valueOf(speed), Boolean.valueOf(correctForDrop));
                            continue;
                        }
                        Material material = Material.getMaterial((String)singleMaterial.toUpperCase());
                        if (material == null) break;
                        materials.add(material);
                        ++i;
                    }
                    if (materials.isEmpty()) continue;
                    float speed = Float.parseFloat(ruleParseResult[i]);
                    boolean correctForDrop = Boolean.parseBoolean(ruleParseResult[i + 1]);
                    toolComponent.addRule(materials, Float.valueOf(speed), Boolean.valueOf(correctForDrop));
                }
                meta.setTool(toolComponent);
            }
        }
        if (CommonUtil.getMajorVersion(21)) {
            JukeboxPlayableComponent jukeboxPlayableComponent = meta.getJukeboxPlayable();
            String song = section.getString("song");
            if (song != null) {
                jukeboxPlayableComponent.setSongKey(CommonUtil.parseNamespacedKey(song));
                if (section.contains("show-song") && !CommonUtil.getMinorVersion(21, 5)) {
                    jukeboxPlayableComponent.setShowInTooltip(section.getBoolean("show-song"));
                }
                meta.setJukeboxPlayable(jukeboxPlayableComponent);
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && section.get("fire-resistant") != null) {
            meta.setFireResistant(section.getBoolean("fire-resistant"));
        }
        if (CommonUtil.getMinorVersion(20, 5) && section.get("hide-tool-tip") != null) {
            meta.setHideTooltip(section.getBoolean("hide-tool-tip"));
        }
        if (CommonUtil.getMinorVersion(20, 5) && section.get("glow") != null) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(section.getBoolean("glow")));
        }
        if (section.get("unbreakable") != null) {
            meta.setUnbreakable(section.getBoolean("unbreakable"));
        }
        if (CommonUtil.getMinorVersion(20, 5) && (rarityKey = section.getString("rarity")) != null) {
            meta.setRarity((ItemRarity)Enums.getIfPresent(ItemRarity.class, (String)rarityKey).or((Object)ItemRarity.COMMON));
        }
        if (!(itemFlagKey = section.getStringList("flags")).isEmpty()) {
            for (String flag : itemFlagKey) {
                ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)(flag = flag.toUpperCase())).orNull();
                if (itemFlag != null) {
                    meta.addItemFlags(new ItemFlag[]{itemFlag});
                }
                if (!CommonUtil.getMinorVersion(20, 6) || itemFlag != ItemFlag.HIDE_ATTRIBUTES || meta.getAttributeModifiers() != null) continue;
                meta.setAttributeModifiers((Multimap)MultimapBuilder.hashKeys().hashSetValues().build());
            }
        }
        if ((enchantsKey = section.getConfigurationSection("enchants")) != null) {
            for (String ench : enchantsKey.getKeys(false)) {
                Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench.toLowerCase()));
                if (vanillaEnchant == null) continue;
                meta.addEnchant(vanillaEnchant, enchantsKey.getInt(ench), true);
            }
        }
        if ((attributesKey = section.getConfigurationSection("attributes")) != null) {
            for (String attribute : attributesKey.getKeys(false)) {
                AttributeModifier modifier;
                EquipmentSlotGroup slot;
                String attribSlot;
                ConfigurationSection subSection;
                Attribute attributeInst = CommonUtil.getMinorVersion(21, 2) ? (Attribute)Registry.ATTRIBUTE.get(CommonUtil.parseNamespacedKey(attribute)) : (Attribute)Enums.getIfPresent(Attribute.class, (String)attribute.toUpperCase(Locale.ENGLISH)).orNull();
                if (attributeInst == null || (subSection = attributesKey.getConfigurationSection(attribute)) == null) continue;
                String attribId = subSection.getString("id");
                UUID id = attribId != null ? UUID.fromString(attribId) : UUID.randomUUID();
                String attribName = subSection.getString("name");
                double attribAmount = subSection.getDouble("amount");
                String attribOperation = subSection.getString("operation");
                if (CommonUtil.getMinorVersion(20, 5)) {
                    EquipmentSlotGroup targetSlot;
                    attribSlot = subSection.getString("slot");
                    slot = EquipmentSlotGroup.ANY;
                    if (attribSlot != null && (targetSlot = EquipmentSlotGroup.getByName((String)attribSlot)) != null) {
                        slot = targetSlot;
                    }
                    if (attribName == null || attribOperation == null) continue;
                    modifier = CommonUtil.getMajorVersion(21) ? new AttributeModifier(CommonUtil.parseNamespacedKey(attribName), attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot) : new AttributeModifier(id, attribName, attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot);
                    meta.addAttributeModifier(attributeInst, modifier);
                    continue;
                }
                attribSlot = subSection.getString("slot");
                EquipmentSlot equipmentSlot = slot = attribSlot != null ? (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)attribSlot).or((Object)EquipmentSlot.HAND) : null;
                if (attribName == null || attribOperation == null) continue;
                modifier = new AttributeModifier(id, attribName, attribAmount, (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)attribOperation).or((Object)AttributeModifier.Operation.ADD_NUMBER), (EquipmentSlot)slot);
                meta.addAttributeModifier(attributeInst, modifier);
            }
        }
        if (meta instanceof Damageable) {
            int maxDamageKey;
            Damageable damageable = (Damageable)meta;
            int damageKey = section.getInt("damage", -1);
            if (damageKey >= 0) {
                damageable.setDamage(damageKey);
            }
            if (CommonUtil.getMinorVersion(20, 5) && (maxDamageKey = section.getInt("max-damage", -1)) > 0) {
                damageable.setMaxDamage(Integer.valueOf(maxDamageKey));
            }
        }
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)meta;
            ConfigurationSection storedEnchantsKey = section.getConfigurationSection("stored-enchants");
            if (storedEnchantsKey != null) {
                for (String ench : storedEnchantsKey.getKeys(false)) {
                    Enchantment vanillaEnchant = (Enchantment)Registry.ENCHANTMENT.get(CommonUtil.parseNamespacedKey(ench.toLowerCase()));
                    if (vanillaEnchant == null) continue;
                    enchantmentStorageMeta.addStoredEnchant(vanillaEnchant, storedEnchantsKey.getInt(ench), true);
                }
            }
        }
        if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ConfigurationSection bannerPatternsKey = section.getConfigurationSection("patterns");
            if (bannerPatternsKey != null) {
                for (String pattern : bannerPatternsKey.getKeys(false)) {
                    PatternType type = null;
                    type = CommonUtil.getMajorVersion(21) ? (PatternType)Registry.BANNER_PATTERN.get(CommonUtil.parseNamespacedKey(pattern)) : (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase()).or((Object)PatternType.BASE);
                    String bannerColor = bannerPatternsKey.getString(pattern);
                    if (type == null || bannerColor == null) continue;
                    DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)bannerColor.toUpperCase()).or((Object)DyeColor.WHITE);
                    banner.addPattern(new Pattern(color, type));
                }
            }
        }
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            String basePotionType = section.getString("base-effect");
            if (basePotionType != null) {
                String[] singlePotion = basePotionType.replace(" ", "").split(",");
                PotionType potionType = (PotionType)Enums.getIfPresent(PotionType.class, (String)singlePotion[0].toUpperCase()).orNull();
                if (CommonUtil.getMinorVersion(20, 5)) {
                    potionMeta.setBasePotionType(potionType);
                } else if (singlePotion.length == 3) {
                    potionMeta.setBasePotionData(new PotionData(potionType, Boolean.parseBoolean(basePotionType.replace(" ", "").split(",")[1]), Boolean.parseBoolean(basePotionType.replace(" ", "").split(",")[2])));
                }
            }
            for (String effects : section.getStringList("effects")) {
                String[] effectParseResult = effects.replace(" ", "").split(",");
                if (effectParseResult.length < 3) continue;
                PotionEffectType potionEffectType = null;
                potionEffectType = CommonUtil.getMajorVersion(20) ? (PotionEffectType)Registry.EFFECT.get(CommonUtil.parseNamespacedKey(effectParseResult[0])) : PotionEffectType.getByName((String)effectParseResult[0]);
                if (potionEffectType == null) continue;
                PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.parseInt(effectParseResult[1]), Integer.parseInt(effectParseResult[2]), effectParseResult.length < 4 || Boolean.parseBoolean(effectParseResult[3]), effectParseResult.length < 5 || Boolean.parseBoolean(effectParseResult[4]), effectParseResult.length < 6 || Boolean.parseBoolean(effectParseResult[5]));
                potionMeta.addCustomEffect(potionEffect, true);
            }
            String potionColor = section.getString("color");
            if (potionColor != null) {
                potionMeta.setColor(CommonUtil.parseColor(potionColor));
            }
        }
        if (CommonUtil.getMajorVersion(20) && meta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)meta;
            ConfigurationSection trim = section.getConfigurationSection("trim");
            if (trim != null) {
                String trimMaterialKey = trim.getString("material");
                String trimPatternKey = trim.getString("pattern");
                if (trimMaterialKey != null && trimPatternKey != null) {
                    NamespacedKey trimMaterialNamespacedKey = CommonUtil.parseNamespacedKey(trimMaterialKey);
                    NamespacedKey trimPatternNamespacedKey = CommonUtil.parseNamespacedKey(trimPatternKey);
                    if (trimMaterialNamespacedKey != null && trimPatternNamespacedKey != null) {
                        TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(trimMaterialNamespacedKey);
                        TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(trimPatternNamespacedKey);
                        if (trimMaterial != null && trimPattern != null) {
                            armorMeta.setTrim(new ArmorTrim(trimMaterial, trimPattern));
                        }
                    }
                }
            }
        }
        if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leather = (LeatherArmorMeta)meta;
            String colorKey = section.getString("color");
            if (colorKey != null) {
                leather.setColor(CommonUtil.parseColor(colorKey));
            }
        }
        if (CommonUtil.getMinorVersion(17, 1) && meta instanceof AxolotlBucketMeta) {
            Axolotl.Variant variant;
            AxolotlBucketMeta bucket = (AxolotlBucketMeta)meta;
            String variantStr = section.getString("color");
            if (variantStr != null && (variant = (Axolotl.Variant)Enums.getIfPresent(Axolotl.Variant.class, (String)variantStr.toUpperCase()).orNull()) != null) {
                bucket.setVariant(variant);
            }
        }
        if (meta instanceof TropicalFishBucketMeta) {
            TropicalFishBucketMeta tropical = (TropicalFishBucketMeta)meta;
            String colorKey = section.getString("color");
            String patternColorKey = section.getString("pattern-color");
            String patternKey = section.getString("pattern");
            if (colorKey != null && patternColorKey != null && patternKey != null) {
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)colorKey).or((Object)DyeColor.WHITE);
                DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patternColorKey).or((Object)DyeColor.WHITE);
                TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)patternKey).or((Object)TropicalFish.Pattern.BETTY);
                tropical.setBodyColor(color);
                tropical.setPatternColor(patternColor);
                tropical.setPattern(pattern);
            }
        }
        if (meta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)meta;
            String skullTextureNameKey = null;
            skullTextureNameKey = section.getString("skull-meta", section.getString("skull"));
            if (skullTextureNameKey != null) {
                if (skullTextureNameKey.length() > 16) {
                    UltimateShop.methodUtil.setSkullMeta(skullMeta, skullTextureNameKey);
                } else {
                    skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)skullTextureNameKey));
                }
            }
        }
        if (meta instanceof FireworkMeta) {
            ConfigurationSection fireworkKey;
            FireworkMeta fireworkMeta = (FireworkMeta)meta;
            int power = section.getInt("power");
            if (power > 0 && power < 128) {
                fireworkMeta.setPower(power);
            }
            if ((fireworkKey = section.getConfigurationSection("firework")) != null) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                for (String fws : fireworkKey.getKeys(false)) {
                    ConfigurationSection colorsSection;
                    ConfigurationSection fw = fireworkKey.getConfigurationSection(fws);
                    if (fw == null) continue;
                    builder.flicker(fw.getBoolean("flicker"));
                    builder.trail(fw.getBoolean("trail"));
                    String fireworkType = fw.getString("type");
                    if (fireworkType != null) {
                        builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fireworkType.toUpperCase()).or((Object)FireworkEffect.Type.STAR));
                    }
                    if ((colorsSection = fw.getConfigurationSection("colors")) == null) continue;
                    ArrayList<Color> colors = new ArrayList<Color>();
                    for (String colorStr : colorsSection.getStringList("base")) {
                        colors.add(CommonUtil.parseColor(colorStr));
                    }
                    builder.withColor(colors);
                    colors = new ArrayList();
                    for (String colorStr : colorsSection.getStringList("fade")) {
                        colors.add(CommonUtil.parseColor(colorStr));
                    }
                    builder.withFade(colors);
                    fireworkMeta.addEffect(builder.build());
                }
            }
        }
        if (meta instanceof FireworkEffectMeta) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)meta;
            ConfigurationSection fireworkKey = section.getConfigurationSection("firework");
            if (fireworkKey != null) {
                ConfigurationSection colorsSection;
                FireworkEffect.Builder builder = FireworkEffect.builder();
                builder.flicker(fireworkKey.getBoolean("flicker"));
                builder.trail(fireworkKey.getBoolean("trail"));
                String fireworkType = fireworkKey.getString("type");
                if (fireworkType != null) {
                    builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fireworkType.toUpperCase()).or((Object)FireworkEffect.Type.STAR));
                }
                if ((colorsSection = fireworkKey.getConfigurationSection("colors")) != null) {
                    ArrayList<Color> colors = new ArrayList<Color>();
                    for (String colorStr : colorsSection.getStringList("base")) {
                        colors.add(CommonUtil.parseColor(colorStr));
                    }
                    builder.withColor(colors);
                    colors = new ArrayList();
                    for (String colorStr : colorsSection.getStringList("fade")) {
                        colors.add(CommonUtil.parseColor(colorStr));
                    }
                    builder.withFade(colors);
                    fireworkEffectMeta.setEffect(builder.build());
                }
            }
        }
        if (meta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta stewMeta = (SuspiciousStewMeta)meta;
            for (String effects : section.getStringList("effects")) {
                String[] effectParseResult = effects.replace(" ", "").split(",");
                if (effectParseResult.length < 3) continue;
                PotionEffectType potionEffectType = null;
                potionEffectType = CommonUtil.getMajorVersion(20) ? (PotionEffectType)Registry.EFFECT.get(CommonUtil.parseNamespacedKey(effectParseResult[0])) : PotionEffectType.getByName((String)effectParseResult[0]);
                if (potionEffectType == null) continue;
                PotionEffect potionEffect = new PotionEffect(potionEffectType, Integer.parseInt(effectParseResult[1]), Integer.parseInt(effectParseResult[2]), effectParseResult.length < 4 || Boolean.parseBoolean(effectParseResult[3]), effectParseResult.length < 5 || Boolean.parseBoolean(effectParseResult[4]), effectParseResult.length < 6 || Boolean.parseBoolean(effectParseResult[5]));
                stewMeta.addCustomEffect(potionEffect, true);
            }
        }
        if (CommonUtil.getMajorVersion(17) && meta instanceof BundleMeta) {
            BundleMeta bundleMeta = (BundleMeta)meta;
            ConfigurationSection bundleContentKey = section.getConfigurationSection("contents");
            if (bundleContentKey != null) {
                for (String key : bundleContentKey.getKeys(false)) {
                    ConfigurationSection contentItemSection = bundleContentKey.getConfigurationSection(key);
                    if (contentItemSection == null) continue;
                    bundleMeta.addItem(BuildItem.buildItemStack(player, contentItemSection, contentItemSection.getInt("amount"), args));
                }
            }
        }
        if (meta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
            BlockState state = blockStateMeta.getBlockState();
            if (state instanceof CreatureSpawner) {
                int spawnerSpawnRange;
                int spawnerPlayerRange;
                int spawnerMaxEntities;
                int spawnerMaxDelayKey;
                int spawnerMinDelayKey;
                CreatureSpawner spawner = (CreatureSpawner)state;
                String spawnerKey = section.getString("spawner");
                if (spawnerKey != null) {
                    EntityType entityType = (EntityType)Enums.getIfPresent(EntityType.class, (String)spawnerKey.toUpperCase()).orNull();
                    if (UltimateShop.methodUtil.methodID().equals("paper") && CommonUtil.getMinorVersion(20, 5) && entityType == EntityType.ITEM) {
                        spawner.setSpawnedType(EntityType.ITEM);
                        ConfigurationSection spawnerItemSection = section.getConfigurationSection("content");
                        if (spawnerItemSection != null) {
                            spawner.setSpawnedItem(BuildItem.buildItemStack(player, spawnerItemSection, spawnerItemSection.getInt("amount"), new String[0]));
                        }
                    } else {
                        spawner.setSpawnedType(entityType);
                    }
                }
                if ((spawnerMinDelayKey = section.getInt("min-delay", -1)) != -1) {
                    spawner.setMinSpawnDelay(spawnerMinDelayKey);
                }
                if ((spawnerMaxDelayKey = section.getInt("max-delay", -1)) != -1) {
                    spawner.setMaxSpawnDelay(spawnerMaxDelayKey);
                }
                if ((spawnerMaxEntities = section.getInt("max-entities", -1)) != -1) {
                    spawner.setMaxNearbyEntities(spawnerMaxEntities);
                }
                if ((spawnerPlayerRange = section.getInt("player-range", -1)) != -1) {
                    spawner.setRequiredPlayerRange(spawnerPlayerRange);
                }
                if ((spawnerSpawnRange = section.getInt("spawn-range", -1)) != -1) {
                    spawner.setSpawnRange(spawnerSpawnRange);
                }
                spawner.update(true);
                blockStateMeta.setBlockState((BlockState)spawner);
            } else if (state instanceof ShulkerBox) {
                ConfigurationSection shulkerContentKey = section.getConfigurationSection("contents");
                if (shulkerContentKey != null) {
                    ShulkerBox box = (ShulkerBox)state;
                    for (String key : shulkerContentKey.getKeys(false)) {
                        ConfigurationSection contentItemSection = shulkerContentKey.getConfigurationSection(key);
                        if (contentItemSection == null) continue;
                        box.getInventory().setItem(Integer.parseInt(key), BuildItem.buildItemStack(player, contentItemSection, contentItemSection.getInt("amount"), args));
                    }
                    box.update(true);
                    blockStateMeta.setBlockState((BlockState)box);
                }
            } else if (CommonUtil.getMajorVersion(20) && state instanceof BrushableBlock) {
                BrushableBlock brushableBlock = (BrushableBlock)state;
                ConfigurationSection brushableContentKey = section.getConfigurationSection("content");
                if (brushableContentKey != null) {
                    brushableBlock.setItem(BuildItem.buildItemStack(player, brushableContentKey, brushableContentKey.getInt("amount"), args));
                }
                blockStateMeta.setBlockState((BlockState)brushableBlock);
            }
        }
        if (CommonUtil.getMinorVersion(20, 5) && meta instanceof OminousBottleMeta) {
            OminousBottleMeta ominousBottleMeta = (OminousBottleMeta)meta;
            int ominousPowerKey = section.getInt("power", -1);
            if (ominousPowerKey > 0) {
                ominousBottleMeta.setAmplifier(ominousPowerKey);
            }
        }
        if (CommonUtil.getMinorVersion(19, 3) && meta instanceof MusicInstrumentMeta) {
            MusicInstrumentMeta musicInstrumentMeta = (MusicInstrumentMeta)meta;
            String musicKey = section.getString("music");
            if (musicKey != null) {
                MusicInstrument musicInstrument = null;
                musicInstrument = CommonUtil.getMinorVersion(20, 4) ? (MusicInstrument)Registry.INSTRUMENT.get(CommonUtil.parseNamespacedKey(musicKey)) : MusicInstrument.getByKey((NamespacedKey)CommonUtil.parseNamespacedKey(musicKey));
                if (musicInstrument != null) {
                    musicInstrumentMeta.setInstrument(musicInstrument);
                }
            }
        }
        if (meta instanceof Repairable) {
            Repairable repairableMeta = (Repairable)meta;
            int repairCost = section.getInt("repair-cost", -1);
            if (repairCost >= 0) {
                repairableMeta.setRepairCost(repairCost);
            }
        }
        if (CommonUtil.getMinorVersion(21, 2)) {
            Tag damageTypeTag;
            ConfigurationSection useCooldown;
            String tooltipStyle;
            String itemModel;
            int enchantable = section.getInt("enchantable", -1);
            if (enchantable >= 0) {
                meta.setEnchantable(Integer.valueOf(enchantable));
            }
            if (section.getString("glider") != null) {
                meta.setGlider(section.getBoolean("glider"));
            }
            if ((itemModel = section.getString("item-model", null)) != null) {
                meta.setItemModel(CommonUtil.parseNamespacedKey(itemModel));
            }
            if ((tooltipStyle = section.getString("tooltip-style", null)) != null) {
                meta.setTooltipStyle(CommonUtil.parseNamespacedKey(tooltipStyle));
            }
            if ((useCooldown = section.getConfigurationSection("use-cooldown")) != null) {
                int cooldownSeconds;
                UseCooldownComponent useCooldownComponent = meta.getUseCooldown();
                String cooldownGroup = useCooldown.getString("cooldown-group", null);
                if (cooldownGroup != null) {
                    useCooldownComponent.setCooldownGroup(CommonUtil.parseNamespacedKey(cooldownGroup));
                }
                if ((cooldownSeconds = useCooldown.getInt("cooldown-seconds", -1)) >= 0) {
                    useCooldownComponent.setCooldownSeconds((float)cooldownSeconds);
                }
            }
            ConfigurationSection equippable = section.getConfigurationSection("equippable");
            String damageResistant = section.getString("damage-resistant");
            if (damageResistant != null && (damageTypeTag = Bukkit.getTag((String)"damage_types", (NamespacedKey)CommonUtil.parseNamespacedKey(damageResistant), DamageType.class)) != null) {
                meta.setDamageResistant(damageTypeTag);
            }
        }
        item.setItemMeta(meta);
        ConfigurationSection componentKey = section.getConfigurationSection("component");
        if (componentKey != null) {
            item = UltimateShop.methodUtil.editItemStack(item, player, componentKey, -1, args);
        }
        ConfigurationSection pluginEnchantsKey = section.getConfigurationSection("plugin-enchants");
        ConfigurationSection nbtSection = section.getConfigurationSection("nbt");
        if (nbtSection == null && componentKey != null) {
            nbtSection = componentKey.getConfigurationSection("custom-data");
        }
        if ((changeSection = section.getConfigurationSection("change-item")) != null && CommonUtil.checkPluginLoad("MythicChanger")) {
            ChangesManager.changesManager.setRealChange(new ObjectAction(), changeSection, item, player);
        }
        return item;
    }
}

