/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.managers.InitManager;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.ItemUtil;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class LocateManager {
    public static LocateManager locateManager;
    private final Map<String, String> locateMap;
    private final String languageFileName;
    private JSONObject fileContent;
    private boolean enabled = false;

    public LocateManager() {
        locateManager = this;
        this.locateMap = new HashMap<String, String>();
        this.languageFileName = ConfigManager.configManager.getString("config-files.minecraft-locate-file.file", new String[0]);
        if (this.languageFileName == null) {
            return;
        }
        File file = new File(UltimateShop.instance.getDataFolder(), this.languageFileName);
        if (!file.exists()) {
            this.downloadLocateFile();
        }
        this.enabled = file.exists();
        if (this.enabled) {
            this.loadLocateFile();
        }
    }

    public void downloadLocateFile() {
        if (!InitManager.initManager.isFirstLoad() && !ConfigManager.configManager.getBoolean("config-files.minecraft-locate-file.generate-new-one")) {
            return;
        }
        UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fDownloading Minecraft locate file, this will cost some time...");
        Object MINECRAFT_VERSION = "1." + UltimateShop.majorVersion + "." + UltimateShop.minorVersion;
        if (((String)MINECRAFT_VERSION).endsWith(".0")) {
            MINECRAFT_VERSION = ((String)MINECRAFT_VERSION).substring(0, ((String)MINECRAFT_VERSION).length() - 2);
        }
        if (this.languageFileName == null) {
            return;
        }
        try {
            String VERSION_MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
            JSONObject versionManifest = CommonUtil.fetchJson(VERSION_MANIFEST_URL);
            JSONArray versions = versionManifest.getJSONArray("versions");
            JSONObject targetVersion = null;
            for (int i = 0; i < versions.length(); ++i) {
                JSONObject version = versions.getJSONObject(i);
                if (!version.getString("id").equals(MINECRAFT_VERSION)) continue;
                targetVersion = version;
                break;
            }
            if (targetVersion == null) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to download Minecraft locate file. Reason: Can not get your Minecraft version!");
                return;
            }
            String versionInfoUrl = targetVersion.getString("url");
            JSONObject versionInfo = CommonUtil.fetchJson(versionInfoUrl);
            String assetIndexUrl = versionInfo.getJSONObject("assetIndex").getString("url");
            JSONObject assetIndex = CommonUtil.fetchJson(assetIndexUrl);
            JSONObject objects = assetIndex.getJSONObject("objects");
            if (!objects.has("minecraft/lang/" + this.languageFileName)) {
                ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to download Minecraft locate file. Reason: Can not find locate file: " + this.languageFileName + "!");
                return;
            }
            String languageFileHash = objects.getJSONObject("minecraft/lang/" + this.languageFileName).getString("hash");
            String downloadUrl = "https://resources.download.minecraft.net/" + languageFileHash.substring(0, 2) + "/" + languageFileHash;
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                 FileOutputStream fos = new FileOutputStream(new File(UltimateShop.instance.getDataFolder(), this.languageFileName));){
                String inputLine;
                while ((inputLine = reader.readLine()) != null) {
                    fos.write(inputLine.getBytes());
                }
            }
        }
        catch (Throwable throwable) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to download Minecraft locate file. Reason: Internet problem!");
            throwable.fillInStackTrace();
        }
    }

    public void loadLocateFile() {
        try {
            FileInputStream fis = new FileInputStream(new File(UltimateShop.instance.getDataFolder(), this.languageFileName));
            this.fileContent = new JSONObject(new JSONTokener(fis));
            fis.close();
        }
        catch (FileNotFoundException e) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to load Minecraft locate file. Reason: Can not find locate file: " + this.languageFileName + "!");
        }
        catch (Throwable throwable) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Failed to load Minecraft locate file. Reason: " + throwable.getMessage() + "!");
            throwable.fillInStackTrace();
        }
    }

    public String getLocateName(ItemStack item) {
        if (!this.enabled) {
            return ItemUtil.getItemNameWithoutVanilla(item);
        }
        if (!this.locateMap.containsKey(item.getTranslationKey())) {
            Object value = this.getValueFromJson(this.fileContent, item.getTranslationKey());
            if (value != null) {
                this.locateMap.put(item.getTranslationKey(), String.valueOf(value));
            } else {
                this.locateMap.put(item.getTranslationKey(), ItemUtil.getItemNameWithoutVanilla(item));
            }
        }
        return this.locateMap.get(item.getTranslationKey());
    }

    private Object getValueFromJson(JSONObject jsonObject, String path) {
        Object json;
        Object value = jsonObject;
        if (value != null) {
            json = value;
            if (!((JSONObject)json).has(path)) {
                return null;
            }
        } else {
            return null;
        }
        value = ((JSONObject)json).get(path);
        return value;
    }

    public static boolean enableThis() {
        if (CommonUtil.getMajorVersion(16)) {
            // empty if block
        }
        return false;
    }
}

