/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.objects.ObjectSellStick;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectConditionalPlaceholder;
import cn.superiormc.ultimateshop.objects.items.subobjects.ObjectRandomPlaceholder;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ConfigManager {
    public static ConfigManager configManager;
    public FileConfiguration config;
    public Map<String, ObjectShop> shopConfigs = new HashMap<String, ObjectShop>();
    public Map<String, ObjectRandomPlaceholder> randomPlaceholders = new HashMap<String, ObjectRandomPlaceholder>();
    public Map<String, ObjectConditionalPlaceholder> conditionalPlaceholders = new HashMap<String, ObjectConditionalPlaceholder>();
    public Map<String, ObjectSellStick> sellStickMap = new HashMap<String, ObjectSellStick>();

    public ConfigManager() {
        configManager = this;
        UltimateShop.instance.saveDefaultConfig();
        this.config = UltimateShop.instance.getConfig();
        this.initShopConfigs();
        this.loadShopConfigs();
        this.initMenuConfigs();
    }

    private void initShopConfigs() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "shops");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.shopConfigs.put(substring, new ObjectShop(substring, YamlConfiguration.loadConfiguration((File)file)));
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7fLoaded shop: " + fileName + "!");
        }
    }

    private void loadShopConfigs() {
        for (ObjectShop shop : this.shopConfigs.values()) {
            shop.initCopyProducts();
            shop.initMenus();
        }
    }

    private void initMenuConfigs() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "menus");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String substring;
            String fileName = file.getName();
            if (!fileName.endsWith(".yml") || ObjectMenu.notCommonMenuNames.contains(substring = fileName.substring(0, fileName.length() - 4)) || ObjectMenu.commonMenus.containsKey(substring)) continue;
            new ObjectMenu(substring);
        }
    }

    private void initSellStickConfigs() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "sell_sticks");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.sellStickMap.put(substring, new ObjectSellStick(substring, (ConfigurationSection)YamlConfiguration.loadConfiguration((File)file)));
        }
    }

    private void initRandomPlaceholder() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "random_placeholders");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.randomPlaceholders.put(substring, new ObjectRandomPlaceholder(substring, (ConfigurationSection)YamlConfiguration.loadConfiguration((File)file)));
        }
        if (this.randomPlaceholders.isEmpty()) {
            ConfigurationSection tempVal1 = this.config.getConfigurationSection("placeholder.random");
            if (tempVal1 == null) {
                return;
            }
            for (String key : tempVal1.getKeys(false)) {
                if (this.randomPlaceholders.containsKey(key)) continue;
                this.randomPlaceholders.put(key, new ObjectRandomPlaceholder(key, tempVal1.getConfigurationSection(key)));
            }
        }
    }

    private void initConditionalPlaceholder() {
        File[] files;
        File dir = new File(UltimateShop.instance.getDataFolder(), "conditional_placeholders");
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!Objects.nonNull(files = dir.listFiles()) && files.length != 0) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            String substring = fileName.substring(0, fileName.length() - 4);
            this.conditionalPlaceholders.put(substring, new ObjectConditionalPlaceholder(substring, (ConfigurationSection)YamlConfiguration.loadConfiguration((File)file)));
        }
    }

    public ObjectShop getShop(String fileName) {
        if (fileName == null) {
            return null;
        }
        ObjectShop shop = this.shopConfigs.get(fileName);
        if (shop == null) {
            return this.shopConfigs.get(fileName.replace('-', '_'));
        }
        return shop;
    }

    public Collection<ObjectShop> getShops() {
        return this.shopConfigs.values();
    }

    public List<ObjectShop> getShopList() {
        ArrayList<ObjectShop> resultShops = new ArrayList<ObjectShop>();
        for (String key : this.shopConfigs.keySet()) {
            resultShops.add(this.shopConfigs.get(key));
        }
        return resultShops;
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<String> getStringListOrDefault(String originalPath, String newPath) {
        if (this.config.getStringList(originalPath).isEmpty()) {
            return this.config.getStringList(newPath);
        }
        return this.config.getStringList(originalPath);
    }

    public List<Integer> getIntList(String path) {
        return this.config.getIntegerList(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBooleanOrDefault(String originalPath, String newPath) {
        return this.config.getBoolean(originalPath, this.config.getBoolean(newPath, false));
    }

    public int getInt(String path, int defaultValue) {
        return this.config.getInt(path, defaultValue);
    }

    public int getIntWithPAPI(Player player, String path, String defaultValue) {
        return Integer.parseInt(TextUtil.withPAPI(this.config.getString(path, defaultValue), player));
    }

    public int getIntOrDefault(String originalPath, String newPath, int defaultValue) {
        return this.config.getInt(originalPath, this.config.getInt(newPath, defaultValue));
    }

    public long getLong(String path, long defaultValue) {
        return this.config.getLong(path, defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        return this.config.getDouble(path, defaultValue);
    }

    public ConfigurationSection getSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public ConfigurationSection getSectionOrDefault(String originalPath, String newPath) {
        ConfigurationSection tempVal1 = this.config.getConfigurationSection(originalPath);
        if (tempVal1 == null) {
            return this.config.getConfigurationSection(newPath);
        }
        return tempVal1;
    }

    public String getString(String path, String ... args) {
        String s = this.config.getString(path);
        if (s == null) {
            if (args.length == 0) {
                return null;
            }
            s = args[0];
        }
        for (int i = 1; i < args.length; i += 2) {
            String var = "{" + args[i] + "}";
            s = args[i + 1] == null ? s.replace(var, "") : s.replace(var, args[i + 1]);
        }
        return s.replace("{plugin_folder}", String.valueOf(UltimateShop.instance.getDataFolder()));
    }

    public String getStringOrDefault(String originalPath, String newPath, String defaultValue) {
        return this.config.getString(originalPath, this.config.getString(newPath, defaultValue));
    }

    public String getClickAction(ClickType type, AbstractButton button) {
        ConfigurationSection tempVal1 = button.getButtonConfig().getConfigurationSection("click-event");
        if (tempVal1 == null && (tempVal1 = this.config.getConfigurationSection("menu.click-event")) == null) {
            return "none";
        }
        for (String s : tempVal1.getKeys(false)) {
            for (String t : tempVal1.getString(s).split(";;")) {
                if (!t.equals(type.name())) continue;
                return s;
            }
        }
        return "none";
    }

    public boolean containsClickAction(String clickEvent) {
        ConfigurationSection clickEventSection = configManager.getSection("menu.click-event");
        if (clickEventSection == null) {
            return false;
        }
        return clickEventSection.contains(clickEvent);
    }

    public ObjectRandomPlaceholder getRandomPlaceholder(String id) {
        return this.randomPlaceholders.get(id);
    }

    public Collection<ObjectRandomPlaceholder> getRandomPlaceholders() {
        return this.randomPlaceholders.values();
    }

    public ObjectConditionalPlaceholder getConditionalPlaceholder(String id) {
        return this.conditionalPlaceholders.get(id);
    }

    public Collection<ObjectConditionalPlaceholder> getConditionalPlaceholders() {
        return this.conditionalPlaceholders.values();
    }

    public ObjectSellStick getSellStick(String id) {
        return this.sellStickMap.get(id);
    }

    public ObjectSellStick getSellStickID(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.getPersistentDataContainer().has(ObjectSellStick.SELL_STICK_ID, PersistentDataType.STRING)) {
            return null;
        }
        String id = (String)meta.getPersistentDataContainer().get(ObjectSellStick.SELL_STICK_ID, PersistentDataType.STRING);
        return this.getSellStick(id);
    }

    public Collection<ObjectSellStick> getSellSticks() {
        return this.sellStickMap.values();
    }
}

