/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.conditions.AbstractCheckCondition;
import cn.superiormc.ultimateshop.objects.conditions.ConditionAny;
import cn.superiormc.ultimateshop.objects.conditions.ConditionBiome;
import cn.superiormc.ultimateshop.objects.conditions.ConditionNot;
import cn.superiormc.ultimateshop.objects.conditions.ConditionPermission;
import cn.superiormc.ultimateshop.objects.conditions.ConditionPlaceholder;
import cn.superiormc.ultimateshop.objects.conditions.ConditionWorld;
import cn.superiormc.ultimateshop.objects.conditions.ObjectSingleCondition;
import java.util.HashMap;
import java.util.Map;

public class ConditionManager {
    public static ConditionManager conditionManager;
    private Map<String, AbstractCheckCondition> conditions;

    public ConditionManager() {
        conditionManager = this;
        this.initConditions();
    }

    private void initConditions() {
        this.conditions = new HashMap<String, AbstractCheckCondition>();
        this.registerNewCondition("biome", new ConditionBiome());
        this.registerNewCondition("permission", new ConditionPermission());
        this.registerNewCondition("placeholder", new ConditionPlaceholder());
        this.registerNewCondition("world", new ConditionWorld());
        this.registerNewCondition("any", new ConditionAny());
        this.registerNewCondition("not", new ConditionNot());
    }

    public void registerNewCondition(String actionID, AbstractCheckCondition condition) {
        if (!this.conditions.containsKey(actionID)) {
            this.conditions.put(actionID, condition);
        }
    }

    public boolean checkBoolean(ObjectSingleCondition condition, ObjectThingRun thingRun) {
        for (AbstractCheckCondition checkCondition : this.conditions.values()) {
            String type = condition.getString("type");
            if (!checkCondition.getType().equals(type) || checkCondition.checkCondition(condition, thingRun)) continue;
            return false;
        }
        return true;
    }
}

