/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.database.AbstractDatabase;
import cn.superiormc.ultimateshop.database.SQLDatabase;
import cn.superiormc.ultimateshop.database.YamlDatabase;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class CacheManager {
    public static CacheManager cacheManager;
    private final Map<Player, ObjectCache> ObjectCacheMap = new ConcurrentHashMap<Player, ObjectCache>();
    public ObjectCache serverCache;
    public AbstractDatabase database;

    public CacheManager() {
        cacheManager = this;
        this.database = ConfigManager.configManager.getBoolean("database.enabled") ? new SQLDatabase() : new YamlDatabase();
        this.database.onInit();
        this.serverCache = new ObjectCache();
    }

    public void addObjectCache(Player player) {
        this.ObjectCacheMap.put(player, new ObjectCache(player));
        this.ObjectCacheMap.get(player).initCache();
    }

    public ObjectCache getObjectCache(Player player) {
        ObjectCache tempVal1 = this.ObjectCacheMap.get(player);
        if (tempVal1 == null) {
            this.addObjectCache(player);
            tempVal1 = this.ObjectCacheMap.get(player);
        }
        return tempVal1;
    }

    public void saveObjectCache(Player player) {
        if (this.ObjectCacheMap.get(player) == null) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCan not save player data: " + player.getName() + "! This is usually because this player joined the server before server fully started OR other plugins kicked this player, ask him rejoin the server.");
            return;
        }
        this.ObjectCacheMap.get(player).shutCache(true);
    }

    public void saveObjectCacheOnDisable(Player player, boolean disable) {
        if (this.ObjectCacheMap.get(player) == null) {
            UltimateShop.methodUtil.sendMessage(null, TextUtil.pluginPrefix() + " \u00a7cCan not save player data: " + player.getName() + "! This is usually because this player joined the server before server fully started OR other plugins kicked this player, ask him rejoin the server.");
            return;
        }
        this.ObjectCacheMap.get(player).shutCacheOnDisable(disable);
    }

    public void removeObjectCache(Player player) {
        if (player != null) {
            this.ObjectCacheMap.remove(player);
        }
    }
}

