/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.managers;

import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.actions.AbstractRunAction;
import cn.superiormc.ultimateshop.objects.actions.ActionAnnouncement;
import cn.superiormc.ultimateshop.objects.actions.ActionAny;
import cn.superiormc.ultimateshop.objects.actions.ActionBuy;
import cn.superiormc.ultimateshop.objects.actions.ActionBuyMoreMenu;
import cn.superiormc.ultimateshop.objects.actions.ActionChance;
import cn.superiormc.ultimateshop.objects.actions.ActionClose;
import cn.superiormc.ultimateshop.objects.actions.ActionConditional;
import cn.superiormc.ultimateshop.objects.actions.ActionConnect;
import cn.superiormc.ultimateshop.objects.actions.ActionConsoleCommand;
import cn.superiormc.ultimateshop.objects.actions.ActionDelay;
import cn.superiormc.ultimateshop.objects.actions.ActionEffect;
import cn.superiormc.ultimateshop.objects.actions.ActionEntitySpawn;
import cn.superiormc.ultimateshop.objects.actions.ActionMessage;
import cn.superiormc.ultimateshop.objects.actions.ActionMythicMobsSpawn;
import cn.superiormc.ultimateshop.objects.actions.ActionOPCommand;
import cn.superiormc.ultimateshop.objects.actions.ActionOpenMenu;
import cn.superiormc.ultimateshop.objects.actions.ActionParticle;
import cn.superiormc.ultimateshop.objects.actions.ActionPlayerCommand;
import cn.superiormc.ultimateshop.objects.actions.ActionSell;
import cn.superiormc.ultimateshop.objects.actions.ActionSellAllMenu;
import cn.superiormc.ultimateshop.objects.actions.ActionShopMenu;
import cn.superiormc.ultimateshop.objects.actions.ActionSound;
import cn.superiormc.ultimateshop.objects.actions.ActionTeleport;
import cn.superiormc.ultimateshop.objects.actions.ActionTitle;
import cn.superiormc.ultimateshop.objects.actions.ActionUpdateGUI;
import cn.superiormc.ultimateshop.objects.actions.ActionUpdateTitle;
import cn.superiormc.ultimateshop.objects.actions.ObjectSingleAction;
import java.util.HashMap;
import java.util.Map;

public class ActionManager {
    public static ActionManager actionManager;
    private Map<String, AbstractRunAction> actions;

    public ActionManager() {
        actionManager = this;
        this.initActions();
    }

    private void initActions() {
        this.actions = new HashMap<String, AbstractRunAction>();
        this.registerNewAction("message", new ActionMessage());
        this.registerNewAction("title", new ActionTitle());
        this.registerNewAction("particle", new ActionParticle());
        this.registerNewAction("sound", new ActionSound());
        this.registerNewAction("announcement", new ActionAnnouncement());
        this.registerNewAction("effect", new ActionEffect());
        this.registerNewAction("console_command", new ActionConsoleCommand());
        this.registerNewAction("op_command", new ActionOPCommand());
        this.registerNewAction("player_command", new ActionPlayerCommand());
        this.registerNewAction("close", new ActionClose());
        this.registerNewAction("teleport", new ActionTeleport());
        this.registerNewAction("entity_spawn", new ActionEntitySpawn());
        this.registerNewAction("mythicmobs_spawn", new ActionMythicMobsSpawn());
        this.registerNewAction("open_menu", new ActionOpenMenu());
        this.registerNewAction("shop_menu", new ActionShopMenu());
        this.registerNewAction("sell_all_menu", new ActionSellAllMenu());
        this.registerNewAction("buy_more_menu", new ActionBuyMoreMenu());
        this.registerNewAction("buy", new ActionBuy());
        this.registerNewAction("sell", new ActionSell());
        this.registerNewAction("chance", new ActionChance());
        this.registerNewAction("delay", new ActionDelay());
        this.registerNewAction("any", new ActionAny());
        this.registerNewAction("conditional", new ActionConditional());
        this.registerNewAction("connect", new ActionConnect());
        this.registerNewAction("update_title", new ActionUpdateTitle());
        this.registerNewAction("update_gui", new ActionUpdateGUI());
    }

    public void registerNewAction(String actionID, AbstractRunAction action) {
        if (!this.actions.containsKey(actionID)) {
            this.actions.put(actionID, action);
        }
    }

    public void doAction(ObjectSingleAction action, ObjectThingRun thingRun) {
        for (AbstractRunAction runAction : this.actions.values()) {
            String type = action.getString("type");
            if (!runAction.getType().equals(type)) continue;
            runAction.runAction(action, thingRun);
        }
    }
}

