/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.listeners;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.AbstractGUI;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import cn.superiormc.ultimateshop.utils.PacketInventoryUtil;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;

public class GUIListener
implements Listener {
    private final Player player;
    private final InvGUI gui;

    public GUIListener(InvGUI gui) {
        this.gui = gui;
        this.player = gui.getPlayer();
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        try {
            if (e.getWhoClicked().equals((Object)this.player)) {
                if (!Objects.equals(e.getClickedInventory(), this.gui.getInv())) {
                    if (e.getClick().isShiftClick() || e.getClick() == ClickType.DOUBLE_CLICK || ConfigManager.configManager.getBoolean("menu.ignore-click-outside")) {
                        e.setCancelled(!this.gui.getChangeable());
                    }
                    return;
                }
                if (e.getClick() == ClickType.DOUBLE_CLICK) {
                    e.setCancelled(!this.gui.getChangeable());
                    return;
                }
                if (this.gui.getCooldown()) {
                    e.setCancelled(true);
                    return;
                }
                this.gui.addCooldown();
                if (this.gui.clickEventHandle(e.getClickedInventory(), e.getClick(), e.getSlot())) {
                    e.setCancelled(true);
                }
                this.gui.afterClickEventHandle(e.getCursor(), e.getCurrentItem(), e.getSlot());
                if (CommonUtil.getMajorVersion(16) && e.getClick() == ClickType.SWAP_OFFHAND && e.isCancelled()) {
                    this.player.getInventory().setItemInOffHand(this.player.getInventory().getItemInOffHand());
                }
                if (ConfigManager.configManager.getBoolean("menu.title-update.click-update") && UltimateShop.usePacketEvents) {
                    PacketInventoryUtil.packetInventoryUtil.updateTitle(this.player, this.gui);
                }
            }
        }
        catch (Throwable throwable) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cError: Your menu configs has wrong, error message: " + throwable.getMessage());
            throwable.printStackTrace();
            AbstractGUI.playerList.remove(this.player);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (e.getWhoClicked().equals((Object)this.player) && this.gui.dragEventHandle(e.getNewItems())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getPlayer().equals((Object)this.player)) {
            if (!Objects.equals(e.getInventory(), this.gui.getInv())) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
            if (UltimateShop.usePacketEvents) {
                PacketInventoryUtil.packetInventoryUtil.clear(this.player);
            }
            this.player.updateInventory();
            if (AbstractGUI.playerList.containsKey(this.player)) {
                this.gui.removeOpenGUIStatus();
            }
            if (this.gui.closeEventHandle(e.getInventory()) && this.gui.getMenu() != null) {
                this.gui.getMenu().doCloseAction(this.player);
            }
        }
    }

    @EventHandler
    public void onSwap(PlayerSwapHandItemsEvent e) {
        if (e.getPlayer().equals((Object)this.player)) {
            e.setCancelled(true);
        }
    }
}

