/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.hooks.economy;

import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import dev.unnm3d.rediseconomy.api.RedisEconomyAPI;
import dev.unnm3d.rediseconomy.currency.Currency;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyRedisEconomyHook
extends AbstractEconomyHook {
    private final RedisEconomyAPI api = RedisEconomyAPI.getAPI();

    public EconomyRedisEconomyHook() {
        super("RedisEconomy");
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        Currency redisCurrency = this.api.getCurrencyByName(currencyID);
        if (redisCurrency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in RedisEconomy plugin!");
            return 0.0;
        }
        return redisCurrency.getBalance((OfflinePlayer)player);
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        Currency redisCurrency = this.api.getCurrencyByName(currencyID);
        if (redisCurrency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in RedisEconomy plugin!");
            return;
        }
        redisCurrency.withdrawPlayer((OfflinePlayer)player, value);
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        Currency redisCurrency = this.api.getCurrencyByName(currencyID);
        if (redisCurrency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in RedisEconomy plugin!");
            return;
        }
        redisCurrency.depositPlayer((OfflinePlayer)player, value);
    }

    @Override
    public boolean isEnabled() {
        if (this.api == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not hook into RedisEconomy plugin!");
            return true;
        }
        return true;
    }
}

