/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.hooks.economy;

import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import org.bukkit.entity.Player;
import ru.soknight.peconomy.api.PEconomyAPI;
import ru.soknight.peconomy.database.model.WalletModel;

public class EconomyPEconomyHook
extends AbstractEconomyHook {
    private final PEconomyAPI peAPI = PEconomyAPI.get();

    public EconomyPEconomyHook() {
        super("PEconomy");
    }

    @Override
    public boolean hasEnoughEconomy(Player player, double value, String currencyID) {
        return this.peAPI.hasAmount(player.getName(), currencyID, (float)((int)value));
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        return this.peAPI.getAmount(player.getName(), currencyID);
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        WalletModel wallet = this.peAPI.getWallet(player.getName());
        wallet.takeAmount(currencyID, (float)((int)value));
        this.peAPI.updateWallet(wallet);
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        WalletModel wallet = this.peAPI.getWallet(player.getName());
        wallet.addAmount(currencyID, (float)((int)value));
        this.peAPI.updateWallet(wallet);
    }

    @Override
    public boolean isEnabled() {
        if (this.peAPI == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not hook into PEconomy plugin!");
            return false;
        }
        return true;
    }
}

