/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.hooks.economy;

import cn.superiormc.ultimateshop.hooks.economy.AbstractEconomyHook;
import cn.superiormc.ultimateshop.managers.ErrorManager;
import org.bukkit.entity.Player;
import su.nightexpress.coinsengine.api.CoinsEngineAPI;
import su.nightexpress.coinsengine.api.currency.Currency;

public class EconomyCoinsEngineHook
extends AbstractEconomyHook {
    public EconomyCoinsEngineHook() {
        super("CoinsEngine");
    }

    @Override
    public double getEconomy(Player player, String currencyID) {
        Currency currency = CoinsEngineAPI.getCurrency((String)currencyID);
        if (currency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in CoinsEngine plugin!");
            return 0.0;
        }
        return CoinsEngineAPI.getBalance((Player)player, (Currency)currency);
    }

    @Override
    public void takeEconomy(Player player, double value, String currencyID) {
        Currency currency = CoinsEngineAPI.getCurrency((String)currencyID);
        if (currency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in CoinsEngine plugin!");
            return;
        }
        CoinsEngineAPI.removeBalance((Player)player, (Currency)currency, (double)value);
    }

    @Override
    public void giveEconomy(Player player, double value, String currencyID) {
        Currency currency = CoinsEngineAPI.getCurrency((String)currencyID);
        if (currency == null) {
            ErrorManager.errorManager.sendErrorMessage("\u00a7cCan not find currency " + currencyID + " in CoinsEngine plugin!");
            return;
        }
        CoinsEngineAPI.addBalance((Player)player, (Currency)currency, (double)value);
    }
}

