/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.gui.form.FormShopGUI;
import cn.superiormc.ultimateshop.managers.CacheManager;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectShop;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.caches.ObjectCache;
import cn.superiormc.ultimateshop.objects.caches.ObjectUseTimesCache;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShopGUI
extends InvGUI {
    private final ObjectShop shop;
    private final ObjectMenu shopMenu;
    private final boolean bypass;

    private ShopGUI(Player owner, ObjectShop shop, ObjectMenu shopMenu, boolean bypass) {
        super(owner);
        this.shop = shop;
        this.bypass = bypass;
        this.shopMenu = shopMenu;
    }

    @Override
    public void constructGUI() {
        ObjectCache tempVal1 = CacheManager.cacheManager.getObjectCache(this.player);
        ObjectCache tempVal2 = CacheManager.cacheManager.serverCache;
        if (tempVal1 == null) {
            LanguageManager.languageManager.sendStringText(this.player, "error.player-not-found", "player", this.player.getName());
            return;
        }
        if (!this.bypass && !this.shopMenu.getCondition().getAllBoolean(new ObjectThingRun(this.player))) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.shop.getShopMenu());
            return;
        }
        for (ObjectItem tempVal5 : this.shop.getProductListNotHidden(this.player)) {
            ObjectUseTimesCache tempVal4;
            ObjectUseTimesCache tempVal3 = tempVal1.getUseTimesCache().get(tempVal5);
            if (tempVal3 != null) {
                tempVal3.refreshTimes();
            }
            if ((tempVal4 = tempVal2.getUseTimesCache().get(tempVal5)) == null) continue;
            tempVal4.refreshTimes();
        }
        this.menuButtons = this.shopMenu.getMenu(MenuSender.of(this.player));
        this.menuItems = this.getMenuItems(this.player);
        ObjectMenu menu = this.shop.getShopMenuObject();
        if (menu != null) {
            this.title = this.shop.getShopMenuObject().getString("title", this.shop.getShopDisplayName()).replace("{shop-name}", this.shop.getShopDisplayName());
            if (Objects.isNull(this.inv)) {
                this.inv = UltimateShop.methodUtil.createNewInv(this.player, this.shop.getShopMenuObject().getInt("size", 54), this.title);
            }
        }
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        if (this.menuButtons.get(slot) == null) {
            return true;
        }
        ((AbstractButton)this.menuButtons.get(slot)).clickEvent(type, this.player);
        if (ConfigManager.configManager.getBooleanOrDefault("menu.shop.click-update", "menu.menu-update.click-update")) {
            this.constructGUI();
        } else {
            this.updateSlot(slot);
        }
        return true;
    }

    @Override
    public ObjectMenu getMenu() {
        return this.shop.getShopMenuObject();
    }

    public void updateSlot(int slot) {
        this.menuItems.put(slot, this.getMenuItem(this.player, slot));
        this.inv.setItem(slot, (ItemStack)this.menuItems.get(slot));
    }

    public static void openGUI(Player player, ObjectShop shop, boolean bypass, boolean reopen) {
        if (shop == null) {
            return;
        }
        ObjectMenu shopMenu = shop.getShopMenuObject();
        if (shopMenu == null) {
            LanguageManager.languageManager.sendStringText(player, "error.shop-does-not-have-menu", "shop", shop.getShopName());
            return;
        }
        if (shopMenu.menuConfigs == null) {
            LanguageManager.languageManager.sendStringText(player, "error.shop-menu-not-found", "shop", shop.getShopName(), "menu", shop.getShopMenu());
            return;
        }
        if (UltimateShop.useGeyser && shopMenu.isUseGeyser() && CommonUtil.isBedrockPlayer(player)) {
            FormShopGUI formShopGUI = new FormShopGUI(player, shop, shopMenu, bypass);
            formShopGUI.openGUI(reopen);
            return;
        }
        ShopGUI gui = new ShopGUI(player, shop, shopMenu, bypass);
        gui.openGUI(reopen);
    }
}

