/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.inv;

import cn.superiormc.ultimateshop.UltimateShop;
import cn.superiormc.ultimateshop.gui.InvGUI;
import cn.superiormc.ultimateshop.managers.ConfigManager;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.methods.Product.SellProductMethod;
import cn.superiormc.ultimateshop.methods.ProductTradeStatus;
import cn.superiormc.ultimateshop.objects.buttons.ObjectItem;
import cn.superiormc.ultimateshop.objects.items.AbstractSingleThing;
import cn.superiormc.ultimateshop.objects.items.ThingMode;
import cn.superiormc.ultimateshop.objects.items.prices.ObjectPrices;
import cn.superiormc.ultimateshop.utils.CommonUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SellAllGUI
extends InvGUI {
    private SellAllGUI(Player owner) {
        super(owner);
    }

    @Override
    public void constructGUI() {
        this.title = ConfigManager.configManager.getString("menu.sell-all.title", new String[0]);
        if (Objects.isNull(this.inv)) {
            this.inv = UltimateShop.methodUtil.createNewInv(this.player, ConfigManager.configManager.getInt("menu.sell-all.size", 54), this.title);
        }
    }

    @Override
    public boolean clickEventHandle(Inventory inventory, ClickType type, int slot) {
        return ConfigManager.configManager.getIntList("menu.sell-all.black-slots").contains(slot);
    }

    @Override
    public boolean closeEventHandle(Inventory inventory) {
        if (this.runTask != null) {
            this.runTask.cancel();
        }
        if (this.player == null) {
            return true;
        }
        int nowAmount = 0;
        int afterAmount = 0;
        for (ItemStack item : this.inv.getStorageContents()) {
            if (item == null) continue;
            nowAmount += item.getAmount();
        }
        HashMap<AbstractSingleThing, BigDecimal> result = new HashMap<AbstractSingleThing, BigDecimal>();
        boolean firstSell = false;
        for (String shop : ConfigManager.configManager.shopConfigs.keySet()) {
            for (ObjectItem products : ConfigManager.configManager.getShop(shop).getProductListNotHidden(this.player)) {
                if (ConfigManager.configManager.getStringListOrDefault("menu.sell-all.ignore-items", "sell.sell-all.ignore-items").contains(shop + ";;" + products.getProduct())) continue;
                ProductTradeStatus status = SellProductMethod.startSell(this.inv, products, this.player, false, false, true, firstSell, 1, 1.0);
                if (status.getStatus() == ProductTradeStatus.Status.DONE && status.getGiveResult() != null) {
                    result.putAll(status.getGiveResult().getResultMap());
                }
                if (products.getSellAction().isEmpty()) continue;
                firstSell = true;
            }
        }
        if (!result.isEmpty()) {
            for (ItemStack item : this.inv.getStorageContents()) {
                if (item == null) continue;
                afterAmount += item.getAmount();
            }
            LanguageManager.languageManager.sendStringText(this.player, "start-sell-all", "amount", String.valueOf(nowAmount - afterAmount), "reward", ObjectPrices.getDisplayNameInLine(this.player, 1, result, ThingMode.ALL, true));
        }
        ItemStack[] storage = (ItemStack[])Arrays.stream(this.inv.getStorageContents()).filter(Objects::nonNull).toArray(ItemStack[]::new);
        CommonUtil.giveOrDrop(this.player, storage);
        return super.closeEventHandle(inventory);
    }

    @Override
    public boolean dragEventHandle(Map<Integer, ItemStack> newItems) {
        this.player.updateInventory();
        for (int i : newItems.keySet()) {
            if (!ConfigManager.configManager.getIntList("menu.sell-all.black-slots").contains(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getChangeable() {
        return true;
    }

    public static void openGUI(Player player) {
        SellAllGUI gui = new SellAllGUI(player);
        gui.openGUI(true);
    }
}

