/*
 * Decompiled with CFR 0.152.
 */
package cn.superiormc.ultimateshop.gui.form;

import cn.superiormc.ultimateshop.gui.FormGUI;
import cn.superiormc.ultimateshop.managers.LanguageManager;
import cn.superiormc.ultimateshop.objects.ObjectThingRun;
import cn.superiormc.ultimateshop.objects.buttons.AbstractButton;
import cn.superiormc.ultimateshop.objects.buttons.subobjects.ObjectDisplayItemStack;
import cn.superiormc.ultimateshop.objects.menus.MenuSender;
import cn.superiormc.ultimateshop.objects.menus.ObjectMenu;
import cn.superiormc.ultimateshop.utils.TextUtil;
import java.util.Iterator;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.form.SimpleForm;

public class FormCommonGUI
extends FormGUI {
    private ObjectMenu commonMenu;
    private final boolean bypass;

    public FormCommonGUI(Player owner, ObjectMenu menu, boolean bypass) {
        super(owner);
        this.bypass = bypass;
        this.commonMenu = menu;
        this.constructGUI();
    }

    @Override
    public void constructGUI() {
        if (!this.bypass && !this.commonMenu.getCondition().getAllBoolean(new ObjectThingRun(this.player))) {
            LanguageManager.languageManager.sendStringText(this.player, "menu-condition-not-meet", "menu", this.commonMenu.getName());
            return;
        }
        this.menuButtons = this.commonMenu.getMenu(MenuSender.of(this.player));
        SimpleForm.Builder tempVal2 = SimpleForm.builder();
        Iterator iterator = this.menuButtons.keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            AbstractButton button = (AbstractButton)this.menuButtons.get(slot);
            ObjectDisplayItemStack displayItem = button.getDisplayItem(this.player, 1);
            ButtonComponent tempVal1 = displayItem.parseToBedrockButton();
            if (tempVal1 != null) {
                tempVal2.button(tempVal1);
            }
            this.menuItems.put(tempVal1, slot);
        }
        tempVal2.title(TextUtil.parse(this.player, this.commonMenu.getString("title", "Shop")));
        tempVal2.validResultHandler(response -> {
            ((AbstractButton)this.menuButtons.get(this.menuItems.get(response.clickedButton()))).clickEvent(ClickType.LEFT, this.player);
            this.removeOpenGUIStatus();
        });
        tempVal2.closedOrInvalidResultHandler(response -> this.removeOpenGUIStatus());
        if (this.commonMenu.getString("bedrock.content", null) != null) {
            tempVal2.content(TextUtil.parse(this.player, this.getMenu().getString("bedrock.content", "")));
        }
        this.form = tempVal2.build();
    }

    @Override
    public ObjectMenu getMenu() {
        return this.commonMenu;
    }
}

